/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui;

import gregtech.api.enums.ItemList;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.common.gui.GT_Container_DataReader;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_OreDrillingPlantBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GT_GUIContainer_DataReader
extends GuiContainer {
    public ResourceLocation mBackground;
    public ResourceLocation mProgress;
    ItemStack mTool;
    EntityPlayer mPlayer;
    NBTTagCompound localNbtWithPagesData;

    public GT_GUIContainer_DataReader(ItemStack aTool, EntityPlayer aPlayer) {
        super((Container)new GT_Container_DataReader(aPlayer.field_71071_by, aTool));
        this.mTool = aTool;
        this.mPlayer = aPlayer;
        this.field_147000_g = 256;
        this.mBackground = new ResourceLocation("gregtech:textures/gui/DataReader.png");
        this.mProgress = new ResourceLocation("gregtech:textures/gui/multimachines/Progress.png");
    }

    public NBTTagCompound getTranslatedNbt(NBTTagCompound origOrbNbt) {
        if (this.localNbtWithPagesData != null && this.isDataOrbsNbtEqual(this.localNbtWithPagesData, origOrbNbt)) {
            return this.localNbtWithPagesData;
        }
        this.localNbtWithPagesData = GT_MetaTileEntity_OreDrillingPlantBase.getTranslatedDataOrbNbtPages(origOrbNbt);
        return this.localNbtWithPagesData;
    }

    public boolean isDataOrbsNbtEqual(NBTTagCompound nbt1, NBTTagCompound nbt2) {
        return nbt1.func_74762_e("coordX") == nbt2.func_74762_e("coordX") && nbt1.func_74762_e("coordY") == nbt2.func_74762_e("coordY") && nbt1.func_74762_e("coordZ") == nbt2.func_74762_e("coordZ") && nbt1.func_74762_e("dimensionId") == nbt2.func_74762_e("dimensionId");
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.mBackground);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.mTool = this.mPlayer.func_70694_bm();
        if (!ItemList.Tool_DataReader_MV.isStackEqual(this.mTool, false, true) && !ItemList.Tool_DataReader_EV.isStackEqual(this.mTool, false, true)) {
            return;
        }
        ItemStack aStick = ((GT_Container_DataReader)this.field_147002_h).mInventory.func_70301_a(0);
        if (aStick == null) {
            this.localNbtWithPagesData = null;
            return;
        }
        NBTTagCompound tNBT = aStick.func_77978_p();
        if (tNBT == null) {
            this.localNbtWithPagesData = null;
            return;
        }
        if (ItemList.Tool_DataOrb.isStackEqual(aStick, false, true)) {
            this.drawPages(this.getTranslatedNbt(tNBT));
            return;
        }
        int tProgress = this.mTool.func_77978_p().func_74762_e("prog");
        if (!tNBT.func_74764_b("pages") && tProgress == 0) {
            return;
        }
        if (!ItemList.Tool_DataStick.isStackEqual(aStick, false, true) && !ItemList.Tool_CD.isStackEqual(aStick, false, true)) {
            return;
        }
        if (this.mTool == null || this.mTool.func_77978_p() == null) {
            return;
        }
        if (tProgress > 0) {
            int tier = ((GT_MetaBase_Item)this.mTool.func_77973_b()).getTier(this.mTool);
            double tBarLength = (double)tProgress / 1000.0 * (double)(1 << tier - 2);
            int xOff = 28;
            int yOff = 75;
            this.field_146289_q.func_78279_b("Scanning...", x + xOff, y + yOff - 20, 200, -1);
            this.field_146289_q.func_78279_b("Progress: " + tProgress / 20 + "/" + 50 / (1 << tier - 2), x + xOff, y + yOff - 10, 200, -1);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.mProgress);
            this.func_73729_b(x + xOff + 2, y + yOff + 1, 0, 226, Math.min(113, (int)(tBarLength * 113.0)), 13);
            this.func_73729_b(x + xOff, y + yOff - 1, 0, 239, 119, 17);
            return;
        }
        this.drawPages(tNBT);
    }

    protected void drawPages(NBTTagCompound tNBT) {
        int tPage = this.mTool.func_77978_p().func_74762_e("page");
        NBTTagList pages = tNBT.func_150295_c("pages", 8);
        String s = pages.func_150307_f(tPage);
        if (s == null) {
            s = "";
        }
        GL11.glPushMatrix();
        GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
        this.field_146289_q.func_78279_b(s, (int)((double)(this.field_147003_i + 10) * 10.0 / 7.0), (int)((double)(this.field_147009_r + 10) * 10.0 / 7.0), 200, -1);
        GL11.glPopMatrix();
    }
}

