/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui;

import gregtech.api.gui.GT_Container_Fusion;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainerMetaTile_Machine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;

public class GT_GUIContainer_FusionReactor
extends GT_GUIContainerMetaTile_Machine {
    public String mNEI;
    String mName = "";
    ResourceLocation mProgressIcon = new ResourceLocation("gregtech:textures/gui/multimachines/Progress.png");

    public GT_GUIContainer_FusionReactor(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity, String aName, String aTextureFile, String aNEI) {
        super(new GT_Container_Fusion(aInventoryPlayer, aTileEntity, false), "gregtech:textures/gui/multimachines/" + (aTextureFile == null ? "MultiblockDisplay" : aTextureFile));
        this.mName = aName;
        this.mNEI = aNEI;
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        int x = par1 - xStart;
        int y = par2 - yStart;
        if (this.field_147002_h.func_75139_a(1) != null && this.isTheMouseOverSlot(this.field_147002_h.func_75139_a(1), x, y, 17, 1)) {
            this.drawHoveringText(Arrays.asList(this.getButtonToolTip()), par1, par2, this.field_146289_q);
            RenderHelper.func_74520_c();
        }
    }

    public String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_" + aKey, aEnglish, false);
    }

    protected String[] getButtonToolTip() {
        switch (this.getMode()) {
            case 3: {
                return new String[]{this.trans("200", "Running perfectly")};
            }
            case 2: {
                return new String[]{this.trans("201", "Enabled, waiting for inputs")};
            }
            case 1: {
                return new String[]{this.trans("202", "Disabled, working last cycle and turning off")};
            }
            case 0: {
                return new String[]{this.trans("203", "Disabled")};
            }
        }
        return new String[0];
    }

    protected int getMode() {
        if (this.mContainer.mTileEntity != null) {
            if (this.mContainer.mAllowedToWork == 1) {
                if (this.mContainer.mProgressTime > 0) {
                    return 3;
                }
                return 2;
            }
            if (this.mContainer.mProgressTime > 0) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(this.mName, 8, -10, 0xFAFAFF);
        if (this.mContainer != null) {
            if ((((GT_Container_MultiMachine)this.mContainer).mDisplayErrorCode & 0x40) != 0) {
                this.field_146289_q.func_78276_b("Incomplete Structure.", 10, 8, 0xFAFAFF);
            }
            if (((GT_Container_MultiMachine)this.mContainer).mDisplayErrorCode == 0) {
                if (((GT_Container_MultiMachine)this.mContainer).mActive == 0) {
                    this.field_146289_q.func_78276_b("Hit with Soft Hammer to (re-)start the Machine if it doesn't start.", -70, 170, 0xFAFAFF);
                } else {
                    this.field_146289_q.func_78276_b("Running perfectly.", 10, 170, 0xFAFAFF);
                }
            }
            if (this.mContainer.mEnergy > 160000000 && this.mContainer.mEnergy < 160010000) {
                this.field_146289_q.func_78276_b("160,000,000 EU", 50, 155, 0xFF0000);
            } else if (this.mContainer.mEnergy > 320000000 && this.mContainer.mEnergy < 320010000) {
                this.field_146289_q.func_78276_b("320,000,000 EU", 50, 155, 0xFF0000);
            } else if (this.mContainer.mEnergy > 640000000 && this.mContainer.mEnergy < 640010000) {
                this.field_146289_q.func_78276_b("640,000,000 EU", 50, 155, 0xFF0000);
            } else {
                this.field_146289_q.func_78276_b(GT_Utility.formatNumbers(this.mContainer.mEnergy) + " EU", 50, 155, 0xFF0000);
            }
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.mContainer != null) {
            double tScale = (double)this.mContainer.mEnergy / (double)this.mContainer.mStorage;
            this.func_73729_b(x + 5, y + 156, 0, 251, Math.min(147, (int)(tScale * 148.0)), 5);
            this.field_146297_k.field_71446_o.func_110577_a(this.mProgressIcon);
            if (this.mContainer.mActive == 0) {
                this.func_73729_b(x + 138, y + 9, 238, 0, 9, 9);
            } else {
                this.func_73729_b(x + 138, y + 9, 247, 0, 9, 9);
            }
            switch (this.getMode()) {
                case 3: {
                    this.func_73729_b(x + 157, y + 24, 238, 41, 14, 14);
                    break;
                }
                case 1: 
                case 2: {
                    this.func_73729_b(x + 157, y + 24, 238, 26, 14, 14);
                    break;
                }
                case 0: {
                    this.func_73729_b(x + 157, y + 24, 238, 11, 14, 14);
                }
            }
        }
    }
}

