/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import gregtech.common.items.behaviors.Behaviour_None;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;

public class Behaviour_ProspectorsBook
extends Behaviour_None {
    private static int radius;
    private static int near;
    private static int middle;
    private static int step;
    public static String[] types;
    public static HashSet<String> prospectingOres;
    public static final IItemBehaviour<GT_MetaBase_Item> INSTANCE;
    private final String mTooltip = GT_LanguageManager.addStringLocalization("gt.behaviour.prospecting", "Looks old, really old");

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onItemUse(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        if (GT_Utility.isStringValid(GT_Utility.ItemNBT.getBookTitle(aStack)) && aPlayer instanceof EntityPlayerSP) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBook(aPlayer, aStack, false));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        if (GT_Utility.isStringValid(GT_Utility.ItemNBT.getBookTitle(aStack)) && aPlayer instanceof EntityPlayerSP) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBook(aPlayer, aStack, false));
        }
        return aPlayer instanceof EntityPlayerMP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack onItemRightClick(GT_MetaBase_Item aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (GT_Utility.isStringValid(GT_Utility.ItemNBT.getBookTitle(aStack)) && aPlayer instanceof EntityPlayerSP) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBook(aPlayer, aStack, false));
        }
        return aStack;
    }

    @Override
    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }

    private static String prospectWater(World aWorld, int aX, int aZ) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                Chunk tChunk = aWorld.func_72938_d(aX + 96 * x, aZ + 96 * z);
                FluidStack aFluid = GT_UndergroundOil.undergroundOilReadInformation(tChunk);
                if (!GT_ModHandler.isWater(aFluid)) continue;
                return "" + (aX + 96 * x) + "|" + (aZ + 96 * z) + "|" + aFluid.getLocalizedName();
            }
        }
        return "";
    }

    private static void prospectOres(Map<String, ArrayList<int[]>> aAllOres, Map<String, Integer> aNearOres, Map<String, Integer> aMiddleOres, Map<String, Integer> aFarOres, World aWorld, int aX, int aY, int aZ) {
        int tLeftXBound = aX - radius;
        int tRightXBound = tLeftXBound + 2 * radius;
        int tLeftZBound = aZ - radius;
        int tRightZBound = tLeftZBound + 2 * radius;
        int x = 0;
        int z = 0;
        int i = 0;
        while ((float)i <= (float)radius / (float)step * 4.0f) {
            int dirx = 0;
            int dirz = 0;
            switch (i % 4) {
                case 0: {
                    ++dirx;
                    break;
                }
                case 1: {
                    ++dirz;
                    break;
                }
                case 2: {
                    --dirx;
                    break;
                }
                case 3: {
                    --dirz;
                }
            }
            int size = (i + 1) / 2;
            for (int j = 0; j < size; ++j) {
                Behaviour_ProspectorsBook.prospectHole(aX + (x += dirx), aZ + (z += dirz), aAllOres, aWorld, aY);
            }
            ++i;
        }
    }

    private static void prospectHole(int i, int k, Map<String, ArrayList<int[]>> aOres, World aWorld, int aY) {
        for (int j = aY; j > 0; --j) {
            Behaviour_ProspectorsBook.checkForOre(i, j, k, aWorld, aOres);
        }
    }

    private static String checkForOre(int x, int y, int z, World aWorld, Map<String, ArrayList<int[]>> map) {
        Materials tMaterial;
        TileEntity tTileEntity;
        Block tBlock = aWorld.func_147439_a(x, y, z);
        if (tBlock instanceof GT_Block_Ores_Abstract && (tTileEntity = aWorld.func_147438_o(x, y, z)) instanceof GT_TileEntity_Ores && ((GT_TileEntity_Ores)tTileEntity).mMetaData < 16000 && (tMaterial = GregTech_API.sGeneratedMaterials[((GT_TileEntity_Ores)tTileEntity).mMetaData % 1000]) != null && tMaterial != Materials._NULL) {
            Behaviour_ProspectorsBook.putOre(map, tMaterial.mName, x, y, z);
            return tMaterial.mDefaultLocalName;
        }
        return null;
    }

    private static void putOre(Map<String, ArrayList<int[]>> map, String ore, int aX, int aY, int aZ) {
        if (!prospectingOres.contains(ore)) {
            return;
        }
        ArrayList<int[]> coords = map.get(ore);
        coords = coords == null ? new ArrayList<int[]>() : coords;
        coords.add(new int[]{aX, aY, aZ});
        map.put(ore, coords);
    }

    public static ItemStack getBook(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        ItemStack aStack = ItemList.ProspectorsBook.get(1L, new Object[0]);
        HashMap<String, Integer> tNearOres = new HashMap<String, Integer>();
        HashMap<String, Integer> tMiddleOres = new HashMap<String, Integer>();
        HashMap<String, Integer> tFarOres = new HashMap<String, Integer>();
        HashMap<String, ArrayList<int[]>> allOres = new HashMap<String, ArrayList<int[]>>();
        Behaviour_ProspectorsBook.prospectOres(allOres, tNearOres, tMiddleOres, tFarOres, aWorld, aX, aY, aZ);
        String tOil = Behaviour_ProspectorsBook.prospectWater(aWorld, aX, aZ);
        new StoryGenerator(aRandom, allOres, aStack, tOil, new int[]{aX, aY, aZ});
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        tNBT.func_74757_a("inited", true);
        aStack.func_77982_d(tNBT);
        return aStack;
    }

    public static ItemStack getBook(World aWorld, int aX, int aY, int aZ, Random aRandom, boolean aGenerate) {
        if (aGenerate) {
            return Behaviour_ProspectorsBook.getBook(aWorld, aX, aY, aZ, aRandom);
        }
        ItemStack aStack = ItemList.ProspectorsBook.get(1L, new Object[0]);
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.func_74768_a("x", aX);
        tNBT.func_74768_a("y", aY);
        tNBT.func_74768_a("z", aZ);
        tNBT.func_74757_a("inited", false);
        aStack.func_77982_d(tNBT);
        return aStack;
    }

    static {
        types = new String[]{Materials.Tin.mName, Materials.Copper.mName, Materials.Redstone.mName, Materials.Iron.mName, Materials.Lead.mName, Materials.BandedIron.mName, Materials.Chalcopyrite.mName, Materials.Tetrahedrite.mName, Materials.Cassiterite.mName, Materials.BrownLimonite.mName, Materials.Nickel.mName};
        prospectingOres = new HashSet();
        radius = 144;
        near = radius / 3;
        near += near % 2;
        middle = near * 2;
        step = 4;
        prospectingOres.addAll(Arrays.asList(types));
        INSTANCE = new Behaviour_ProspectorsBook();
    }

    private static class StoryGenerator {
        private final String[] groundLevels = GT_LanguageManager.addStringLocalization("gt.prospectorsbook.groundlevels", "almost at surface|at cave level|deep in solid rock").split("\\|");
        private final String[] caveEvents = GT_LanguageManager.addStringLocalization("gt.prospectorsbook.caveevents", "met some cave spiders today, my luck is good though I'm still alive |found some malachite ore, I need a bit more iron to forge a new pickaxe|tried to dig deeper, I almost swam in lava| When expanding the mine came across a cluster of gravel above me, I was almost buried alive.| In mine flooded one of lava lake with water. I hope one day I dig up enough diamonds or cobalt to mine resulting obsidian.| The trip to the mine turned out to be very productive , I had to finish due to a lack of torches.| Throughout my stay in the mine, I was annoyed by the peep of bats. It's pisses me off.| In the old mine, I came across a railroad. I\u2019m thinking about getting a minecart.| In mine unearthed the nest of silverfish. Argh, they are small and weak, but there are so many.| Dug a passage into canyon. It's huge and dark, with few waterfall of lava, need to observe it better next time.| In the cave I found some mushrooms. Looks like for dinner, I'll have mushroom soup.| I dug up so deep that I came across a rock that I had never seen before. It's dark gray and appears to be even harder than obsidian.| I found a chest in an abandoned mine, inside was gold armor for horse. Who and why could leave it?").split("\\|");
        private final String[] rutineEvents = GT_LanguageManager.addStringLocalization("gt.prospectorsbook.rutineevents", "Milked my cow -again-, milk can heal every injury!|Harvested some wheat and baked bread -again-, delicious |Axed oak and got some apples -again- .. what?!|Today I met \"crossed out\" -again-, he looks sick: his skin has turned green, I hope it\u2019s not contagious|-again- Met a frightened and dirty pig, she was saddled. What's wrong with you people?|-again- Someone painted one of my sheep pink, what a jerk.|This night -again- slimes from the swamps kept me awake. I need to move away from here.|-again- Half a day chasing a chicken, what a shame. Still not seen a single rooster.|-again- Spent a few buckets of water to wash redstone dust today. Eh, it would be great if someone did this for me.|Sold the ore I mine to Villagers -again-. Seems our relationship is improving: prices have become more profitable.|I -again- found an octopus, which trying to get out of the shallow. When I helped him out, he was so scared that dropped his ink bag.|Met a woman in a weird hat -again-. She turned out to be a sweet lady and treated me to a drink of her own preparation.|Today I saw a herd of donkeys -again-. I thinking of catching one to make it easier \u0435o transport more ore from the mine.").split("\\|");
        private final String[] oreFindEvents = GT_LanguageManager.addStringLocalization("gt.prospectorsbook.orefindevents", "I found some -name- ore traces|while going back I saw some -name- ore pieces|I noticed some -name- ore chunks").split("\\|");
        private final String[] agains = GT_LanguageManager.addStringLocalization("gt.prospectorsbook.agains", "again|once more|one more time").split("\\|");
        private final String[] ands = GT_LanguageManager.addStringLocalization("gt.prospectorsbook.ands", "and then|also").split("\\|");
        private final String[] laters = GT_LanguageManager.addStringLocalization("gt.prospectorsbook.laters", "Later today I|In 2 hours I|Some time after I").split("\\|");
        Random random;
        HashSet<Integer> alreadyUsedMine = new HashSet();
        HashSet<Integer> alreadyUsedRutine = new HashSet();

        public StoryGenerator(Random aRandom, HashMap<String, ArrayList<int[]>> allOres, ItemStack aBook, String aOil, int[] tilePos) {
            this.random = aRandom;
            NBTTagCompound tNBT = new NBTTagCompound();
            NBTTagList tTagList = new NBTTagList();
            String tPageText = "";
            ArrayList tOres = new ArrayList();
            int day = 1;
            for (String oreKey : allOres.keySet()) {
                ArrayList<int[]> orePositions = allOres.get(oreKey);
                if (orePositions == null || orePositions.size() == 0) continue;
                int[] position = orePositions.get(aRandom.nextInt(orePositions.size()));
                tPageText = EnumChatFormatting.BOLD + "Day " + day + EnumChatFormatting.RESET + "\n" + this.getRandomRutineEvent(this.random);
                tTagList.func_74742_a((NBTBase)new NBTTagString(tPageText));
                tPageText = this.laters[this.random.nextInt(this.laters.length)] + " " + this.getRandomMineEvent(this.random) + " " + this.ands[this.random.nextInt(this.ands.length)] + " " + this.getRandomOreFoundEvent(this.random, oreKey) + " " + this.getOrePositionRelative(position, tilePos);
                tTagList.func_74742_a((NBTBase)new NBTTagString(tPageText));
                day += 1 + this.random.nextInt(5);
            }
            tPageText = "";
            if (aOil != "") {
                String[] aWater = aOil.split("\\|");
                tPageText = tPageText + "It seems that there is underground water source at " + this.getDirectionZ(Integer.valueOf(aWater[1]) - tilePos[2]) + " and " + this.getDirectionX(Integer.valueOf(aWater[0]) - tilePos[0]) + " ";
            }
            tPageText = tPageText + "now I'm leaving this place, may be sombody will find my diary and read it";
            tTagList.func_74742_a((NBTBase)new NBTTagString(tPageText));
            tNBT.func_74778_a("author", "unknown miner");
            tNBT.func_74778_a("title", "Written long time ago");
            tNBT.func_74782_a("pages", (NBTBase)tTagList);
            aBook.func_77982_d(tNBT);
        }

        private String genDay(int aDay, String oreName, int[] orePosition, int[] tilePosition, Random random) {
            String out = EnumChatFormatting.BOLD + "Day " + aDay + EnumChatFormatting.RESET + "\n" + this.getRandomRutineEvent(random) + " " + this.laters[random.nextInt(this.laters.length)] + " " + this.getRandomMineEvent(random) + " " + this.ands[random.nextInt(this.ands.length)] + " " + this.getRandomOreFoundEvent(random, oreName) + " " + this.getOrePositionRelative(orePosition, tilePosition);
            return out;
        }

        private String getGroundLevel(int y) {
            if (y > 50) {
                return this.groundLevels[0];
            }
            if (y > 30) {
                return this.groundLevels[1];
            }
            return this.groundLevels[2];
        }

        private String getRandomMineEvent(Random random) {
            int event = random.nextInt(this.caveEvents.length);
            for (int i = 0; this.alreadyUsedMine.contains(event) && i < 100; ++i) {
                event = random.nextInt(this.caveEvents.length);
            }
            if (this.alreadyUsedMine.contains(event)) {
                return "Not enaugh events LOL";
            }
            this.alreadyUsedMine.add(event);
            return this.caveEvents[event];
        }

        private String getRandomRutineEvent(Random random) {
            int event = random.nextInt(this.rutineEvents.length);
            String out = this.rutineEvents[event];
            out = this.alreadyUsedRutine.contains(event) ? out.replaceAll("-again-", this.agains[random.nextInt(this.agains.length)]) : out.replaceAll("-again-", "");
            this.alreadyUsedRutine.add(event);
            out = out + ".";
            return out;
        }

        private String getRandomOreFoundEvent(Random random, String ore) {
            int event = random.nextInt(this.oreFindEvents.length);
            String out = this.oreFindEvents[event].replaceAll("-name-", ore);
            return out;
        }

        private String getOrePositionRelative(int[] orePosition, int[] tilePosition) {
            int aX = orePosition[0] - tilePosition[0];
            int aZ = orePosition[2] - tilePosition[2];
            return "in " + this.getGroundLevel(orePosition[1]) + " " + this.getDirectionZ(aZ) + " and " + this.getDirectionX(aX);
        }

        private String getDirectionZ(int aZ) {
            if (aZ < 0) {
                return -aZ + " m to North";
            }
            return aZ + " m to South";
        }

        private String getDirectionX(int aX) {
            if (aX < 0) {
                return -aX + " m to West";
            }
            return aX + " m to East";
        }
    }
}

