/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import cpw.mods.fml.common.eventhandler.Event;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.events.BlockScanningEvent;
import gregtech.api.interfaces.IDebugableBlock;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.interfaces.tileentity.IUpgradableMachine;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.items.behaviors.Behaviour_None;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.tile.IEnergyStorage;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class Behaviour_Scanner
extends Behaviour_None {
    public static final IItemBehaviour<GT_MetaBase_Item> INSTANCE = new Behaviour_Scanner();
    private final String mTooltip = GT_LanguageManager.addStringLocalization("gt.behaviour.scanning", "Can scan Blocks in World");

    @Override
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        if (aPlayer instanceof EntityPlayerMP && aItem.canUse(aStack, 20000.0)) {
            ArrayList<String> tList = new ArrayList<String>();
            aItem.use(aStack, Behaviour_Scanner.getCoordinateScan(tList, aPlayer, aWorld, 1, ScanModes.values()[aStack.func_77978_p() == null ? 0 : aStack.func_77978_p().func_74762_e("sMode")], aX, aY, aZ, aSide, hitX, hitY, hitZ), (EntityLivingBase)aPlayer);
            for (String s : tList) {
                GT_Utility.sendChatToPlayer(aPlayer, s);
            }
            return true;
        }
        GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(108), 1, 1.0f, aX, aY, aZ);
        return aPlayer instanceof EntityPlayerMP;
    }

    @Override
    public ItemStack onItemRightClick(GT_MetaBase_Item aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (aWorld.field_72995_K || !aPlayer.func_70093_af()) {
            return aStack;
        }
        NBTTagCompound nbtTagCompound = aStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        int mode = (nbtTagCompound.func_74762_e("sMode") + 1) % ScanModes.values().length;
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_223", new Object[]{ScanModes.values()[mode]}));
        nbtTagCompound.func_74768_a("sMode", mode);
        aStack.func_77982_d(nbtTagCompound);
        return aStack;
    }

    @Override
    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }

    public static int getCoordinateScan(ArrayList<String> aList, EntityPlayer aPlayer, World aWorld, int aScanLevel, ScanModes scanMode, int aX, int aY, int aZ, int aSide, float aClickX, float aClickY, float aClickZ) {
        Block tBlock;
        TileEntity tTileEntity;
        int rEUAmount;
        ArrayList<String> tList;
        block99: {
            block98: {
                block81: {
                    if (aList == null) {
                        return 0;
                    }
                    tList = new ArrayList<String>();
                    rEUAmount = 0;
                    tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
                    tBlock = aWorld.func_147439_a(aX, aY, aZ);
                    if (ScanModes.DEFAULT == scanMode) {
                        tList.add("----- X: " + aX + " Y: " + aY + " Z: " + aZ + " D: " + aWorld.field_73011_w.field_76574_g + " -----");
                        tList.add("Biome real: " + aWorld.func_72807_a((int)aX, (int)aZ).field_76791_y);
                        tList.add("Biome by generator: " + aWorld.field_73011_w.field_76578_c.func_76935_a((int)aX, (int)aZ).field_76791_y);
                    }
                    try {
                        if (ScanModes.DEFAULT == scanMode) {
                            if (tTileEntity instanceof IInventory) {
                                tList.add(Behaviour_Scanner.translate("162", "Name: ") + ((IInventory)tTileEntity).func_145825_b() + Behaviour_Scanner.translate("163", "  MetaData: ") + aWorld.func_72805_g(aX, aY, aZ));
                            } else {
                                tList.add(Behaviour_Scanner.translate("162", "Name: ") + tBlock.func_149739_a() + Behaviour_Scanner.translate("163", "  MetaData: ") + aWorld.func_72805_g(aX, aY, aZ));
                            }
                            tList.add(Behaviour_Scanner.translate("164", "Hardness: ") + tBlock.func_149712_f(aWorld, aX, aY, aZ) + Behaviour_Scanner.translate("165", "  Blast Resistance: ") + tBlock.getExplosionResistance((Entity)aPlayer, aWorld, aX, aY, aZ, aPlayer.field_70165_t, aPlayer.field_70163_u, aPlayer.field_70161_v));
                            if (tBlock.isBeaconBase((IBlockAccess)aWorld, aX, aY, aZ, aX, aY + 1, aZ)) {
                                tList.add(Behaviour_Scanner.translate("166", "Is valid Beacon Pyramid Material"));
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (!GT_Values.D1) break block81;
                        e.printStackTrace(GT_Log.err);
                    }
                }
                if (tTileEntity != null) {
                    block97: {
                        block96: {
                            block95: {
                                block94: {
                                    block93: {
                                        block92: {
                                            block91: {
                                                block90: {
                                                    block89: {
                                                        block88: {
                                                            block87: {
                                                                block86: {
                                                                    block85: {
                                                                        block84: {
                                                                            block83: {
                                                                                block82: {
                                                                                    try {
                                                                                        if (tTileEntity instanceof IFluidHandler) {
                                                                                            rEUAmount += 500;
                                                                                            FluidTankInfo[] tTanks = ((IFluidHandler)tTileEntity).getTankInfo(ForgeDirection.getOrientation((int)aSide));
                                                                                            if (tTanks != null) {
                                                                                                for (int i = 0; i < tTanks.length; i = (int)((byte)(i + 1))) {
                                                                                                    tList.add(Behaviour_Scanner.translate("167", "Tank ") + i + ": " + GT_Utility.formatNumbers(tTanks[i].fluid == null ? 0 : tTanks[i].fluid.amount) + " / " + GT_Utility.formatNumbers(tTanks[i].capacity) + " " + GT_Utility.getFluidName(tTanks[i].fluid, true));
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    catch (Throwable e) {
                                                                                        if (!GT_Values.D1) break block82;
                                                                                        e.printStackTrace(GT_Log.err);
                                                                                    }
                                                                                }
                                                                                try {
                                                                                    if (tTileEntity instanceof IReactorChamber) {
                                                                                        rEUAmount += 500;
                                                                                        tTileEntity = (TileEntity)((IReactorChamber)tTileEntity).getReactor();
                                                                                    }
                                                                                }
                                                                                catch (Throwable e) {
                                                                                    if (!GT_Values.D1) break block83;
                                                                                    e.printStackTrace(GT_Log.err);
                                                                                }
                                                                            }
                                                                            try {
                                                                                if (tTileEntity instanceof IReactor) {
                                                                                    rEUAmount += 500;
                                                                                    tList.add(Behaviour_Scanner.translate("168", "Heat: ") + ((IReactor)tTileEntity).getHeat() + "/" + ((IReactor)tTileEntity).getMaxHeat() + Behaviour_Scanner.translate("169", "  HEM: ") + ((IReactor)tTileEntity).getHeatEffectModifier() + Behaviour_Scanner.translate("170", "  Base EU Output: "));
                                                                                }
                                                                            }
                                                                            catch (Throwable e) {
                                                                                if (!GT_Values.D1) break block84;
                                                                                e.printStackTrace(GT_Log.err);
                                                                            }
                                                                        }
                                                                        try {
                                                                            if (tTileEntity instanceof IWrenchable) {
                                                                                rEUAmount += 100;
                                                                                tList.add(Behaviour_Scanner.translate("171", "Facing: ") + ((IWrenchable)tTileEntity).getFacing() + Behaviour_Scanner.translate("172", " / Chance: ") + ((IWrenchable)tTileEntity).getWrenchDropRate() * 100.0f + "%");
                                                                                tList.add(((IWrenchable)tTileEntity).wrenchCanRemove(aPlayer) ? Behaviour_Scanner.translate("173", "You can remove this with a Wrench") : Behaviour_Scanner.translate("174", "You can NOT remove this with a Wrench"));
                                                                            }
                                                                        }
                                                                        catch (Throwable e) {
                                                                            if (!GT_Values.D1) break block85;
                                                                            e.printStackTrace(GT_Log.err);
                                                                        }
                                                                    }
                                                                    try {
                                                                        if (tTileEntity instanceof IEnergyTile) {
                                                                            rEUAmount += 200;
                                                                        }
                                                                    }
                                                                    catch (Throwable e) {
                                                                        if (!GT_Values.D1) break block86;
                                                                        e.printStackTrace(GT_Log.err);
                                                                    }
                                                                }
                                                                try {
                                                                    if (tTileEntity instanceof IEnergySink) {
                                                                        rEUAmount += 400;
                                                                    }
                                                                }
                                                                catch (Throwable e) {
                                                                    if (!GT_Values.D1) break block87;
                                                                    e.printStackTrace(GT_Log.err);
                                                                }
                                                            }
                                                            try {
                                                                if (tTileEntity instanceof IEnergySource) {
                                                                    rEUAmount += 400;
                                                                }
                                                            }
                                                            catch (Throwable e) {
                                                                if (!GT_Values.D1) break block88;
                                                                e.printStackTrace(GT_Log.err);
                                                            }
                                                        }
                                                        try {
                                                            if (tTileEntity instanceof IEnergyConductor) {
                                                                rEUAmount += 200;
                                                                tList.add(Behaviour_Scanner.translate("175", "Conduction Loss: ") + ((IEnergyConductor)tTileEntity).getConductionLoss());
                                                            }
                                                        }
                                                        catch (Throwable e) {
                                                            if (!GT_Values.D1) break block89;
                                                            e.printStackTrace(GT_Log.err);
                                                        }
                                                    }
                                                    try {
                                                        if (tTileEntity instanceof IEnergyStorage) {
                                                            rEUAmount += 200;
                                                            tList.add(Behaviour_Scanner.translate("176", "Contained Energy: ") + ((IEnergyStorage)tTileEntity).getStored() + Behaviour_Scanner.translate("205", " of ") + ((IEnergyStorage)tTileEntity).getCapacity());
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        if (!GT_Values.D1) break block90;
                                                        e.printStackTrace(GT_Log.err);
                                                    }
                                                }
                                                try {
                                                    if (tTileEntity instanceof IUpgradableMachine) {
                                                        rEUAmount += 500;
                                                        if (((IUpgradableMachine)tTileEntity).hasMufflerUpgrade()) {
                                                            tList.add(Behaviour_Scanner.translate("177", "Has Muffler Upgrade"));
                                                        }
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    if (!GT_Values.D1) break block91;
                                                    e.printStackTrace(GT_Log.err);
                                                }
                                            }
                                            try {
                                                if (ScanModes.DEFAULT == scanMode && tTileEntity instanceof IMachineProgress) {
                                                    rEUAmount += 400;
                                                    int tValue = 0;
                                                    tValue = ((IMachineProgress)tTileEntity).getMaxProgress();
                                                    if (0 < tValue) {
                                                        tList.add(Behaviour_Scanner.translate("178", "Progress: ") + GT_Utility.formatNumbers(tValue) + " / " + GT_Utility.formatNumbers(((IMachineProgress)tTileEntity).getProgress()));
                                                    }
                                                }
                                            }
                                            catch (Throwable e) {
                                                if (!GT_Values.D1) break block92;
                                                e.printStackTrace(GT_Log.err);
                                            }
                                        }
                                        try {
                                            if (tTileEntity instanceof ICoverable) {
                                                rEUAmount += 300;
                                                String tString = ((ICoverable)tTileEntity).getCoverBehaviorAtSide((byte)aSide).getDescription((byte)aSide, ((ICoverable)tTileEntity).getCoverIDAtSide((byte)aSide), ((ICoverable)tTileEntity).getCoverDataAtSide((byte)aSide), (ICoverable)tTileEntity);
                                                if (tString != null && !tString.equals("")) {
                                                    tList.add(tString);
                                                }
                                            }
                                        }
                                        catch (Throwable e) {
                                            if (!GT_Values.D1) break block93;
                                            e.printStackTrace(GT_Log.err);
                                        }
                                    }
                                    try {
                                        if (tTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof GT_MetaPipeEntity_Cable) {
                                            GT_MetaPipeEntity_Cable c = (GT_MetaPipeEntity_Cable)((IGregTechTileEntity)tTileEntity).getMetaTileEntity();
                                            tList.add("Max voltage last second " + c.mTransferredVoltageLast20);
                                            tList.add("Max amperage last second " + c.mTransferredAmperageLast20);
                                        }
                                    }
                                    catch (Throwable e) {
                                        if (!GT_Values.D1) break block94;
                                        e.printStackTrace(GT_Log.err);
                                    }
                                }
                                try {
                                    if (tTileEntity instanceof IBasicEnergyContainer && ((IBasicEnergyContainer)tTileEntity).getEUCapacity() > 0L) {
                                        tList.add(Behaviour_Scanner.translate("179", "Max IN: ") + ((IBasicEnergyContainer)tTileEntity).getInputVoltage() + Behaviour_Scanner.translate("180", " EU"));
                                        tList.add(Behaviour_Scanner.translate("181", "Max OUT: ") + ((IBasicEnergyContainer)tTileEntity).getOutputVoltage() + Behaviour_Scanner.translate("182", " EU at ") + ((IBasicEnergyContainer)tTileEntity).getOutputAmperage() + Behaviour_Scanner.translate("183", " Amperes"));
                                        tList.add(Behaviour_Scanner.translate("184", "Energy: ") + GT_Utility.formatNumbers(((IBasicEnergyContainer)tTileEntity).getStoredEU()) + " / " + GT_Utility.formatNumbers(((IBasicEnergyContainer)tTileEntity).getEUCapacity()) + Behaviour_Scanner.translate("185", "EU"));
                                    }
                                }
                                catch (Throwable e) {
                                    if (!GT_Values.D1) break block95;
                                    e.printStackTrace(GT_Log.err);
                                }
                            }
                            try {
                                if (ScanModes.DEFAULT == scanMode && tTileEntity instanceof IGregTechTileEntity) {
                                    tList.add(Behaviour_Scanner.translate("186", "Owned by: ") + ((IGregTechTileEntity)tTileEntity).getOwnerName());
                                }
                            }
                            catch (Throwable e) {
                                if (!GT_Values.D1) break block96;
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                        try {
                            if ((ScanModes.DEFAULT == scanMode || ScanModes.MULTIBLOCK == scanMode) && tTileEntity instanceof IGregTechDeviceInformation && ((IGregTechDeviceInformation)tTileEntity).isGivingInformation()) {
                                tList.addAll(Arrays.asList(((IGregTechDeviceInformation)tTileEntity).getInfoData()));
                            }
                        }
                        catch (Throwable e) {
                            if (!GT_Values.D1) break block97;
                            e.printStackTrace(GT_Log.err);
                        }
                    }
                    try {
                        if (tTileEntity instanceof ICropTile) {
                            if (((ICropTile)tTileEntity).getScanLevel() < 4) {
                                rEUAmount += 10000;
                                ((ICropTile)tTileEntity).setScanLevel((byte)4);
                            }
                            if (((ICropTile)tTileEntity).getID() >= 0 && ((ICropTile)tTileEntity).getID() < Crops.instance.getCropList().length && Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()] != null) {
                                rEUAmount += 1000;
                                tList.add(Behaviour_Scanner.translate("187", "Type -- Crop-Name: ") + Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()].name() + Behaviour_Scanner.translate("188", "  Growth: ") + ((ICropTile)tTileEntity).getGrowth() + Behaviour_Scanner.translate("189", "  Gain: ") + ((ICropTile)tTileEntity).getGain() + Behaviour_Scanner.translate("190", "  Resistance: ") + ((ICropTile)tTileEntity).getResistance());
                                tList.add(Behaviour_Scanner.translate("191", "Plant -- Fertilizer: ") + ((ICropTile)tTileEntity).getNutrientStorage() + Behaviour_Scanner.translate("192", "  Water: ") + ((ICropTile)tTileEntity).getHydrationStorage() + Behaviour_Scanner.translate("193", "  Weed-Ex: ") + ((ICropTile)tTileEntity).getWeedExStorage() + Behaviour_Scanner.translate("194", "  Scan-Level: ") + ((ICropTile)tTileEntity).getScanLevel());
                                tList.add(Behaviour_Scanner.translate("195", "Environment -- Nutrients: ") + ((ICropTile)tTileEntity).getNutrients() + Behaviour_Scanner.translate("196", "  Humidity: ") + ((ICropTile)tTileEntity).getHumidity() + Behaviour_Scanner.translate("197", "  Air-Quality: ") + ((ICropTile)tTileEntity).getAirQuality());
                                StringBuilder tStringB = new StringBuilder();
                                for (String tAttribute : Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()].attributes()) {
                                    tStringB.append(", ").append(tAttribute);
                                }
                                String tString = tStringB.toString();
                                tList.add(Behaviour_Scanner.translate("198", "Attributes:") + tString.replaceFirst(",", ""));
                                tList.add(Behaviour_Scanner.translate("199", "Discovered by: ") + Crops.instance.getCropList()[((ICropTile)tTileEntity).getID()].discoveredBy());
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (!GT_Values.D1) break block98;
                        e.printStackTrace(GT_Log.err);
                    }
                }
            }
            if (aPlayer.field_71075_bZ.field_75098_d && GT_Values.D1) {
                FluidStack tFluid = GT_UndergroundOil.undergroundOilReadInformation(aWorld.func_72938_d(aX, aZ));
                if (tFluid != null) {
                    tList.add(EnumChatFormatting.GOLD + tFluid.getLocalizedName() + EnumChatFormatting.RESET + ": " + EnumChatFormatting.YELLOW + tFluid.amount + EnumChatFormatting.RESET + Behaviour_Scanner.translate("200", " L"));
                } else {
                    tList.add(EnumChatFormatting.GOLD + Behaviour_Scanner.translate("201", "Nothing") + EnumChatFormatting.RESET + ": " + EnumChatFormatting.YELLOW + '0' + EnumChatFormatting.RESET + Behaviour_Scanner.translate("200", " L"));
                }
            }
            int[] chunkData = GT_Proxy.dimensionWiseChunkData.get(aWorld.field_73011_w.field_76574_g).get(aWorld.func_72938_d(aX, aZ).func_76632_l());
            if (ScanModes.DEFAULT == scanMode && chunkData != null) {
                if (chunkData[1] > 0) {
                    tList.add(Behaviour_Scanner.translate("202", "Pollution in Chunk: ") + EnumChatFormatting.RED + chunkData[1] + EnumChatFormatting.RESET + Behaviour_Scanner.translate("203", " gibbl"));
                } else {
                    tList.add(EnumChatFormatting.GREEN + Behaviour_Scanner.translate("204", "No Pollution in Chunk! HAYO!") + EnumChatFormatting.RESET);
                }
            } else if (ScanModes.DEFAULT == scanMode) {
                tList.add(EnumChatFormatting.GREEN + Behaviour_Scanner.translate("204", "No Pollution in Chunk! HAYO!") + EnumChatFormatting.RESET);
            }
            try {
                if (ScanModes.DEFAULT == scanMode && tBlock instanceof IDebugableBlock) {
                    rEUAmount += 500;
                    ArrayList<String> temp = ((IDebugableBlock)tBlock).getDebugInfo(aPlayer, aX, aY, aZ, 3);
                    if (temp != null) {
                        tList.addAll(temp);
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block99;
                e.printStackTrace(GT_Log.err);
            }
        }
        BlockScanningEvent tEvent = new BlockScanningEvent(aWorld, aPlayer, aX, aY, aZ, (byte)aSide, aScanLevel, tBlock, tTileEntity, tList, aClickX, aClickY, aClickZ);
        tEvent.mEUCost = rEUAmount;
        MinecraftForge.EVENT_BUS.post((Event)tEvent);
        if (!tEvent.isCanceled()) {
            aList.addAll(tList);
        }
        return tEvent.mEUCost;
    }

    public static String translate(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_" + aKey, aEnglish, false);
    }

    public static enum ScanModes {
        DEFAULT,
        MULTIBLOCK;

    }
}

