/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_Utility;
import gregtech.common.render.GT_RenderUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GT_MetaGenerated_Item_Renderer
implements IItemRenderer {
    private static final boolean renderMaterialsIconTextEnabled = GregTech_API.sMaterialProperties.get((Object)"general", "MaterialIconTextEnable", true);
    private static final int renderMaterialsIconTextColor = GT_MetaGenerated_Item_Renderer.parseColor(GregTech_API.sMaterialProperties.get((Object)"general", "MaterialIconTextColor", "0,0,0"));

    public GT_MetaGenerated_Item_Renderer() {
        for (GT_MetaGenerated_Item tItem : GT_MetaGenerated_Item.sInstances.values()) {
            MinecraftForgeClient.registerItemRenderer((Item)tItem, (IItemRenderer)this);
        }
    }

    private static int parseColor(String rgb) {
        String[] c = rgb.split(",");
        return new Color(Integer.parseInt(c[0]), Integer.parseInt(c[1]), Integer.parseInt(c[2])).getRGB();
    }

    public boolean handleRenderType(ItemStack aStack, IItemRenderer.ItemRenderType aType) {
        if (GT_Utility.isStackInvalid(aStack) || aStack.func_77960_j() < 0) {
            return false;
        }
        return aType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || aType == IItemRenderer.ItemRenderType.INVENTORY || aType == IItemRenderer.ItemRenderType.EQUIPPED || aType == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType aType, ItemStack aStack, IItemRenderer.ItemRendererHelper aHelper) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        return aType == IItemRenderer.ItemRenderType.ENTITY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        short aMetaData = (short)aStack.func_77960_j();
        if (aMetaData < 0) {
            return;
        }
        GT_MetaGenerated_Item aItem = (GT_MetaGenerated_Item)aStack.func_77973_b();
        GL11.glEnable((int)3042);
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            if (RenderItem.field_82407_g) {
                GL11.glScalef((float)0.85f, (float)0.85f, (float)0.85f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)-0.5, (double)-0.42, (double)0.0);
            } else {
                GL11.glTranslated((double)-0.5, (double)-0.42, (double)0.0);
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (aMetaData < aItem.mOffset) {
            IIcon tIcon;
            IIconContainer aIcon = aItem.getIconContainer(aMetaData);
            IIcon tOverlay = null;
            IIcon tFluidIcon = null;
            if (aIcon == null) {
                tIcon = aStack.func_77954_c();
            } else {
                tIcon = aIcon.getIcon();
                tOverlay = aIcon.getOverlayIcon();
            }
            if (tIcon == null) {
                return;
            }
            FluidStack tFluid = GT_Utility.getFluidForFilledItem(aStack, true);
            if (tOverlay != null && tFluid != null && tFluid.getFluid() != null) {
                tFluidIcon = tFluid.getFluid().getIcon(tFluid);
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
            GL11.glBlendFunc((int)770, (int)771);
            if (tFluidIcon == null) {
                short[] tModulation = aItem.getRGBa(aStack);
                GL11.glColor3f((float)((float)tModulation[0] / 255.0f), (float)((float)tModulation[1] / 255.0f), (float)((float)tModulation[2] / 255.0f));
            }
            if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                GT_RenderUtil.renderItemIcon(tIcon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
            } else {
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)tIcon.func_94212_f(), (float)tIcon.func_94206_g(), (float)tIcon.func_94209_e(), (float)tIcon.func_94210_h(), (int)tIcon.func_94211_a(), (int)tIcon.func_94216_b(), (float)0.0625f);
            }
            if (tFluidIcon != null) {
                assert (tFluid != null);
                int tColor = tFluid.getFluid().getColor(tFluid);
                GL11.glColor3f((float)((float)(tColor >> 16 & 0xFF) / 255.0f), (float)((float)(tColor >> 8 & 0xFF) / 255.0f), (float)((float)(tColor & 0xFF) / 255.0f));
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                    GT_RenderUtil.renderItemIcon(tFluidIcon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
                } else {
                    ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)tFluidIcon.func_94212_f(), (float)tFluidIcon.func_94206_g(), (float)tFluidIcon.func_94209_e(), (float)tFluidIcon.func_94210_h(), (int)tFluidIcon.func_94211_a(), (int)tFluidIcon.func_94216_b(), (float)0.0625f);
                }
                GL11.glDepthFunc((int)515);
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (tOverlay != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
                GL11.glBlendFunc((int)770, (int)771);
                if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                    GT_RenderUtil.renderItemIcon(tOverlay, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
                } else {
                    ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)tOverlay.func_94212_f(), (float)tOverlay.func_94206_g(), (float)tOverlay.func_94209_e(), (float)tOverlay.func_94210_h(), (int)tOverlay.func_94211_a(), (int)tOverlay.func_94216_b(), (float)0.0625f);
                }
            }
        } else {
            long tCharge;
            Long[] tStats;
            IIcon tIcon = aItem.mIconList[aMetaData - aItem.mOffset].length > 1 ? ((tStats = aItem.mElectricStats.get(aMetaData)) != null && tStats[3] < 0L ? ((tCharge = aItem.getRealCharge(aStack)) <= 0L ? aItem.mIconList[aMetaData - aItem.mOffset][1] : (tCharge >= tStats[0] ? aItem.mIconList[aMetaData - aItem.mOffset][8] : aItem.mIconList[aMetaData - aItem.mOffset][7 - (int)Math.max(0L, Math.min(5L, (tStats[0] - tCharge) * 6L / tStats[0]))])) : aItem.mIconList[aMetaData - aItem.mOffset][0]) : aItem.mIconList[aMetaData - aItem.mOffset][0];
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
            GL11.glBlendFunc((int)770, (int)771);
            if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                GT_RenderUtil.renderItemIcon(tIcon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
            } else {
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)tIcon.func_94212_f(), (float)tIcon.func_94206_g(), (float)tIcon.func_94209_e(), (float)tIcon.func_94210_h(), (int)tIcon.func_94211_a(), (int)tIcon.func_94216_b(), (float)0.0625f);
            }
        }
        GL11.glDisable((int)3042);
        if (!renderMaterialsIconTextEnabled || !type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            return;
        }
        if (aStack.func_77954_c().func_94215_i().contains("materialicons")) {
            String boldFlag = "\u00a7l";
            Materials tMaterial = GregTech_API.sGeneratedMaterials[aStack.func_77973_b().getDamage(aStack) % 1000];
            String text = "";
            if (tMaterial != null) {
                text = tMaterial.name();
                text = text.substring(0, 2);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.01f);
            GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
            FontRenderer fnt = Minecraft.func_71410_x().field_71466_p;
            fnt.func_78276_b(boldFlag + text, 10, 0, renderMaterialsIconTextColor);
        }
    }
}

