/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.IFastRenderedTileEntity;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IPipeRenderedTileEntity;
import gregtech.api.interfaces.tileentity.ITexturedTileEntity;
import gregtech.common.blocks.GT_Block_Machines;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class GT_Renderer_Block
implements ISimpleBlockRenderingHandler {
    public static GT_Renderer_Block INSTANCE;
    public final int mRenderID = RenderingRegistry.getNextAvailableRenderId();

    public GT_Renderer_Block() {
        INSTANCE = this;
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
    }

    public static void renderNormalInventoryMetaTileEntity(ItemStack is, Block aBlock, int aMeta, RenderBlocks aRenderer, boolean aInWorld) {
        if (aMeta <= 0 || aMeta >= GregTech_API.METATILEENTITIES.length) {
            return;
        }
        IMetaTileEntity tMetaTileEntity = GregTech_API.METATILEENTITIES[aMeta];
        if (tMetaTileEntity == null) {
            return;
        }
        aBlock.func_149683_g();
        aRenderer.func_147775_a(aBlock);
        if (tMetaTileEntity.getBaseMetaTileEntity() instanceof IPipeRenderedTileEntity) {
            float tThickness = ((IPipeRenderedTileEntity)((Object)tMetaTileEntity.getBaseMetaTileEntity())).getThickNess();
            float sp = (1.0f - tThickness) / 2.0f;
            aBlock.func_149676_a(0.0f, sp, sp, 1.0f, sp + tThickness, sp + tThickness);
            aRenderer.func_147775_a(aBlock);
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
            GT_Renderer_Block.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(tMetaTileEntity.getBaseMetaTileEntity(), (byte)0, (byte)9, (byte)-1, false, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            GT_Renderer_Block.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(tMetaTileEntity.getBaseMetaTileEntity(), (byte)1, (byte)9, (byte)-1, false, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            GT_Renderer_Block.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(tMetaTileEntity.getBaseMetaTileEntity(), (byte)2, (byte)9, (byte)-1, false, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
            GT_Renderer_Block.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(tMetaTileEntity.getBaseMetaTileEntity(), (byte)3, (byte)9, (byte)-1, false, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(tMetaTileEntity.getBaseMetaTileEntity(), (byte)4, (byte)9, (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(tMetaTileEntity.getBaseMetaTileEntity(), (byte)5, (byte)9, (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
        } else {
            ITexture[][] textures = tMetaTileEntity.getBaseMetaTileEntity().getTextures(is, (byte)4, true, false, !aInWorld, (byte)2);
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
            GT_Renderer_Block.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, textures[0], true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            GT_Renderer_Block.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, textures[1], true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            GT_Renderer_Block.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, textures[2], true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
            GT_Renderer_Block.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, textures[3], true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, textures[4], true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, textures[5], true);
            Tessellator.field_78398_a.func_78381_a();
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
    }

    public static boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IFastRenderedTileEntity) {
            return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, ((IFastRenderedTileEntity)tTileEntity).getTextures());
        }
        if (tTileEntity instanceof ITexturedTileEntity) {
            return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, new ITexture[][]{((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)0), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)1), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)2), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)3), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)4), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)5)});
        }
        return false;
    }

    public static boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer, ITexture[][] aTextures) {
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[0], true);
        GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[1], true);
        GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[2], true);
        GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[3], true);
        GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[4], true);
        GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[5], true);
        return true;
    }

    public static boolean renderPipeBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, IPipeRenderedTileEntity aTileEntity, RenderBlocks aRenderer) {
        ITexture[][] tCovers;
        ITexture[][] tIcons;
        byte aConnections = aTileEntity.getConnections();
        if ((aConnections & 0xC0) != 0) {
            return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        float tThickness = aTileEntity.getThickNess();
        if (tThickness >= 0.99f) {
            return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        float sp = (1.0f - tThickness) / 2.0f;
        int tConnections = 0;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if ((aConnections & 1 << i) == 0) continue;
            tConnections = (byte)(tConnections | 1 << (i + 2) % 6);
        }
        boolean[] tIsCovered = new boolean[6];
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            tIsCovered[i] = aTileEntity.getCoverIDAtSide(i) != 0;
        }
        if (tIsCovered[0] && tIsCovered[1] && tIsCovered[2] && tIsCovered[3] && tIsCovered[4] && tIsCovered[5]) {
            return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        if (aTileEntity instanceof IFastRenderedTileEntity) {
            tIcons = ((IFastRenderedTileEntity)((Object)aTileEntity)).getTextures(false);
            tCovers = ((IFastRenderedTileEntity)((Object)aTileEntity)).getTextures(true);
        } else {
            tIcons = new ITexture[6][];
            tCovers = new ITexture[6][];
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                tCovers[i] = aTileEntity.getTexture(aBlock, i);
                tIcons[i] = aTileEntity.getTextureUncovered(i);
            }
        }
        if (tConnections == 0) {
            aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
            aRenderer.func_147775_a(aBlock);
            GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
            GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
            GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
            GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
            GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
            GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
        } else if (tConnections == 3) {
            aBlock.func_149676_a(0.0f, sp, sp, 1.0f, sp + tThickness, sp + tThickness);
            aRenderer.func_147775_a(aBlock);
            GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
            GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
            GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
            GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
            if (!tIsCovered[4]) {
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
            }
            if (!tIsCovered[5]) {
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
            }
        } else if (tConnections == 12) {
            aBlock.func_149676_a(sp, 0.0f, sp, sp + tThickness, 1.0f, sp + tThickness);
            aRenderer.func_147775_a(aBlock);
            GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
            GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
            GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
            GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
            if (!tIsCovered[0]) {
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
            }
            if (!tIsCovered[1]) {
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
            }
        } else if (tConnections == 48) {
            aBlock.func_149676_a(sp, sp, 0.0f, sp + tThickness, sp + tThickness, 1.0f);
            aRenderer.func_147775_a(aBlock);
            GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
            GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
            GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
            GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
            if (!tIsCovered[2]) {
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
            }
            if (!tIsCovered[3]) {
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
            }
        } else {
            if ((tConnections & 1) == 0) {
                aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
            } else {
                aBlock.func_149676_a(0.0f, sp, sp, sp, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
                if (!tIsCovered[4]) {
                    GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
                }
            }
            if ((tConnections & 2) == 0) {
                aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
            } else {
                aBlock.func_149676_a(sp + tThickness, sp, sp, 1.0f, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
                if (!tIsCovered[5]) {
                    GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
                }
            }
            if ((tConnections & 4) == 0) {
                aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
            } else {
                aBlock.func_149676_a(sp, 0.0f, sp, sp + tThickness, sp, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
                if (!tIsCovered[0]) {
                    GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
                }
            }
            if ((tConnections & 8) == 0) {
                aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
            } else {
                aBlock.func_149676_a(sp, sp + tThickness, sp, sp + tThickness, 1.0f, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
                if (!tIsCovered[1]) {
                    GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
                }
            }
            if ((tConnections & 0x10) == 0) {
                aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
            } else {
                aBlock.func_149676_a(sp, sp, 0.0f, sp + tThickness, sp + tThickness, sp);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
                if (!tIsCovered[2]) {
                    GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[2], false);
                }
            }
            if ((tConnections & 0x20) == 0) {
                aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
            } else {
                aBlock.func_149676_a(sp, sp, sp + tThickness, sp + tThickness, sp + tThickness, 1.0f);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[0], false);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[1], false);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[4], false);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[5], false);
                if (!tIsCovered[3]) {
                    GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[3], false);
                }
            }
        }
        if (tIsCovered[0]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[0], false);
            GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[0], false);
            if (!tIsCovered[2]) {
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[0], false);
            }
            if (!tIsCovered[3]) {
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[0], false);
            }
            if (!tIsCovered[4]) {
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[0], false);
            }
            if (!tIsCovered[5]) {
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[0], false);
            }
        }
        if (tIsCovered[1]) {
            aBlock.func_149676_a(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[1], false);
            GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[1], false);
            if (!tIsCovered[2]) {
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[1], false);
            }
            if (!tIsCovered[3]) {
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[1], false);
            }
            if (!tIsCovered[4]) {
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[1], false);
            }
            if (!tIsCovered[5]) {
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[1], false);
            }
        }
        if (tIsCovered[2]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[0]) {
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[2], false);
            }
            if (!tIsCovered[1]) {
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[2], false);
            }
            GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[2], false);
            GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[2], false);
            if (!tIsCovered[4]) {
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[2], false);
            }
            if (!tIsCovered[5]) {
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[2], false);
            }
        }
        if (tIsCovered[3]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[0]) {
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[3], false);
            }
            if (!tIsCovered[1]) {
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[3], false);
            }
            GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[3], false);
            GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[3], false);
            if (!tIsCovered[4]) {
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[3], false);
            }
            if (!tIsCovered[5]) {
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[3], false);
            }
        }
        if (tIsCovered[4]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[0]) {
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[4], false);
            }
            if (!tIsCovered[1]) {
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[4], false);
            }
            if (!tIsCovered[2]) {
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[4], false);
            }
            if (!tIsCovered[3]) {
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[4], false);
            }
            GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[4], false);
            GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[4], false);
        }
        if (tIsCovered[5]) {
            aBlock.func_149676_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[0]) {
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[5], false);
            }
            if (!tIsCovered[1]) {
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[5], false);
            }
            if (!tIsCovered[2]) {
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[5], false);
            }
            if (!tIsCovered[3]) {
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[5], false);
            }
            GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[5], false);
            GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[5], false);
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        return true;
    }

    public static void renderNegativeYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY - 1, aZ, 0)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY - 1 : aY, aZ));
        }
        if (aIcon != null) {
            for (int i = 0; i < aIcon.length; ++i) {
                if (aIcon[i] == null) continue;
                aIcon[i].renderYNeg(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderPositiveYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY + 1, aZ, 1)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY + 1 : aY, aZ));
        }
        if (aIcon != null) {
            for (int i = 0; i < aIcon.length; ++i) {
                if (aIcon[i] == null) continue;
                aIcon[i].renderYPos(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderNegativeZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY, aZ - 1, 2)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ - 1 : aZ));
        }
        boolean bl = aRenderer.field_147842_e = !aFullBlock;
        if (aIcon != null) {
            for (int i = 0; i < aIcon.length; ++i) {
                if (aIcon[i] == null) continue;
                aIcon[i].renderZNeg(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderPositiveZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY, aZ + 1, 3)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ + 1 : aZ));
        }
        if (aIcon != null) {
            for (int i = 0; i < aIcon.length; ++i) {
                if (aIcon[i] == null) continue;
                aIcon[i].renderZPos(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderNegativeXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX - 1, aY, aZ, 4)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX - 1 : aX, aY, aZ));
        }
        if (aIcon != null) {
            for (int i = 0; i < aIcon.length; ++i) {
                if (aIcon[i] == null) continue;
                aIcon[i].renderXNeg(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderPositiveXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX + 1, aY, aZ, 5)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX + 1 : aX, aY, aZ));
        }
        boolean bl = aRenderer.field_147842_e = !aFullBlock;
        if (aIcon != null) {
            for (int i = 0; i < aIcon.length; ++i) {
                if (aIcon[i] == null) continue;
                aIcon[i].renderXPos(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        if (aBlock instanceof GT_Block_Machines) {
            if (aMeta > 0 && aMeta < GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[aMeta] != null && !GregTech_API.METATILEENTITIES[aMeta].renderInInventory(aBlock, aMeta, aRenderer)) {
                // empty if block
            }
        } else if (aBlock instanceof GT_Block_Ores_Abstract) {
            GT_TileEntity_Ores tTileEntity = new GT_TileEntity_Ores();
            tTileEntity.mMetaData = (short)aMeta;
            aBlock.func_149683_g();
            aRenderer.func_147775_a(aBlock);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
            GT_Renderer_Block.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)0), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            GT_Renderer_Block.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)1), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            GT_Renderer_Block.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)2), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
            GT_Renderer_Block.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)3), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)4), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)5), true);
            Tessellator.field_78398_a.func_78381_a();
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (aTileEntity == null) {
            return false;
        }
        if (aTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)aTileEntity).getMetaTileEntity() != null && ((IGregTechTileEntity)aTileEntity).getMetaTileEntity().renderInWorld(aWorld, aX, aY, aZ, aBlock, aRenderer)) {
            return true;
        }
        if (aTileEntity instanceof IPipeRenderedTileEntity) {
            return GT_Renderer_Block.renderPipeBlock(aWorld, aX, aY, aZ, aBlock, (IPipeRenderedTileEntity)aTileEntity, aRenderer);
        }
        return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return this.mRenderID;
    }
}

