/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_Boiler;
import gregtech.common.gui.GT_GUIContainer_Boiler;
import gregtech.common.tileentities.boilers.GT_MetaTileEntity_Boiler;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Boiler_Solar
extends GT_MetaTileEntity_Boiler {
    private int mRunTime = 0;
    protected int basicOutput = 150;
    protected int basicMaxOuput = 50;
    protected int basicTemperatureMod = 5;
    protected int basicLossTimerLimit = 45;
    static final int CALCIFICATION_TIME = 43200;

    public GT_MetaTileEntity_Boiler_Solar(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, new String[0], new ITexture[0]);
    }

    public GT_MetaTileEntity_Boiler_Solar(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Boiler_Solar(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Steam Power by the Sun", "Produces 120L of Steam per second", "Calcifies over time, reducing Steam output to 40L/s", "Break and replace to decalcify"};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[4][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            ITexture[] tmp0 = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM, Dyes.getModulation(i, Dyes._NULL.mRGBa))};
            rTextures[0][i + 1] = tmp0;
            ITexture[] tmp1 = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.BOILER_SOLAR)};
            rTextures[1][i + 1] = tmp1;
            ITexture[] tmp2 = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, Dyes.getModulation(i, Dyes._NULL.mRGBa))};
            rTextures[2][i + 1] = tmp2;
            ITexture[] tmp3 = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[3][i + 1] = tmp3;
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[aSide >= 2 ? (byte)(aSide != aFacing ? 2 : 3) : aSide][aColorIndex + 1];
    }

    @Override
    public int maxProgresstime() {
        return 500;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_Boiler(aPlayerInventory, aBaseMetaTileEntity, 16000);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_Boiler(aPlayerInventory, aBaseMetaTileEntity, "SolarBoiler.png", 16000);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Boiler_Solar(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mRunTime", this.mRunTime);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mRunTime = aNBT.func_74762_e("mRunTime");
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Heat Capacity: " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mTemperature * 100 / this.maxProgresstime()) + " % " + EnumChatFormatting.RESET + "    Hot time: " + EnumChatFormatting.RED + GT_Utility.formatNumbers(this.mRunTime * 25 / 20) + EnumChatFormatting.RESET + " s", "Min output: " + EnumChatFormatting.RED + GT_Utility.formatNumbers(this.basicMaxOuput * 20 / 25) + EnumChatFormatting.RESET + " L/s    Max output: " + EnumChatFormatting.RED + GT_Utility.formatNumbers(this.basicOutput * 20 / 25) + EnumChatFormatting.RESET + " L/s", "Current Output: " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getCalcificationOutput() * 20 / 25) + EnumChatFormatting.RESET + " L/s"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public int getCalcificationOutput() {
        if (this.mTemperature < 100) {
            return 0;
        }
        if (this.mRunTime > 43200) {
            return Math.max(this.basicMaxOuput, this.basicOutput - (this.mRunTime - 43200) / 288);
        }
        return this.basicOutput;
    }

    public int getBasicOutput() {
        return this.basicOutput;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick > 20L) {
            int tFilledAmount;
            FluidStack tDrained;
            byte i;
            IFluidHandler tTileEntity;
            if (this.mTemperature <= 20) {
                this.mTemperature = 20;
                this.mLossTimer = 0;
            }
            if (++this.mLossTimer > this.basicLossTimerLimit) {
                this.mTemperature -= this.basicTemperatureMod;
                this.mLossTimer = 0;
            }
            if (this.mSteam != null && (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(i = aBaseMetaTileEntity.getFrontFacing())) != null && (tDrained = aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), Math.max(1, this.mSteam.amount / 2), false)) != null && (tFilledAmount = tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), tDrained, false)) > 0) {
                tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), tFilledAmount, true), true);
            }
            if (aTick % 25L == 0L) {
                if (this.mTemperature > 100) {
                    if (this.mFluid == null || !GT_ModHandler.isWater(this.mFluid) || this.mFluid.amount <= 0) {
                        this.mHadNoWater = true;
                    } else {
                        if (this.mHadNoWater) {
                            aBaseMetaTileEntity.doExplosion(2048L);
                            return;
                        }
                        this.mFluid.amount -= this.basicOutput / 150;
                        ++this.mRunTime;
                        int tOutput = this.getCalcificationOutput();
                        if (this.mSteam == null) {
                            this.mSteam = GT_ModHandler.getSteam(tOutput);
                        } else if (GT_ModHandler.isSteam(this.mSteam)) {
                            this.mSteam.amount += tOutput;
                        } else {
                            this.mSteam = GT_ModHandler.getSteam(tOutput);
                        }
                    }
                } else {
                    this.mHadNoWater = false;
                }
            }
            if (this.mSteam != null && this.mSteam.amount > this.getCapacity()) {
                this.sendSound((byte)1);
                this.mSteam.amount = 3 * (this.getCapacity() / 4);
            }
            if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork() && aTick % 256L == 0L && !aBaseMetaTileEntity.getWorld().func_72911_I()) {
                boolean bRain;
                boolean bl = bRain = aBaseMetaTileEntity.getWorld().func_72896_J() && aBaseMetaTileEntity.getBiome().field_76751_G > 0.0f;
                this.mProcessingEnergy += bRain && aBaseMetaTileEntity.getWorld().field_73008_k >= 4 || !aBaseMetaTileEntity.getSkyAtSide((byte)1) ? 0 : (!bRain && aBaseMetaTileEntity.getWorld().func_72935_r() ? 8 * this.basicTemperatureMod : this.basicTemperatureMod);
            }
            if (this.mTemperature < this.maxProgresstime() && this.mProcessingEnergy > 0 && aTick % 12L == 0L) {
                this.mProcessingEnergy -= this.basicTemperatureMod;
                this.mTemperature += this.basicTemperatureMod;
            }
            aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
        }
    }

    @Override
    public int getCapacity() {
        return 32000;
    }
}

