/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Pollution;
import gregtech.common.gui.GT_Container_Boiler;
import gregtech.common.gui.GT_GUIContainer_Boiler;
import gregtech.common.tileentities.boilers.GT_MetaTileEntity_Boiler;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Boiler_Steel
extends GT_MetaTileEntity_Boiler {
    public GT_MetaTileEntity_Boiler_Steel(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, new String[]{"Faster than the Bronze Boiler", "Produces 300L of Steam per second", "Causes 30 Pollution per second"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Boiler_Steel(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Boiler_Steel(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[5][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            ITexture[] tmp0 = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_STEELBRICKS_BOTTOM, Dyes.getModulation(i, Dyes._NULL.mRGBa))};
            rTextures[0][i + 1] = tmp0;
            ITexture[] tmp1 = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_STEELBRICKS_TOP, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[1][i + 1] = tmp1;
            ITexture[] tmp2 = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[2][i + 1] = tmp2;
            ITexture[] tmp4 = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.BOILER_FRONT)};
            rTextures[3][i + 1] = tmp4;
            ITexture[] tmp5 = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE, Dyes.getModulation(i, Dyes._NULL.mRGBa)), new GT_RenderedTexture(Textures.BlockIcons.BOILER_FRONT_ACTIVE)};
            rTextures[4][i + 1] = tmp5;
        }
        return rTextures;
    }

    @Override
    public int maxProgresstime() {
        return 1000;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_Boiler(aPlayerInventory, aBaseMetaTileEntity, 32000);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_Boiler(aPlayerInventory, aBaseMetaTileEntity, "SteelBoiler.png", 32000);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Boiler_Steel(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick > 20L) {
            if (this.mTemperature <= 20) {
                this.mTemperature = 20;
                this.mLossTimer = 0;
            }
            if (++this.mLossTimer > 40) {
                --this.mTemperature;
                this.mLossTimer = 0;
            }
            for (byte i = 1; this.mSteam != null && i < 6; i = (byte)(i + 1)) {
                int tFilledAmount;
                FluidStack tDrained;
                IFluidHandler tTileEntity;
                if (i == aBaseMetaTileEntity.getFrontFacing() || (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(i)) == null || (tDrained = aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), Math.max(1, this.mSteam.amount / 2), false)) == null || (tFilledAmount = tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), tDrained, false)) <= 0) continue;
                tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), tFilledAmount, true), true);
            }
            if (aTick % 10L == 0L) {
                if (this.mTemperature > 100) {
                    if (this.mFluid == null || !GT_ModHandler.isWater(this.mFluid) || this.mFluid.amount <= 0) {
                        this.mHadNoWater = true;
                    } else {
                        if (this.mHadNoWater) {
                            aBaseMetaTileEntity.doExplosion(2048L);
                            return;
                        }
                        --this.mFluid.amount;
                        if (this.mSteam == null) {
                            this.mSteam = GT_ModHandler.getSteam(150L);
                        } else if (GT_ModHandler.isSteam(this.mSteam)) {
                            this.mSteam.amount += 150;
                        } else {
                            this.mSteam = GT_ModHandler.getSteam(150L);
                        }
                    }
                } else {
                    this.mHadNoWater = false;
                }
            }
            if (this.mSteam != null && this.mSteam.amount > 32000) {
                this.sendSound((byte)1);
                this.mSteam.amount = 24000;
            }
            boolean byproductStuffed = false;
            ItemStack byproductStack = aBaseMetaTileEntity.func_70301_a(3);
            if (byproductStack != null && !GT_Utility.isStackInvalid(byproductStack) && byproductStack.field_77994_a == byproductStack.func_77976_d()) {
                byproductStuffed = true;
            }
            if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork() && this.mInventory[2] != null && !byproductStuffed) {
                int fuelEnergy = 0;
                int byproductChance = 1;
                Materials byproduct = Materials.Ash;
                boolean validFuel = false;
                if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.gem.get(Materials.Coal)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.dust.get(Materials.Coal)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.dustImpure.get(Materials.Coal)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.crushed.get(Materials.Coal))) {
                    fuelEnergy = 160;
                    byproductChance = 3;
                    byproduct = Materials.DarkAsh;
                    validFuel = true;
                } else if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.gem.get(Materials.Charcoal)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.dust.get(Materials.Charcoal)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.dustImpure.get(Materials.Charcoal)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.crushed.get(Materials.Charcoal))) {
                    fuelEnergy = 160;
                    byproductChance = 3;
                    byproduct = Materials.Ash;
                    validFuel = true;
                } else if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], "fuelCoke")) {
                    fuelEnergy = 640;
                    byproductChance = 2;
                    byproduct = Materials.Ash;
                    validFuel = true;
                } else if (GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.gem.get(Materials.Lignite)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.dust.get(Materials.Lignite)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.dustImpure.get(Materials.Lignite)) || GT_OreDictUnificator.isItemStackInstanceOf(this.mInventory[2], OrePrefixes.crushed.get(Materials.Lignite))) {
                    fuelEnergy = 120;
                    byproductChance = 8;
                    byproduct = Materials.DarkAsh;
                    validFuel = true;
                }
                if (validFuel) {
                    this.mProcessingEnergy += fuelEnergy;
                    aBaseMetaTileEntity.func_70298_a(2, 1);
                    if (aBaseMetaTileEntity.getRandomNumber(byproductChance) == 0 && !aBaseMetaTileEntity.addStackToSlot(3, GT_OreDictUnificator.get(OrePrefixes.dustTiny, byproduct, 1L))) {
                        aBaseMetaTileEntity.func_70299_a(3, GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Ash, (long)(byproductStack.field_77994_a + 1)));
                    }
                }
            }
            if (this.mTemperature < 1000 && this.mProcessingEnergy > 0 && aTick % 12L == 0L) {
                this.mProcessingEnergy -= 2;
                ++this.mTemperature;
            }
            if (this.mProcessingEnergy > 0 && aTick % 20L == 0L) {
                GT_Pollution.addPollution(this.getBaseMetaTileEntity(), 30);
            }
            aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
        }
    }

    @Override
    public int getCapacity() {
        return 32000;
    }
}

