/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_BasicMachine;
import gregtech.api.gui.GT_GUIContainer_BasicMachine;
import gregtech.api.gui.GT_Slot_ClosedInteraction;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_AdvSeismicProspector
extends GT_MetaTileEntity_BasicMachine {
    int radius;
    int near;
    int middle;
    int step;
    private int mOilId = 0;
    private ArrayList<Chunk> mOilFieldChunks = new ArrayList();

    public GT_MetaTileEntity_AdvSeismicProspector(int aID, String aName, String aNameRegional, int aTier, int aRadius, int aStep) {
        super(aID, aName, aNameRegional, aTier, 1, "", 1, 1, "SeismicProspector.png", "", new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER));
        this.radius = aRadius;
        this.near = this.radius / 3;
        this.near += this.near % 2;
        this.middle = this.near * 2;
        this.step = aStep;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Activate with explosives:", "32 TNT, 16 Industrial TNT, 8 Glyceryl", "Use Data Stick for save data", "Ore prospection area 191x191 blocks", "Oil prospection area 3x3 oilfields"};
    }

    protected GT_MetaTileEntity_AdvSeismicProspector(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName, int aNear, int aMiddle, int aRadius, int aStep) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
        this.radius = aRadius;
        this.near = aNear;
        this.middle = aMiddle;
        this.step = aStep;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AdvSeismicProspector(this.mName, this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName, this.near, this.middle, this.radius, this.step);
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BasicMachine(aPlayerInventory, aBaseMetaTileEntity){

            @Override
            public Slot provideSpecialSlot(IInventory iInventory, int id, int x, int y) {
                return new GT_Slot_ClosedInteraction(iInventory, id, x, y, p -> this.mProgressTime <= 0 && this.mMaxProgressTime <= 0);
            }
        };
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BasicMachine((GT_Container_BasicMachine)((Object)this.getServerGUI(0, aPlayerInventory, aBaseMetaTileEntity)), this.getLocalName(), this.mGUIName, this.mNEIName);
    }

    @Override
    public int checkRecipe() {
        ItemStack aStack = this.getInputAt(0);
        ItemStack tStack = this.getSpecialSlot();
        if (aStack != null && tStack != null && tStack.field_77994_a == 1 && (ItemList.Tool_DataStick.isStackEqual(tStack, false, true) || ItemList.Tool_CD.isStackEqual(tStack, false, false)) && (GT_Utility.consumeItems(null, aStack, Item.func_150898_a((Block)Blocks.field_150335_W), 32) || GT_Utility.consumeItems(null, aStack, Ic2Items.industrialTnt.func_77973_b(), 16) || GT_Utility.consumeItems(null, aStack, Materials.Glyceryl, 8))) {
            if (aStack.field_77994_a == 0) {
                this.mInventory[this.getInputSlot()] = null;
            }
            this.mMaxProgresstime = 800;
            return 2;
        }
        return 0;
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public void endProcess() {
        ItemStack aStack = this.getSpecialSlot();
        if (aStack == null || aStack.field_77994_a != 1 || !ItemList.Tool_DataStick.isStackEqual(aStack, false, true) && !ItemList.Tool_CD.isStackEqual(aStack, false, false)) {
            return;
        }
        HashMap<String, Integer> tNearOres = new HashMap<String, Integer>();
        HashMap<String, Integer> tMiddleOres = new HashMap<String, Integer>();
        HashMap<String, Integer> tFarOres = new HashMap<String, Integer>();
        this.prospectOres(tNearOres, tMiddleOres, tFarOres);
        ArrayList<String> tOils = new ArrayList<String>();
        this.prospectOils(tOils);
        GT_Utility.ItemNBT.setAdvancedProspectionData(this.mTier, aStack, this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, tOils, GT_Utility.sortByValueToList(tNearOres), GT_Utility.sortByValueToList(tMiddleOres), GT_Utility.sortByValueToList(tFarOres), this.near, this.middle, this.radius);
        this.getBaseMetaTileEntity().disableWorking();
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    private void prospectOils(ArrayList<String> aOils) {
        Chunk tChunk = this.getBaseMetaTileEntity().getWorld().func_72938_d(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
        int range = 6;
        int xChunk = tChunk.field_76635_g / range * range - (tChunk.field_76635_g < 0 && tChunk.field_76635_g % range != 0 ? range : 0);
        int zChunk = tChunk.field_76647_h / range * range - (tChunk.field_76647_h < 0 && tChunk.field_76647_h % range != 0 ? range : 0);
        LinkedHashMap<ChunkCoordIntPair, FluidStack> tFluids = new LinkedHashMap<ChunkCoordIntPair, FluidStack>();
        int oilFieldCount = 0;
        try {
            for (int z = -1; z <= 1; ++z) {
                for (int x = -1; x <= 1; ++x) {
                    ChunkCoordIntPair cInts = this.getBaseMetaTileEntity().getWorld().func_72964_e(x, z).func_76632_l();
                    ArrayList<Integer> minMaxValue = new ArrayList<Integer>();
                    for (int i = 0; i < range; ++i) {
                        for (int j = 0; j < range; ++j) {
                            tChunk = this.getBaseMetaTileEntity().getWorld().func_72964_e(xChunk + i + x * 6, zChunk + j + z * 6);
                            FluidStack tFluid = GT_UndergroundOil.undergroundOilReadInformation(tChunk);
                            if (tFluid == null) continue;
                            minMaxValue.add(tFluid.amount);
                            if (tFluids.containsKey(cInts)) continue;
                            tFluids.put(cInts, tFluid);
                        }
                    }
                    int min = (Integer)Collections.min(minMaxValue);
                    int max = (Integer)Collections.max(minMaxValue);
                    aOils.add(++oilFieldCount + "," + min + "-" + max + "," + ((FluidStack)tFluids.get(cInts)).getLocalizedName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void prospectOres(Map<String, Integer> aNearOres, Map<String, Integer> aMiddleOres, Map<String, Integer> aFarOres) {
        int tLeftXBound = this.getBaseMetaTileEntity().getXCoord() - this.radius;
        int tRightXBound = tLeftXBound + 2 * this.radius;
        int tLeftZBound = this.getBaseMetaTileEntity().getZCoord() - this.radius;
        int tRightZBound = tLeftZBound + 2 * this.radius;
        for (int i = tLeftXBound; i <= tRightXBound; i += this.step) {
            for (int k = tLeftZBound; k <= tRightZBound; k += this.step) {
                int di = Math.abs(i - this.getBaseMetaTileEntity().getXCoord());
                int dk = Math.abs(k - this.getBaseMetaTileEntity().getZCoord());
                if (di <= this.near && dk <= this.near) {
                    this.prospectHole(i, k, aNearOres);
                    continue;
                }
                if (di <= this.middle && dk <= this.middle) {
                    this.prospectHole(i, k, aMiddleOres);
                    continue;
                }
                this.prospectHole(i, k, aFarOres);
            }
        }
    }

    private void prospectHole(int i, int k, Map<String, Integer> aOres) {
        String tFoundOre = null;
        for (int j = this.getBaseMetaTileEntity().getYCoord(); j > 0; --j) {
            tFoundOre = this.checkForOre(i, j, k);
            if (tFoundOre == null) continue;
            GT_MetaTileEntity_AdvSeismicProspector.countOre(aOres, tFoundOre);
        }
    }

    private String checkForOre(int x, int y, int z) {
        Block tBlock = this.getBaseMetaTileEntity().getBlock(x, y, z);
        if (tBlock instanceof GT_Block_Ores_Abstract) {
            Materials tMaterial;
            TileEntity tTileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(x, y, z);
            if (tTileEntity instanceof GT_TileEntity_Ores && ((GT_TileEntity_Ores)tTileEntity).mMetaData < 16000 && (tMaterial = GregTech_API.sGeneratedMaterials[((GT_TileEntity_Ores)tTileEntity).mMetaData % 1000]) != null && tMaterial != Materials._NULL) {
                return tMaterial.mDefaultLocalName;
            }
        } else {
            int tMetaID = this.getBaseMetaTileEntity().getWorld().func_72805_g(x, y, z);
            ItemData tAssotiation = GT_OreDictUnificator.getAssociation(new ItemStack(tBlock, 1, tMetaID));
            if (tAssotiation != null && tAssotiation.mPrefix.toString().startsWith("ore")) {
                return tAssotiation.mMaterial.mMaterial.mDefaultLocalName;
            }
        }
        return null;
    }

    private static void countOre(Map<String, Integer> map, String ore) {
        Integer oldCount = map.get(ore);
        oldCount = oldCount == null ? 0 : oldCount;
        map.put(ore, oldCount + 1);
    }

    @Override
    public long maxEUStore() {
        return 0L;
    }
}

