/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;

public abstract class GT_MetaTileEntity_BasicDrillerBase
extends GT_MetaTileEntity_BasicMachine {
    protected static final ItemStack MINING_PIPE = GT_ModHandler.getIC2Item("miningPipe", 0L);
    protected static final Block MINING_PIPE_BLOCK = GT_Utility.getBlockFromStack(MINING_PIPE);
    protected static final Block MINING_PIPE_TIP_BLOCK = GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 0L));
    int drillX;
    int drillY;
    int drillZ;
    boolean isPickingPipes;
    boolean waitMiningPipe = true;
    private FakePlayer mFakePlayer = null;

    public GT_MetaTileEntity_BasicDrillerBase(int aID, String aName, String aNameRegional, int aTier, String[] aDescription, int aInSlots, int aOutSlots, String aGUIName, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, 1, aDescription, aInSlots, aOutSlots, aGUIName, "", aTextures);
    }

    public GT_MetaTileEntity_BasicDrillerBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aInputSlotCount, int aOutputSlotCount, String aGUIName) {
        super(aName, aTier, 1, aDescription, aTextures, aInputSlotCount, aOutputSlotCount, aGUIName, "");
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && aStack.func_77973_b() == MINING_PIPE.func_77973_b();
    }

    public abstract boolean hasFreeSpace();

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            block15: {
                if (aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.isUniversalEnergyStored(this.getEnergy(this.mTier) * (this.getSpeed(this.mTier) - this.mProgresstime)) && this.hasFreeSpace()) {
                    if (this.waitMiningPipe) {
                        this.mMaxProgresstime = 0;
                        for (int i = 0; i < this.mInputSlotCount; ++i) {
                            ItemStack s = this.getInputAt(i);
                            if (s == null || s.func_77973_b() != MINING_PIPE.func_77973_b() || s.field_77994_a <= 0) continue;
                            this.waitMiningPipe = false;
                            break block15;
                        }
                        return;
                    }
                } else {
                    this.mMaxProgresstime = 0;
                    return;
                }
            }
            aBaseMetaTileEntity.decreaseStoredEnergyUnits(this.getEnergy(this.mTier), true);
            this.mMaxProgresstime = this.getSpeed(this.mTier);
            if (this.mProgresstime == this.getSpeed(this.mTier) - 1) {
                if (this.isPickingPipes) {
                    if (this.drillY == 0) {
                        aBaseMetaTileEntity.disableWorking();
                        this.isPickingPipes = false;
                    } else if (aBaseMetaTileEntity.getBlockOffset(0, this.drillY, 0) == MINING_PIPE_TIP_BLOCK || aBaseMetaTileEntity.getBlockOffset(0, this.drillY, 0) == MINING_PIPE_BLOCK) {
                        this.mOutputItems[0] = MINING_PIPE.func_77946_l();
                        this.mOutputItems[0].field_77994_a = 1;
                        aBaseMetaTileEntity.getWorld().func_147468_f(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord() + this.drillY, aBaseMetaTileEntity.getZCoord());
                        ++this.drillY;
                    }
                    return;
                }
                if (this.drillY == 0) {
                    this.moveOneDown(aBaseMetaTileEntity);
                    return;
                }
                if (this.drillZ > this.getRadius(this.mTier)) {
                    this.moveOneDown(aBaseMetaTileEntity);
                    return;
                }
                while (this.drillZ <= this.getRadius(this.mTier)) {
                    while (this.drillX <= this.getRadius(this.mTier)) {
                        if (this.workBlock(aBaseMetaTileEntity)) {
                            return;
                        }
                        ++this.drillX;
                    }
                    this.drillX = -this.getRadius(this.mTier);
                    ++this.drillZ;
                }
            }
        }
    }

    public abstract int getRadius(int var1);

    public abstract int getSpeed(int var1);

    public abstract int getEnergy(int var1);

    @Override
    public long maxEUStore() {
        return this.mTier == 1 ? 4096L : GT_Values.V[this.mTier] * 64L;
    }

    public abstract boolean workBlock(IGregTechTileEntity var1);

    public abstract boolean moveOneDown(IGregTechTileEntity var1);

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isPickingPipe", this.isPickingPipes);
        aNBT.func_74768_a("drillX", this.drillX);
        aNBT.func_74768_a("drillY", this.drillY);
        aNBT.func_74768_a("drillZ", this.drillZ);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isPickingPipes = aNBT.func_74767_n("isPickingPipe");
        this.drillX = aNBT.func_74762_e("drillX");
        this.drillY = aNBT.func_74762_e("drillY");
        this.drillZ = aNBT.func_74762_e("drillZ");
    }

    protected FakePlayer getFakePlayer(IGregTechTileEntity aBaseTile) {
        if (this.mFakePlayer == null) {
            this.mFakePlayer = GT_Utility.getFakePlayer(aBaseTile);
        }
        this.mFakePlayer.func_70029_a(aBaseTile.getWorld());
        this.mFakePlayer.func_70107_b((double)aBaseTile.getXCoord(), (double)aBaseTile.getYCoord(), (double)aBaseTile.getZCoord());
        return this.mFakePlayer;
    }
}

