/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Transformer;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_DigitalTransformer;
import gregtech.common.gui.GT_GUIContainer_DigitalTransformer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_Digital_Transformer
extends GT_MetaTileEntity_Transformer {
    public int oTier;
    public int oAmp;
    public int iAmp;

    public GT_MetaTileEntity_Digital_Transformer(int aID, String aName, String aNameRegional, int aTier, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aDescription);
    }

    public GT_MetaTileEntity_Digital_Transformer(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Digital_Transformer(this.mName, (int)this.mTier, this.mDescription, this.mTextures);
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{this.getLocalName(), "Input Ampers", this.iAmp + "", "Out Voltage", GT_Values.VN[this.oTier] + " (" + GT_Utility.formatNumbersShort(GT_Values.V[this.oTier]) + ")", "Out Ampers", this.oAmp + ""};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[12][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[1][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[2][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
            rTextures[3][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[4][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[5][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[6][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[7][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[8][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier]};
            rTextures[9][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[10][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[11][i + 1] = new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.DIGITAL_TRANSFORMER[this.mTier]), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
        }
        return rTextures;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_DigitalTransformer(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_DigitalTransformer(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, byte b, ItemStack itemStack) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("tier", this.oTier);
        aNBT.func_74768_a("oAmp", this.oAmp);
        aNBT.func_74768_a("iAmp", this.iAmp);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.oTier = aNBT.func_74762_e("tier");
        this.oAmp = aNBT.func_74762_e("oAmp");
        this.iAmp = aNBT.func_74762_e("iAmp");
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return GT_Values.V[this.oTier];
    }

    @Override
    public long maxAmperesOut() {
        return this.oAmp;
    }

    @Override
    public long maxAmperesIn() {
        return this.iAmp;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Accepts " + GT_Values.V[this.mTier] + "V"};
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public long maxEUStore() {
        return 512L + GT_Values.V[this.mTier] * 256L;
    }
}

