/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_BasicDrillerBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.FakePlayer;

public class GT_MetaTileEntity_Miner
extends GT_MetaTileEntity_BasicDrillerBase {
    protected static int[] RADIUS = new int[]{8, 8, 16, 24};
    protected static int[] SPEED = new int[]{160, 160, 80, 40};
    protected static int[] ENERGY = new int[]{8, 8, 32, 128};
    private FakePlayer mFakePlayer = null;

    public GT_MetaTileEntity_Miner(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{"Digging ore instead of you", ENERGY[aTier] + " EU/t, " + SPEED[aTier] / 20 + " sec per block", "Work area " + (RADIUS[aTier] * 2 + 1) + "x" + (RADIUS[aTier] * 2 + 1)}, 2, 2, "Miner.png", new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_SIDE_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_SIDE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_TOP_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_TOP")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_BOTTOM_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_BOTTOM")));
    }

    public GT_MetaTileEntity_Miner(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName) {
        super(aName, aTier, aDescription, aTextures, 2, 2, aGUIName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Miner(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && aStack.func_77973_b() == MINING_PIPE.func_77973_b();
    }

    @Override
    public boolean hasFreeSpace() {
        for (int i = this.getOutputSlot(); i < this.getOutputSlot() + 2; ++i) {
            if (this.mInventory[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getRadius(int aTier) {
        return RADIUS[aTier];
    }

    @Override
    public int getSpeed(int aTier) {
        return SPEED[aTier];
    }

    @Override
    public int getEnergy(int aTier) {
        return ENERGY[aTier];
    }

    @Override
    public boolean workBlock(IGregTechTileEntity aBaseMetaTileEntity) {
        Block block = aBaseMetaTileEntity.getBlockOffset(this.drillX, this.drillY, this.drillZ);
        byte blockMeta = aBaseMetaTileEntity.getMetaIDOffset(this.drillX, this.drillY, this.drillZ);
        if (block instanceof GT_Block_Ores_Abstract) {
            TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityOffset(this.drillX, this.drillY, this.drillZ);
            if (tTileEntity != null && tTileEntity instanceof GT_TileEntity_Ores && ((GT_TileEntity_Ores)tTileEntity).mNatural) {
                this.mineBlock(aBaseMetaTileEntity, this.drillX, this.drillY, this.drillZ);
                return true;
            }
        } else {
            ItemData association = GT_OreDictUnificator.getAssociation(new ItemStack(block, 1, (int)blockMeta));
            if (association != null && association.mPrefix.toString().startsWith("ore")) {
                this.mineBlock(aBaseMetaTileEntity, this.drillX, this.drillY, this.drillZ);
                return true;
            }
        }
        return false;
    }

    @Override
    public long maxEUStore() {
        return this.mTier == 1 ? 4096L : GT_Values.V[this.mTier] * 64L;
    }

    @Override
    public boolean moveOneDown(IGregTechTileEntity aBaseMetaTileEntity) {
        block5: {
            if (aBaseMetaTileEntity.getYCoord() + this.drillY - 1 < 0 || GT_Utility.getBlockHardnessAt(aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord() + this.drillY - 1, aBaseMetaTileEntity.getZCoord()) < 0.0f || !GT_Utility.setBlockByFakePlayer(this.getFakePlayer(aBaseMetaTileEntity), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord() + this.drillY - 1, aBaseMetaTileEntity.getZCoord(), MINING_PIPE_TIP_BLOCK, 0, true)) {
                this.isPickingPipes = true;
                return false;
            }
            if (aBaseMetaTileEntity.getBlockOffset(0, this.drillY, 0) == MINING_PIPE_TIP_BLOCK) {
                aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord() + this.drillY, aBaseMetaTileEntity.getZCoord(), MINING_PIPE_BLOCK);
            }
            for (int i = 0; i < this.mInputSlotCount; ++i) {
                ItemStack s = this.getInputAt(i);
                if (s == null || s.func_77973_b() != MINING_PIPE.func_77973_b() || s.field_77994_a <= 0) continue;
                --s.field_77994_a;
                if (s.field_77994_a == 0) {
                    this.mInventory[this.getInputSlot() + i] = null;
                }
                break block5;
            }
            this.waitMiningPipe = true;
            return false;
        }
        if (aBaseMetaTileEntity.getBlockOffset(0, this.drillY - 1, 0) != Blocks.field_150350_a) {
            this.mineBlock(aBaseMetaTileEntity, 0, this.drillY - 1, 0);
        }
        aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord() + this.drillY - 1, aBaseMetaTileEntity.getZCoord(), MINING_PIPE_TIP_BLOCK);
        --this.drillY;
        this.drillZ = -RADIUS[this.mTier];
        this.drillX = -RADIUS[this.mTier];
        return true;
    }

    public void mineBlock(IGregTechTileEntity aBaseMetaTileEntity, int x, int y, int z) {
        ArrayList<ItemStack> drops;
        if (!GT_Utility.eraseBlockByFakePlayer(this.getFakePlayer(aBaseMetaTileEntity), aBaseMetaTileEntity.getXCoord() + x, aBaseMetaTileEntity.getYCoord() + y, aBaseMetaTileEntity.getZCoord() + z, true)) {
            // empty if block
        }
        if ((drops = this.getBlockDrops(aBaseMetaTileEntity.getBlockOffset(x, y, z), aBaseMetaTileEntity.getXCoord() + x, aBaseMetaTileEntity.getYCoord() + y, aBaseMetaTileEntity.getZCoord() + z)).size() > 0) {
            this.mOutputItems[0] = drops.get(0);
        }
        if (drops.size() > 1) {
            this.mOutputItems[1] = drops.get(1);
        }
        aBaseMetaTileEntity.getWorld().func_147468_f(aBaseMetaTileEntity.getXCoord() + x, aBaseMetaTileEntity.getYCoord() + y, aBaseMetaTileEntity.getZCoord() + z);
    }

    private ArrayList<ItemStack> getBlockDrops(Block oreBlock, int posX, int posY, int posZ) {
        byte blockMeta = this.getBaseMetaTileEntity().getMetaID(posX, posY, posZ);
        return oreBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), posX, posY, posZ, (int)blockMeta, 1);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isPickingPipe", this.isPickingPipes);
        aNBT.func_74768_a("drillX", this.drillX);
        aNBT.func_74768_a("drillY", this.drillY);
        aNBT.func_74768_a("drillZ", this.drillZ);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isPickingPipes = aNBT.func_74767_n("isPickingPipe");
        this.drillX = aNBT.func_74762_e("drillX");
        this.drillY = aNBT.func_74762_e("drillY");
        this.drillZ = aNBT.func_74762_e("drillZ");
    }

    @Override
    protected FakePlayer getFakePlayer(IGregTechTileEntity aBaseTile) {
        if (this.mFakePlayer == null) {
            this.mFakePlayer = GT_Utility.getFakePlayer(aBaseTile);
        }
        this.mFakePlayer.func_70029_a(aBaseTile.getWorld());
        this.mFakePlayer.func_70107_b((double)aBaseTile.getXCoord(), (double)aBaseTile.getYCoord(), (double)aBaseTile.getZCoord());
        return this.mFakePlayer;
    }
}

