/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.core.item.ItemCropSeed;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_OrganicReplicator
extends GT_MetaTileEntity_BasicMachine {
    private static short EUMultiplier = (short)500;
    private static float UUMatterMultiplier = 2.0f;

    public GT_MetaTileEntity_OrganicReplicator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{"Copies seeds with efficiency: " + Math.min((aTier + 5) * 10, 100) + "%", "Uses UUMatter for each seed", "The better crop the more UUMatter it needs", "Can replicate only scanned seeds"}, 1, 1, "OrganicReplicator.png", "", new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/organic_replicator/OVERLAY_SIDE_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/organic_replicator/OVERLAY_SIDE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/organic_replicator/OVERLAY_FRONT_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/organic_replicator/OVERLAY_FRONT")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/organic_replicator/OVERLAY_TOP_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/organic_replicator/OVERLAY_TOP")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/organic_replicator/OVERLAY_BOTTOM_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/organic_replicator/OVERLAY_BOTTOM")));
    }

    public GT_MetaTileEntity_OrganicReplicator(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    public GT_MetaTileEntity_OrganicReplicator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_OrganicReplicator(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public int checkRecipe() {
        FluidStack tFluid = this.getFillableStack();
        ItemStack aStack = this.getInputAt(0);
        float efficiency = Math.min((this.mTier + 5) * 10, 100);
        if (tFluid == null || !tFluid.isFluidEqual(Materials.UUMatter.getFluid(1L))) {
            return 0;
        }
        if (ItemList.IC2_Crop_Seeds.isStackEqual(aStack, true, true) && this.isOutputEmpty()) {
            NBTTagCompound tNBT = aStack.func_77978_p();
            if (tNBT == null) {
                tNBT = new NBTTagCompound();
            }
            if (tNBT.func_74771_c("scan") == 4) {
                byte aGain = ItemCropSeed.getGainFromStack((ItemStack)aStack);
                byte aGrowth = ItemCropSeed.getGrowthFromStack((ItemStack)aStack);
                byte aResistance = ItemCropSeed.getResistanceFromStack((ItemStack)aStack);
                CropCard v = Crops.instance.getCropCard(aStack);
                int aCropTier = v.tier();
                int UUMConsume = Math.round((float)(aCropTier * 4 + aGain + aGrowth + aResistance) * UUMatterMultiplier);
                if (UUMConsume > tFluid.amount) {
                    return 0;
                }
                this.mEUt = (int)GT_Values.V[this.mTier] * 15 / 16;
                this.mMaxProgresstime = (aCropTier + 1) * EUMultiplier / (1 << this.mTier - 1);
                tFluid.amount -= UUMConsume;
                this.mOutputItems[0] = GT_Utility.copyAmount(1L, aStack);
                this.mOutputItems[0].func_77982_d(tNBT);
                if ((float)this.getBaseMetaTileEntity().getRandomNumber(100) > efficiency) {
                    this.mOutputItems[0] = null;
                }
                return 2;
            }
        }
        if (super.checkRecipe() == 2) {
            if ((float)this.getBaseMetaTileEntity().getRandomNumber(100) > efficiency) {
                this.mOutputItems[0] = null;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        EUMultiplier = (short)aConfig.get((Object)ConfigCategories.machineconfig, "organicreplicator.euMultiplier", 500);
        UUMatterMultiplier = aConfig.get((Object)ConfigCategories.machineconfig, "organicreplicator.UUMatterMultiplier", 2);
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return GT_Recipe.GT_Recipe_Map.sOrganicReplicatorRecipes;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && ItemList.IC2_Crop_Seeds.isStackEqual(aStack);
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.isFluidEqual(Materials.UUMatter.getFluid(1L));
    }

    @Override
    public int getCapacity() {
        return 100000;
    }
}

