/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTech_API;
import gregtech.api.enums.RelativeOffset;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_PrimitiveMuscleMachine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class GT_MetaTileEntity_PrimitiveMineDigger
extends GT_MetaTileEntity_PrimitiveMuscleMachine {
    private boolean foundOre = false;
    private int digHeight = 0;
    private int digsCount = 0;
    private final int setTorchEachBlocks = 16;
    private int oreVienHeight = 7;
    private boolean finalStop = false;
    private boolean isPickupLadders = false;
    private int ladderIdx = -1;
    private int cobblestoneIdx = -1;
    private int torchIdx = -1;
    private boolean meetNotHarvestableLayer = false;

    public GT_MetaTileEntity_PrimitiveMineDigger(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("finalStop", this.finalStop);
        aNBT.func_74768_a("digHeight", this.digHeight);
        aNBT.func_74768_a("digsCount", this.digsCount);
        aNBT.func_74757_a("isPickupLadders", this.isPickupLadders);
        aNBT.func_74757_a("meetNotHarvestableLayer", this.meetNotHarvestableLayer);
        aNBT.func_74757_a("foundOre", this.foundOre);
        aNBT.func_74768_a("oreVienHeight", this.oreVienHeight);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.finalStop = aNBT.func_74767_n("finalStop");
        this.digHeight = aNBT.func_74762_e("digHeight");
        this.digsCount = aNBT.func_74762_e("digsCount");
        this.isPickupLadders = aNBT.func_74767_n("isPickupLadders");
        this.meetNotHarvestableLayer = aNBT.func_74767_n("meetNotHarvestableLayer");
        this.foundOre = aNBT.func_74767_n("foundOre");
        this.oreVienHeight = aNBT.func_74762_e("oreVienHeight");
    }

    public GT_MetaTileEntity_PrimitiveMineDigger(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_PrimitiveMineDigger(this.mName);
    }

    @Override
    public int getHungryDurationPerOperation() {
        return 320;
    }

    @Override
    public int getDamagePerOperation() {
        return 12;
    }

    @Override
    public int getProgresstimePerOre() {
        return this.isPickupLadders ? 5 : 20;
    }

    @Override
    public boolean isDrillRequiredToWork() {
        return !this.isPickupLadders;
    }

    @Override
    public int getDecreaseSteamPerOperation() {
        int steamPerOperation = 1;
        if (this.isPickupLadders) {
            ++this.digsCount;
            int pickupCheeperInTimes = 8;
            steamPerOperation = this.digsCount % pickupCheeperInTimes == 0 ? 1 : 0;
        }
        return steamPerOperation;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Mine a small hole down with your muscle power", "Required items: Primitive Drill, Ladder, Cobblestone", "Optional are torches (will be placed on dig finish)", "To start pickup torches and ladders you have to remove", "all items from inputs except cobblestone, to fill holes", "Digger will stop if found an ore vein in a 3x3 radius or bedrock block", "Working speed depends on stored energy", "Required a lot of muscle power - you will be hungry!"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[10], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_PRIMITIVE_MINE_DIGGER_DRILL : Textures.BlockIcons.OVERLAY_PRIMITIVE_MINE_DIGGER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[10]};
    }

    public boolean validate() {
        boolean isValid = true;
        this.ladderIdx = -1;
        this.cobblestoneIdx = -1;
        this.torchIdx = -1;
        for (int i = 0; i < 5; ++i) {
            ItemStack its = this.mInventory[i];
            if (its == null) continue;
            if (this.ladderIdx == -1 && its.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150468_ap))) {
                this.ladderIdx = i;
            }
            if (this.cobblestoneIdx == -1 && its.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150347_e))) {
                this.cobblestoneIdx = i;
            }
            if (this.torchIdx != -1 || !its.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150478_aa))) continue;
            this.torchIdx = i;
        }
        if (this.ladderIdx == -1) {
            isValid = false;
        }
        return isValid;
    }

    public boolean validateForPickUp() {
        int drillIdx = -1;
        this.ladderIdx = -1;
        this.cobblestoneIdx = -1;
        this.torchIdx = -1;
        for (int i = 0; i < 5; ++i) {
            ItemStack its = this.mInventory[i];
            if (its == null) continue;
            if (drillIdx == -1 && its.func_77960_j() == 180) {
                drillIdx = i;
            }
            if (this.ladderIdx == -1 && its.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150468_ap))) {
                this.ladderIdx = i;
            }
            if (this.cobblestoneIdx == -1 && its.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150347_e))) {
                this.cobblestoneIdx = i;
            }
            if (this.torchIdx != -1 || !its.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150478_aa))) continue;
            this.torchIdx = i;
        }
        return drillIdx == -1 && this.ladderIdx == -1 && this.torchIdx == -1 && this.cobblestoneIdx > -1;
    }

    @Override
    protected void endProcess(IGregTechTileEntity aBaseMetaTileEntity) {
        this.digNextLayer(aBaseMetaTileEntity);
    }

    private boolean digNextLayer(IGregTechTileEntity aBaseMetaTileEntity) {
        if (!this.validate()) {
            return false;
        }
        if (this.digHeight == 0) {
            this.digHeight = aBaseMetaTileEntity.getYCoord();
        }
        World aWorld = aBaseMetaTileEntity.getWorld();
        int checkForOreInRadius = 2;
        ArrayList<ChunkPosition> blocksPos = GT_Utility.getBlocksAtLayer(aBaseMetaTileEntity, this.digHeight - 1, checkForOreInRadius);
        for (ChunkPosition pos : blocksPos) {
            Block aBlock = aWorld.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            int tMeta = aWorld.func_72805_g(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            if (aBlock == Blocks.field_150350_a) continue;
            if (Blocks.field_150357_h.equals(aBlock) || this.oreVienHeight <= 0 || this.isNextLayerContainsOre(aBaseMetaTileEntity)) {
                this.meetNotHarvestableLayer = true;
                break;
            }
            if (!this.foundOre(aBlock, aWorld, pos, tMeta)) continue;
            this.foundOre = true;
        }
        this.doWorkSound(aBaseMetaTileEntity, !this.meetNotHarvestableLayer);
        if (!this.meetNotHarvestableLayer) {
            --this.digHeight;
            if (this.foundOre) {
                --this.oreVienHeight;
            }
            this.digHole(aBaseMetaTileEntity);
        } else if (this.torchIdx > -1 && aBaseMetaTileEntity.isServerSide()) {
            this.setTorches(aBaseMetaTileEntity);
        }
        return !this.meetNotHarvestableLayer;
    }

    private boolean foundOre(Block aBlock, World aWorld, ChunkPosition pos, int tMeta) {
        boolean isOre = GT_OreDictUnificator.isGtOre(aBlock);
        return isOre && !GT_OreDictUnificator.isSmallOre(aWorld, aBlock, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, tMeta);
    }

    private void setTorches(IGregTechTileEntity te) {
        World aWorld = te.getWorld();
        int aY = this.digHeight;
        boolean placeToSetTorch = true;
        if (this.isUnstableBlock(aWorld.func_147439_a(te.getXCoord(), aY - 1, te.getZCoord()))) {
            if (this.decreaseInventoryItem(this.cobblestoneIdx)) {
                aWorld.func_147449_b(te.getXCoord(), aY - 1, te.getZCoord(), Blocks.field_150347_e);
            } else {
                placeToSetTorch = false;
            }
        }
        if (placeToSetTorch && this.decreaseInventoryItem(this.torchIdx)) {
            aWorld.func_147465_d(te.getXCoord(), aY, te.getZCoord(), Blocks.field_150478_aa, 0, 3);
        }
        if (te.getYCoord() > (aY += 16) && this.mInventory[this.torchIdx] != null) {
            this.setTorchOnWall(te, aY);
        }
    }

    private void setTorchOnWall(IGregTechTileEntity te, int aY) {
        World aWorld = te.getWorld();
        ChunkPosition chPos = GT_Utility.getFrontRelativeOffset(te, RelativeOffset.BACK, 1, aY);
        boolean placeToSetTorch = true;
        if (this.isUnstableBlock(aWorld.func_147439_a(chPos.field_151329_a, chPos.field_151327_b, chPos.field_151328_c))) {
            if (this.decreaseInventoryItem(this.cobblestoneIdx)) {
                aWorld.func_147449_b(chPos.field_151329_a, chPos.field_151327_b, chPos.field_151328_c, Blocks.field_150347_e);
            } else {
                placeToSetTorch = false;
            }
        }
        if (placeToSetTorch && this.decreaseInventoryItem(this.torchIdx)) {
            aWorld.func_147465_d(te.getXCoord(), aY, te.getZCoord(), Blocks.field_150478_aa, this.getTorchLadderMetaByFrontSize(te, false), 3);
        }
        if (te.getYCoord() > (aY += 16) && this.mInventory[this.torchIdx] != null) {
            this.setTorchOnWall(te, aY);
        }
    }

    public void doWorkSoundPickUp(IGregTechTileEntity aBaseMetaTileEntity) {
        GT_Utility.sendSoundToPlayers(aBaseMetaTileEntity.getWorld(), GregTech_API.sSoundList.get(6), 0.1f, -1.0f, aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
    }

    @Override
    public void doWorkSound(IGregTechTileEntity aBaseMetaTileEntity, boolean isSuccess) {
        GT_Utility.sendSoundToPlayers(aBaseMetaTileEntity.getWorld(), GregTech_API.sSoundList.get(isSuccess ? 101 : 6), isSuccess ? 1.0f : 0.8f, -1.0f, aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
    }

    private boolean checkIsPriorityGrass(IGregTechTileEntity te) {
        World aWorld = te.getWorld();
        int grassTypes = 0;
        int sandTypes = 0;
        for (int y = te.getYCoord() - 3; y <= te.getYCoord() + 3; ++y) {
            for (int x = te.getXCoord() - 3; x <= te.getXCoord() + 3; ++x) {
                for (int z = te.getZCoord() - 3; z <= te.getZCoord() + 3; ++z) {
                    Block aBlock = aWorld.func_147439_a(x, y, z);
                    if (Blocks.field_150349_c.equals(aBlock) || Blocks.field_150346_d.equals(aBlock)) {
                        ++grassTypes;
                    }
                    if (!Blocks.field_150354_m.equals(aBlock) && !Blocks.field_150322_A.equals(aBlock)) continue;
                    ++sandTypes;
                }
            }
        }
        return grassTypes >= sandTypes;
    }

    private Block getTrashBlock(IGregTechTileEntity te, boolean isNextToTop) {
        Block aBlock = null;
        int[] idxes = new int[]{-1, -1, -1, -1, -1};
        int maxPriorityIdx = -1;
        for (int i = 27; i >= 0; --i) {
            ItemStack its = this.mInventory[i];
            if (its == null || Blocks.field_150350_a.equals(aBlock = Block.func_149634_a((Item)its.func_77973_b())) || Blocks.field_150468_ap.equals(aBlock) || Blocks.field_150478_aa.equals(aBlock)) continue;
            if (idxes[0] == -1 && (Blocks.field_150346_d.equals(aBlock) || Blocks.field_150349_c.equals(aBlock))) {
                idxes[0] = i;
                continue;
            }
            if (idxes[1] == -1 && (Blocks.field_150322_A.equals(aBlock) || Blocks.field_150354_m.equals(aBlock))) {
                idxes[1] = i;
                continue;
            }
            if (idxes[2] == -1 && (Blocks.field_150351_n.equals(aBlock) || Blocks.field_150354_m.equals(aBlock))) {
                idxes[2] = i;
                continue;
            }
            if (idxes[3] == -1) {
                idxes[3] = i;
                continue;
            }
            if (idxes[4] != -1) continue;
            idxes[4] = i;
        }
        if (isNextToTop && (idxes[0] > -1 || idxes[1] > -1)) {
            boolean isPriorityGrass = this.checkIsPriorityGrass(te) && idxes[0] > -1;
            maxPriorityIdx = isPriorityGrass ? idxes[0] : idxes[1];
        } else if (idxes[2] > -1) {
            maxPriorityIdx = idxes[2];
        }
        if (maxPriorityIdx == -1) {
            maxPriorityIdx = Math.max(idxes[3], idxes[4]);
        }
        if (maxPriorityIdx == -1) {
            maxPriorityIdx = Math.max(idxes[0], idxes[1]);
        }
        if (maxPriorityIdx == -1) {
            return null;
        }
        if (this.mInventory[maxPriorityIdx] != null) {
            aBlock = Block.func_149634_a((Item)this.mInventory[maxPriorityIdx].func_77973_b());
            this.decreaseInventoryItem(maxPriorityIdx);
        }
        return aBlock;
    }

    public boolean pickUpLadder(IGregTechTileEntity te) {
        boolean success = true;
        World aWorld = te.getWorld();
        ArrayList<ItemStack> layerDrop = new ArrayList<ItemStack>();
        ArrayList<ChunkPosition> blocksPosToCheck = new ArrayList<ChunkPosition>();
        blocksPosToCheck.add(GT_Utility.getFrontRelativeOffset(te, RelativeOffset.FORWARD, 1, this.digHeight));
        blocksPosToCheck.add(new ChunkPosition(te.getXCoord(), this.digHeight, te.getZCoord()));
        boolean isNextToTop = te.getYCoord() - 3 <= this.digHeight;
        for (ChunkPosition pos : blocksPosToCheck) {
            Block aBlock = aWorld.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            int tMeta = aWorld.func_72805_g(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            Block aBlockToPut = this.getTrashBlock(te, isNextToTop);
            if (aBlockToPut != null) {
                if (aBlock != Blocks.field_150350_a) {
                    layerDrop.addAll(aBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, tMeta, 1));
                }
                aWorld.func_147449_b(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, aBlockToPut);
                continue;
            }
            success = false;
        }
        if (!layerDrop.isEmpty()) {
            this.pushToOutputSlots(layerDrop);
        }
        if (success) {
            ++this.digHeight;
            if (te.getYCoord() == this.digHeight) {
                this.finalStop = true;
            }
            this.doWorkSoundPickUp(te);
        }
        return success;
    }

    private boolean isNextLayerContainsOre(IGregTechTileEntity te) {
        ArrayList<ChunkPosition> blocksToCheck = new ArrayList<ChunkPosition>();
        blocksToCheck.add(GT_Utility.getFrontRelativeOffset(te, RelativeOffset.FORWARD, 0, this.digHeight - 1));
        blocksToCheck.add(GT_Utility.getFrontRelativeOffset(te, RelativeOffset.FORWARD, 1, this.digHeight - 1));
        for (ChunkPosition blockToCheck : blocksToCheck) {
            Block aBlock = te.getWorld().func_147439_a(blockToCheck.field_151329_a, blockToCheck.field_151327_b, blockToCheck.field_151328_c);
            int tMeta = te.getWorld().func_72805_g(blockToCheck.field_151329_a, blockToCheck.field_151327_b, blockToCheck.field_151328_c);
            if (!this.foundOre(aBlock, te.getWorld(), blockToCheck, tMeta)) continue;
            return true;
        }
        return false;
    }

    public void digHole(IGregTechTileEntity te) {
        World aWorld = te.getWorld();
        ArrayList<ItemStack> layerDrop = new ArrayList<ItemStack>();
        ArrayList<ChunkPosition> blocksPosToCheck = new ArrayList<ChunkPosition>();
        blocksPosToCheck.add(GT_Utility.getFrontRelativeOffset(te, RelativeOffset.FORWARD, 1, this.digHeight));
        blocksPosToCheck.add(new ChunkPosition(te.getXCoord(), this.digHeight, te.getZCoord()));
        for (ChunkPosition pos : blocksPosToCheck) {
            Block aBlock = aWorld.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            int tMeta = aWorld.func_72805_g(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            if (aBlock == Blocks.field_150350_a || this.foundOre(aBlock, aWorld, pos, tMeta)) continue;
            layerDrop.addAll(aBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, tMeta, 1));
            aWorld.func_147468_f(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        }
        if (!layerDrop.isEmpty()) {
            this.pushToOutputSlots(layerDrop);
        }
        ChunkPosition chPos = GT_Utility.getFrontRelativeOffset(te, RelativeOffset.FORWARD, 2, this.digHeight);
        boolean stabilized = true;
        if (this.isUnstableBlock(aWorld.func_147439_a(chPos.field_151329_a, chPos.field_151327_b, chPos.field_151328_c)) && (stabilized = this.decreaseInventoryItem(this.cobblestoneIdx))) {
            aWorld.func_147449_b(chPos.field_151329_a, chPos.field_151327_b, chPos.field_151328_c, Blocks.field_150347_e);
        }
        if (stabilized) {
            chPos = GT_Utility.getFrontRelativeOffset(te, RelativeOffset.FORWARD, 1, this.digHeight);
            if (this.decreaseInventoryItem(this.ladderIdx)) {
                aWorld.func_147465_d(chPos.field_151329_a, chPos.field_151327_b, chPos.field_151328_c, Blocks.field_150468_ap, this.getTorchLadderMetaByFrontSize(te, true), 3);
            }
        }
    }

    private int getTorchLadderMetaByFrontSize(IGregTechTileEntity te, boolean isLadder) {
        if (te.getFrontFacing() == 2) {
            return isLadder ? 3 : 4;
        }
        if (te.getFrontFacing() == 3) {
            return isLadder ? 2 : 3;
        }
        if (te.getFrontFacing() == 4) {
            return isLadder ? 5 : 0;
        }
        return isLadder ? 4 : 1;
    }

    @Override
    public boolean isReadyToDig() {
        if (this.finalStop) {
            return false;
        }
        BaseMetaTileEntity te = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        if (!this.meetNotHarvestableLayer && this.validate()) {
            return true;
        }
        if (this.meetNotHarvestableLayer) {
            if (!this.isPickupLadders) {
                this.isPickupLadders = this.validateForPickUp();
            }
            return this.isPickupLadders && this.pickUpLadder(te);
        }
        return false;
    }
}

