/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_PrimitiveMuscleMachine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class GT_MetaTileEntity_PrimitiveMiner
extends GT_MetaTileEntity_PrimitiveMuscleMachine {
    private int digHeight = 0;
    private int cobblestoneDirtIdx = -1;

    public GT_MetaTileEntity_PrimitiveMiner(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_PrimitiveMiner(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_PrimitiveMiner(this.mName);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Search and dig only small ores in 7 by 7 radius", "Required items: Primitive Drill, Cobblestone or Dirt", "Cobblestone or Dirt will be placed instead of small ore", "Miner do not leave a hole under it while working", "Working speed depends on stored energy", "Required a lot of muscle power - you will be hungry"};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("digHeight", this.digHeight);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.digHeight = aNBT.func_74762_e("digHeight");
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[10], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_PRIMITIVE_MINER_DRILL : Textures.BlockIcons.OVERLAY_PRIMITIVE_MINER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[10]};
    }

    public boolean haveConsumableItems() {
        this.cobblestoneDirtIdx = -1;
        for (int i = 0; i < 5; ++i) {
            ItemStack its = this.mInventory[i];
            if (its == null || this.cobblestoneDirtIdx != -1 || !its.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150347_e)) && !its.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150346_d))) continue;
            this.cobblestoneDirtIdx = i;
        }
        return this.cobblestoneDirtIdx != -1;
    }

    private boolean digNextOre(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.digHeight == 1 || !this.haveConsumableItems()) {
            return false;
        }
        this.digHeight = this.digHeight == 0 ? aBaseMetaTileEntity.getYCoord() - 1 : --this.digHeight;
        boolean foundOreInLayer = false;
        ArrayList<ItemStack> layerDrop = new ArrayList<ItemStack>();
        World aWorld = aBaseMetaTileEntity.getWorld();
        int checkForOreInRadius = 3;
        ArrayList<ChunkPosition> blocksPos = GT_Utility.getBlocksAtLayer(aBaseMetaTileEntity, this.digHeight, checkForOreInRadius);
        for (ChunkPosition pos : blocksPos) {
            if (foundOreInLayer) continue;
            Block aBlock = aWorld.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            int tMeta = aWorld.func_72805_g(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            if (Blocks.field_150350_a.equals(aBlock) || !GT_OreDictUnificator.isSmallOre(aWorld, aBlock, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, tMeta)) continue;
            foundOreInLayer = true;
            layerDrop.addAll(aBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, tMeta, 1));
            Block blockToSet = GT_Utility.decreaseInvItemAndGetBlock(this.mInventory, this.cobblestoneDirtIdx);
            if (blockToSet != null) {
                aWorld.func_147468_f(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                aWorld.func_147449_b(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, blockToSet);
                continue;
            }
            ++this.digHeight;
            return false;
        }
        if (!foundOreInLayer) {
            return this.digNextOre(aBaseMetaTileEntity);
        }
        if (!layerDrop.isEmpty()) {
            this.pushToOutputSlots(layerDrop);
        }
        this.doWorkSound(aBaseMetaTileEntity);
        return foundOreInLayer;
    }

    @Override
    public int getDecreaseFoodPerOperation() {
        return 2;
    }

    @Override
    public int getHungryDurationPerOperation() {
        return 480;
    }

    @Override
    public int getDamagePerOperation() {
        return 25;
    }

    @Override
    public int getProgresstimePerOre() {
        return 480;
    }

    @Override
    public boolean isReadyToDig() {
        return this.digHeight != 1 && this.haveConsumableItems();
    }

    @Override
    protected void endProcess(IGregTechTileEntity aBaseMetaTileEntity) {
        this.digNextOre(aBaseMetaTileEntity);
    }
}

