/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_PrimitiveMiner;
import gregtech.api.gui.GT_GUIContainer_PrimitiveMiner;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_PrimitiveMuscleMachine
extends GT_MetaTileEntity_BasicMachine {
    public GT_MetaTileEntity_PrimitiveMuscleMachine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 1, 1, "", 4, 24, null, "", new ITexture[0]);
    }

    public GT_MetaTileEntity_PrimitiveMuscleMachine(String aName) {
        super(aName, 4, 24);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_PrimitiveMuscleMachine(this.mName);
    }

    public int getPowerPerClick() {
        return 8;
    }

    public int getHungryDurationPerOperation() {
        return 480;
    }

    public int getDamagePerOperation() {
        return 25;
    }

    public int getProgresstimePerOre() {
        return 480;
    }

    public int getDecreaseSteamPerOperation() {
        return 1;
    }

    public int getDecreaseFoodPerOperation() {
        return 1;
    }

    public boolean isDrillRequiredToWork() {
        return true;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean isUnstableBlock(Block aBlock) {
        return !aBlock.func_149662_c();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (aBaseMetaTileEntity.hasInventoryBeenModified() && this.getProgresstime() < 0) {
                this.resetProgress();
                return;
            }
            if (this.getProgresstime() < this.maxProgresstime()) {
                this.increaseProgress(1);
            } else {
                if (this.getProgresstime() > 0 && aBaseMetaTileEntity.getMaxProgress() > 0) {
                    this.endProcess(aBaseMetaTileEntity);
                }
                this.resetProgress();
                if (!this.isReadyToDig()) {
                    this.resetProgress();
                } else {
                    BaseMetaTileEntity te = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
                    if (this.findAndAddDmgToDrill(false) && this.hasEnoughEnergyToCheckRecipe() && te.decreaseStoredSteam(this.getDecreaseSteamPerOperation(), false) && this.findAndAddDmgToDrill(true)) {
                        this.setMaxProgresstime(this.calcProgressTimeOnEnergyAmount(te));
                    }
                }
            }
            aBaseMetaTileEntity.setActive(this.getProgresstime() > 0);
        }
    }

    public boolean findAndAddDmgToDrill(boolean addDamage) {
        if (!this.isDrillRequiredToWork()) {
            return true;
        }
        int drillIdx = -1;
        for (int i = 0; i < 5; ++i) {
            ItemStack its = this.mInventory[i];
            if (its == null || drillIdx != -1 || its.func_77960_j() != 180) continue;
            drillIdx = i;
        }
        if (addDamage && GT_MetaGenerated_Tool.addDmgAndCheckIsDestroy(this.mInventory[drillIdx], this.getDamagePerOperation())) {
            this.mInventory[drillIdx] = null;
        }
        return drillIdx != -1;
    }

    private int calcProgressTimeOnEnergyAmount(BaseMetaTileEntity te) {
        return this.getProgresstimePerOre() - Math.round((float)(te.getStoredSteam() * (long)this.getProgresstimePerOre()) / 2.0f / (float)this.maxSteamStore());
    }

    public boolean isReadyToDig() {
        return false;
    }

    @Override
    protected boolean hasEnoughEnergyToCheckRecipe() {
        return this.getBaseMetaTileEntity().getStoredSteam() > 0L;
    }

    protected void endProcess(IGregTechTileEntity aBaseMetaTileEntity) {
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        BaseMetaTileEntity te = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        aNBT.func_74768_a("steamEnergy", (int)te.getStoredSteam());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        BaseMetaTileEntity te = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        te.setStoredSteam(aNBT.func_74762_e("steamEnergy"));
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_PrimitiveMiner(aPlayerInventory, aBaseMetaTileEntity, this.getPowerPerClick(), this.getHungryDurationPerOperation(), this.getDecreaseFoodPerOperation());
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_PrimitiveMiner(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "PrimitiveMiner.png", this.getPowerPerClick(), this.getHungryDurationPerOperation(), this.getDecreaseFoodPerOperation());
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public byte getTileEntityBaseType() {
        return 0;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Muscle Machine"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[10]};
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    protected void pushToOutputSlots(ArrayList<ItemStack> drops) {
        GT_Utility.pushToOutputSlots(this.mInventory, drops, 5);
    }

    public void doWorkSound(IGregTechTileEntity aBaseMetaTileEntity) {
        this.doWorkSound(aBaseMetaTileEntity, true);
    }

    public void doWorkSound(IGregTechTileEntity aBaseMetaTileEntity, boolean isSuccess) {
        GT_Utility.sendSoundToPlayers(aBaseMetaTileEntity.getWorld(), GregTech_API.sSoundList.get(isSuccess ? 101 : 6), isSuccess ? 1.0f : 0.8f, -1.0f, aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
    }

    protected boolean decreaseInventoryItem(int idx) {
        return this.decreaseInventoryItem(idx, 1);
    }

    protected boolean decreaseInventoryItem(int idx, int count) {
        boolean success = false;
        if (idx > -1 && this.mInventory[idx] != null) {
            success = true;
            if (this.mInventory[idx].field_77994_a > count) {
                this.mInventory[idx].field_77994_a -= count;
            } else {
                this.mInventory[idx] = null;
            }
        }
        return success;
    }

    @Override
    public long maxEUStore() {
        return 0L;
    }

    @Override
    public long maxSteamStore() {
        return 64L;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex > 0 && aIndex != 4 + this.mInputSlotCount + this.mOutputItems.length;
    }
}

