/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_BasicDrillerBase;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class GT_MetaTileEntity_Pump
extends GT_MetaTileEntity_BasicDrillerBase {
    protected static int[] RADIUS = new int[]{8, 10, 20, 40, 80, 160, 48, 56, 64, 72, 80};
    protected static int[] SPEED = new int[]{80, 80, 40, 20, 10, 5, 5, 2, 2, 2, 2};
    protected static int[] ENERGY = new int[]{8, 4, 16, 64, 256, 1024, 2048, 32768, 131072, 524288};

    public GT_MetaTileEntity_Pump(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{"The best way to empty Oceans of lava!", "Pumping Area: " + (RADIUS[aTier] * 2 + 1) + "x" + (RADIUS[aTier] * 2 + 1), "Uses: " + ENERGY[aTier] + " EU per tick", "Pumps one fluid block each " + SPEED[aTier] + " ticks"}, 2, 2, "Pump.png", new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_ADV_PUMP), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_ADV_PUMP), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/miner/OVERLAY_FRONT")), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_ADV_PUMP), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_ADV_PUMP), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT));
    }

    public GT_MetaTileEntity_Pump(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures, 2, 1, "Miner.png");
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Pump(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return false;
    }

    @Override
    public boolean moveOneDown(IGregTechTileEntity aBaseMetaTileEntity) {
        block4: {
            if (aBaseMetaTileEntity.getYCoord() + this.drillY - 1 < 0 || !this.canPump(aBaseMetaTileEntity, 0, this.drillY - 1, 0) || !GT_Utility.setBlockByFakePlayer(this.getFakePlayer(aBaseMetaTileEntity), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord() + this.drillY - 1, aBaseMetaTileEntity.getZCoord(), MINING_PIPE_TIP_BLOCK, 0, true)) {
                this.isPickingPipes = true;
                return false;
            }
            if (aBaseMetaTileEntity.getBlockOffset(0, this.drillY, 0) == MINING_PIPE_TIP_BLOCK) {
                aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord() + this.drillY, aBaseMetaTileEntity.getZCoord(), MINING_PIPE_BLOCK);
            }
            for (int i = 0; i < this.mInputSlotCount; ++i) {
                ItemStack s = this.getInputAt(i);
                if (s == null || s.func_77973_b() != MINING_PIPE.func_77973_b() || s.field_77994_a <= 0) continue;
                --s.field_77994_a;
                if (s.field_77994_a == 0) {
                    this.mInventory[this.getInputSlot() + i] = null;
                }
                break block4;
            }
            this.waitMiningPipe = true;
            return false;
        }
        this.pumpBlock(aBaseMetaTileEntity, 0, this.drillY - 1, 0);
        aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord() + this.drillY - 1, aBaseMetaTileEntity.getZCoord(), MINING_PIPE_TIP_BLOCK);
        --this.drillY;
        this.drillZ = -RADIUS[this.mTier];
        this.drillX = -RADIUS[this.mTier];
        return true;
    }

    @Override
    public boolean hasFreeSpace() {
        return this.getFluid() == null || this.getFluid().amount <= this.getCapacity() - 1000;
    }

    @Override
    public int getRadius(int aTier) {
        return RADIUS[aTier];
    }

    @Override
    public int getSpeed(int aTier) {
        return SPEED[aTier];
    }

    @Override
    public int getEnergy(int aTier) {
        return ENERGY[aTier];
    }

    @Override
    public boolean workBlock(IGregTechTileEntity aBaseMetaTileEntity) {
        return this.pumpBlock(aBaseMetaTileEntity, this.drillX, this.drillY, this.drillZ);
    }

    public boolean canPump(IGregTechTileEntity aBaseTileEntity, int aX, int aY, int aZ) {
        if (aBaseTileEntity.getAirOffset(aX, aY, aZ)) {
            return true;
        }
        Block tBlock = aBaseTileEntity.getBlockOffset(aX, aY, aZ);
        return tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k || tBlock == Blocks.field_150358_i || tBlock instanceof IFluidBlock;
    }

    public boolean pumpBlock(IGregTechTileEntity aBaseTileEntity, int aX, int aY, int aZ) {
        if (aBaseTileEntity.getAirOffset(aX, aY, aZ)) {
            return false;
        }
        Block tBlock = aBaseTileEntity.getBlockOffset(aX, aY, aZ);
        byte aMeta = aBaseTileEntity.getMetaIDOffset(aX, aY, aZ);
        if (tBlock == Blocks.field_150355_j && aMeta == 0) {
            if (aBaseTileEntity.getWorld().func_147465_d(aBaseTileEntity.getXCoord() + aX, aBaseTileEntity.getYCoord() + aY, aBaseTileEntity.getZCoord() + aZ, Blocks.field_150350_a, 0, 2)) {
                if (this.mOutputFluid == null) {
                    this.mOutputFluid = GT_ModHandler.getWater(1000L);
                } else if (this.mOutputFluid.equals((Object)GT_ModHandler.getWater(1000L))) {
                    this.mOutputFluid.amount += 1000;
                }
                return true;
            }
        } else if (tBlock == Blocks.field_150353_l && aMeta == 0) {
            if (aBaseTileEntity.getWorld().func_147465_d(aBaseTileEntity.getXCoord() + aX, aBaseTileEntity.getYCoord() + aY, aBaseTileEntity.getZCoord() + aZ, Blocks.field_150350_a, 0, 2)) {
                if (this.mOutputFluid == null) {
                    this.mOutputFluid = GT_ModHandler.getLava(1000L);
                } else if (this.mOutputFluid.equals((Object)GT_ModHandler.getLava(1000L))) {
                    this.mOutputFluid.amount += 1000;
                }
                return true;
            }
        } else {
            if (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150355_j) {
                aBaseTileEntity.getWorld().func_147465_d(aBaseTileEntity.getXCoord() + aX, aBaseTileEntity.getYCoord() + aY, aBaseTileEntity.getZCoord() + aZ, Blocks.field_150350_a, 0, 2);
                return true;
            }
            if (tBlock instanceof IFluidBlock) {
                FluidStack fStack = ((IFluidBlock)tBlock).drain(aBaseTileEntity.getWorld(), aBaseTileEntity.getXCoord() + aX, aBaseTileEntity.getYCoord() + aY, aBaseTileEntity.getZCoord() + aZ, false);
                aBaseTileEntity.getWorld().func_147465_d(aBaseTileEntity.getXCoord() + aX, aBaseTileEntity.getYCoord() + aY, aBaseTileEntity.getZCoord() + aZ, Blocks.field_150350_a, 0, 2);
                if (fStack == null) {
                    return true;
                }
                if (this.mOutputFluid == null) {
                    this.mOutputFluid = fStack;
                } else if (fStack.equals((Object)this.mOutputFluid)) {
                    this.mOutputFluid.amount += fStack.amount;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getCapacity() {
        return 16000 * this.mTier;
    }
}

