/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_BasicMachine;
import gregtech.api.gui.GT_GUIContainer_BasicMachine;
import gregtech.api.gui.GT_Slot_ClosedInteraction;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_SeismicProspector
extends GT_MetaTileEntity_BasicMachine {
    public GT_MetaTileEntity_SeismicProspector(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "", 1, 0, "SeismicProspector.png", "", new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_SIDE_ROCK_BREAKER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_TOP_ROCK_BREAKER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER_ACTIVE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_BOTTOM_ROCK_BREAKER));
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Activate with explosives:", "8 Dynamite or Powderbarrel, 4 TNT, 2 Industrial TNT, 1 Glyceryl", "Use Data Stick for save data"};
    }

    public GT_MetaTileEntity_SeismicProspector(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 0, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_SeismicProspector(this.mName, this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BasicMachine(aPlayerInventory, aBaseMetaTileEntity){

            @Override
            public Slot provideSpecialSlot(IInventory iInventory, int id, int x, int y) {
                return new GT_Slot_ClosedInteraction(iInventory, id, x, y, p -> this.mProgressTime <= 0 && this.mMaxProgressTime <= 0);
            }
        };
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BasicMachine((GT_Container_BasicMachine)((Object)this.getServerGUI(0, aPlayerInventory, aBaseMetaTileEntity)), this.getLocalName(), this.mGUIName, this.mNEIName);
    }

    @Override
    public int checkRecipe() {
        ItemStack aStack = this.getInputAt(0);
        ItemStack tStack = this.getSpecialSlot();
        if (tStack != null && tStack.field_77994_a == 1 && tStack.func_77973_b().equals(ItemList.Paper_Punch_Card_Empty.getItem()) && aStack != null && ItemList.Small_Gunpowder_Bundle.getItem().equals(aStack.func_77973_b())) {
            --aStack.field_77994_a;
            if (aStack.field_77994_a == 0) {
                this.mInventory[this.getInputSlot()] = null;
            }
            this.mMaxProgresstime = 50;
            return 2;
        }
        if (aStack != null && (aStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W) && aStack.field_77994_a > 3 || aStack.func_77973_b() == ItemList.Block_Powderbarrel.getItem() && aStack.field_77994_a > 7 || aStack.func_77973_b() == Ic2Items.industrialTnt.func_77973_b() && aStack.field_77994_a > 1 || aStack.func_77973_b() == Ic2Items.dynamite.func_77973_b() && aStack.field_77994_a > 7 || GT_OreDictUnificator.getItemData(aStack) != null && GT_OreDictUnificator.getItemData((ItemStack)aStack).mMaterial.mMaterial == Materials.Glyceryl && aStack.field_77994_a > 0) && tStack != null && tStack.field_77994_a == 1 && (ItemList.Tool_DataStick.isStackEqual(tStack, false, true) || ItemList.Tool_CD.isStackEqual(tStack, false, false))) {
            aStack.field_77994_a = aStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W) ? (aStack.field_77994_a -= 4) : (aStack.func_77973_b() == ItemList.Block_Powderbarrel.getItem() ? (aStack.field_77994_a -= 8) : (aStack.func_77973_b() == Ic2Items.industrialTnt.func_77973_b() ? (aStack.field_77994_a -= 2) : (aStack.func_77973_b() == Ic2Items.dynamite.func_77973_b() ? (aStack.field_77994_a -= 8) : --aStack.field_77994_a)));
            if (aStack.field_77994_a == 0) {
                this.mInventory[this.getInputSlot()] = null;
            }
            this.mMaxProgresstime = 200;
            return 2;
        }
        return 0;
    }

    private void makePunchedCard(ItemStack aStack) {
        String stringCode = "";
        String enName = "";
        for (int i = this.getBaseMetaTileEntity().getYCoord(); i > 0 && stringCode.length() == 0; --i) {
            for (int f = -2; f < 3 && stringCode.length() == 0; ++f) {
                for (int g = -2; g < 3 && stringCode.length() == 0; ++g) {
                    Materials tMaterial;
                    short aMeta;
                    TileEntity tTileEntity;
                    Block tBlock = this.getBaseMetaTileEntity().getBlockOffset(f, -i, g);
                    if (!(tBlock instanceof GT_Block_Ores_Abstract) || !((tTileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(this.getBaseMetaTileEntity().getXCoord() + f, this.getBaseMetaTileEntity().getYCoord() + -i, this.getBaseMetaTileEntity().getZCoord() + g)) instanceof GT_TileEntity_Ores) || (aMeta = ((GT_TileEntity_Ores)tTileEntity).mMetaData) >= 16000 || (tMaterial = GregTech_API.sGeneratedMaterials[aMeta % 1000]) == null || tMaterial == Materials._NULL) continue;
                    stringCode = String.valueOf(tMaterial.mMetaItemSubID);
                    enName = tMaterial.mDefaultLocalName;
                }
            }
        }
        ItemStack pStack = ItemList.Paper_Punch_Card_Encoded.get(1L, new Object[0]);
        this.setSpecialSlot(pStack);
        NBTTagCompound tNBT = new NBTTagCompound();
        pStack.func_77955_b(tNBT);
        if (!stringCode.equals("")) {
            tNBT.func_74778_a("oreName", "gt.blockores." + stringCode + ".name");
            tNBT.func_74778_a("enOreName", enName);
        } else {
            tNBT.func_74757_a("oresNotFound", true);
        }
        pStack.func_77982_d(tNBT);
    }

    @Override
    public void endProcess() {
        ItemStack aStack = this.getSpecialSlot();
        if (aStack != null && aStack.field_77994_a == 1 && ItemList.Paper_Punch_Card_Empty.isStackEqual(aStack, false, true)) {
            this.makePunchedCard(aStack);
            return;
        }
        if (aStack == null || aStack.field_77994_a != 1 || !ItemList.Tool_DataStick.isStackEqual(aStack, false, true) && !ItemList.Tool_CD.isStackEqual(aStack, false, false)) {
            return;
        }
        GT_Utility.ItemNBT.setBookTitle(aStack, "Raw Prospection Data");
        ArrayList<String> tStringList = new ArrayList<String>();
        for (int i = this.getBaseMetaTileEntity().getYCoord(); i > 0; --i) {
            for (int f = -2; f < 3; ++f) {
                for (int g = -2; g < 3; ++g) {
                    Block tBlock = this.getBaseMetaTileEntity().getBlockOffset(f, -i, g);
                    if (tBlock instanceof GT_Block_Ores_Abstract) {
                        Materials tMaterial;
                        TileEntity tTileEntity = this.getBaseMetaTileEntity().getWorld().func_147438_o(this.getBaseMetaTileEntity().getXCoord() + f, this.getBaseMetaTileEntity().getYCoord() + -i, this.getBaseMetaTileEntity().getZCoord() + g);
                        if (!(tTileEntity instanceof GT_TileEntity_Ores) || ((GT_TileEntity_Ores)tTileEntity).mMetaData >= 16000 || (tMaterial = GregTech_API.sGeneratedMaterials[((GT_TileEntity_Ores)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL || tStringList.contains(tMaterial.mDefaultLocalName)) continue;
                        tStringList.add(tMaterial.mDefaultLocalName);
                        continue;
                    }
                    int tMetaID = this.getBaseMetaTileEntity().getWorld().func_72805_g(this.getBaseMetaTileEntity().getXCoord() + f, this.getBaseMetaTileEntity().getYCoord() + -i, this.getBaseMetaTileEntity().getZCoord() + g);
                    ItemData tAssotiation = GT_OreDictUnificator.getAssociation(new ItemStack(tBlock, 1, tMetaID));
                    if (tAssotiation == null || !tAssotiation.mPrefix.toString().startsWith("ore") || tStringList.contains(tAssotiation.mMaterial.mMaterial.mDefaultLocalName)) continue;
                    tStringList.add(tAssotiation.mMaterial.mMaterial.mDefaultLocalName);
                }
            }
        }
        if (tStringList.size() < 1) {
            tStringList.add("No Ores found.");
        }
        FluidStack tFluid = GT_UndergroundOil.undergroundOilReadInformation(this.getBaseMetaTileEntity());
        String[] tStringArray = new String[tStringList.size()];
        for (int i = 0; i < tStringArray.length; ++i) {
            tStringArray[i] = (String)tStringList.get(i);
        }
        GT_Utility.ItemNBT.setProspectionData(aStack, this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, tFluid, tStringArray);
        this.getBaseMetaTileEntity().disableWorking();
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public long maxEUStore() {
        return 0L;
    }
}

