/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.net.GT_Packet_ExtendedBlockEvent;
import gregtech.api.objects.GT_IconContainer;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_UndergroundOil;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Well
extends GT_MetaTileEntity_BasicTank {
    private static final ArrayList<Fluid> allowedFluids = new ArrayList();
    private FluidStack fluid = null;
    private int mProgresstime = 0;
    private static double mEfficiency = 1.0;

    public GT_MetaTileEntity_Well(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{"Allows the extraction of deep fluids", "Filling rate depends on the volume of the field", "Squeeze out a liquid in a bucket or a single cell"}, new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/well/OVERLAY_SIDE_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/well/OVERLAY_SIDE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/well/OVERLAY_FRONT_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/well/OVERLAY_FRONT")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/well/OVERLAY_TOP_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/well/OVERLAY_TOP")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/well/OVERLAY_BOTTOM_ACTIVE")), new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/well/OVERLAY_BOTTOM")));
    }

    public GT_MetaTileEntity_Well(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Well(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Well(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.fluid != null && this.fluid.amount >= 1000 || aBaseMetaTileEntity.isClientSide() || !aBaseMetaTileEntity.isAllowedToWork()) {
            return;
        }
        ++this.mProgresstime;
        if (this.mProgresstime >= 60) {
            this.mProgresstime = 0;
            FluidStack fs = GT_UndergroundOil.undergroundOil(this.getBaseMetaTileEntity(), 1.0f);
            if (fs == null) {
                this.mProgresstime = 0;
                return;
            }
            fs.amount = (int)((double)fs.amount * mEfficiency);
            if (this.isFluidAllowed(fs.getFluid())) {
                if (this.fluid == null) {
                    this.fluid = fs;
                } else {
                    this.fluid.amount += fs.amount;
                }
                if (this.fluid.amount >= 1000) {
                    aBaseMetaTileEntity.setActive(true);
                    this.fluid.amount = 1000;
                    GT_Values.NW.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new GT_Packet_ExtendedBlockEvent(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 129, this.fluid.getFluidID()), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
                }
            }
        }
    }

    protected boolean isFluidAllowed(Fluid aFluid) {
        for (Fluid tFluid : allowedFluids) {
            if (tFluid == null || aFluid != tFluid) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        String[] fs;
        super.onConfigLoad(aConfig);
        String s = aConfig.get((Object)ConfigCategories.machineconfig, "well.allowedFluids", "water|oil");
        mEfficiency = aConfig.get((Object)ConfigCategories.machineconfig, "well.efficiency", 1.0);
        for (String str : fs = s.split("\\|")) {
            allowedFluids.add(FluidRegistry.getFluid((String)str));
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == 1 && aActive) {
            if (this.fluid == null) {
                return this.mTextures[5][aColorIndex + 1];
            }
            ITexture[] ar = new ITexture[2];
            ar[1] = this.mTextures[4][aColorIndex + 1][1];
            ar[0] = new GT_RenderedTexture(new GT_IconContainer(this.fluid.getFluid().getStillIcon(), null, null));
            return ar;
        }
        return this.mTextures[aSide == 0 ? 7 : (aSide == 1 ? 5 : (aSide > 1 && aSide < 6 ? 3 : 4))][aColorIndex + 1];
    }

    @Override
    public void receiveExtendedBlockEvent(int aID, int aValue) {
        if (aID == 129) {
            this.fluid = new FluidStack(FluidRegistry.getFluid((int)aValue), 10);
        } else if (aID == 130) {
            this.fluid = null;
        }
        this.getBaseMetaTileEntity().rebakeMap();
    }

    @Override
    public void sendClientData() {
        if (this.fluid == null) {
            GT_Values.NW.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new GT_Packet_ExtendedBlockEvent(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 130, 0), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
        } else {
            GT_Values.NW.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new GT_Packet_ExtendedBlockEvent(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 129, this.fluid.getFluidID()), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
        }
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[14][17][];
        aTextures = Arrays.copyOf(aTextures, 14);
        for (int i = 0; i < aTextures.length; ++i) {
            if (aTextures[i] == null) continue;
            for (int c = -1; c < 16; c = (int)((byte)(c + 1))) {
                if (rTextures[i][c + 1] != null) continue;
                rTextures[i][c + 1] = i == 4 ? new ITexture[]{new GT_RenderedTexture(new Textures.BlockIcons.CustomIcon("basicmachines/well/DEFAULT_FLUID")), aTextures[i]} : new ITexture[]{aTextures[i]};
            }
        }
        return rTextures;
    }

    @Override
    public boolean onWrenchRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (this.getBaseMetaTileEntity().isClientSide()) {
            return true;
        }
        if (this.fluid == null) {
            GT_Utility.sendChatToPlayer(aPlayer, "Currently is empty");
        } else if (this.fluid.amount < 1000) {
            GT_Utility.sendChatToPlayer(aPlayer, "Currently is " + this.fluid.amount / 10 + "% ready");
        }
        if (this.fluid == null || this.fluid.amount < 1000) {
            return false;
        }
        ItemStack tStack = aPlayer.func_70694_bm();
        ItemStack aStack = GT_Utility.fillFluidContainer(this.fluid, tStack, false, true);
        if (aPlayer.func_70694_bm() != null && aPlayer.func_70694_bm().field_77994_a == 1 && aStack != null) {
            aPlayer.func_70062_b(0, aStack);
            this.fluid = null;
            this.getBaseMetaTileEntity().setActive(false);
            GT_Values.NW.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new GT_Packet_ExtendedBlockEvent(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 130, 0), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
            return true;
        }
        GT_Utility.sendChatToPlayer(aPlayer, "Currently is ready");
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (this.fluid != null) {
            aNBT.func_74782_a("fFluid", (NBTBase)this.fluid.writeToNBT(new NBTTagCompound()));
        }
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("fFluid"));
        this.getBaseMetaTileEntity().rebakeMap();
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    @Override
    public boolean displaysItemStack() {
        return false;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }
}

