/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class GT_MetaTileEntity_AdvancedProcessingArray
extends GT_MetaTileEntity_MultiBlockBase {
    GT_Recipe mLastRecipe;
    boolean separateBusesMode = false;
    boolean processFluidCells = false;
    public String mMachine = "";

    public GT_MetaTileEntity_AdvancedProcessingArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_AdvancedProcessingArray(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AdvancedProcessingArray(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Advanced Processing Array", "Is an improved version of basic processing Array", "Runs supplied machines as if placed in the world", "Size(WxHxD): 5x5x5 (Hollow), Controller (Front  Second Layer centered)", "1x Input Hatch/Bus (Any casing)", "1x Output Hatch/Bus (Any casing)", "1x Maintenance Hatch (Any casing)", "1x Energy Hatch (Any casing)", "Robust HSS-G Machine Casings for the rest (70 at least!)", "Place up to 64 Single Block GT Machines into the Controller Inventory", "Screwdriver rightclick to process all buses separately", "Screwdriver rightclick while sneaking enables fluid autocanning", "Right click with wire cutter to toggle recipe conflicts resolving"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][50], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][50]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.trans("gt.blockmachines." + this.mName + ".guiname", "Advanced P. A."), "AdvancedProcessingArray.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (this.mInventory[1] == null) {
            return null;
        }
        String tmp = this.mInventory[1].func_77977_a().replaceAll("gt\\.blockmachines\\.basicmachine\\.", "");
        if (tmp.startsWith("centrifuge")) {
            return GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes;
        }
        if (tmp.startsWith("electrolyzer")) {
            return GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes;
        }
        if (tmp.startsWith("alloysmelter")) {
            return GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes;
        }
        if (tmp.startsWith("assembler")) {
            return GT_Recipe.GT_Recipe_Map.sAssemblerRecipes;
        }
        if (tmp.startsWith("compressor")) {
            return GT_Recipe.GT_Recipe_Map.sCompressorRecipes;
        }
        if (tmp.startsWith("extractor")) {
            return GT_Recipe.GT_Recipe_Map.sExtractorRecipes;
        }
        if (tmp.startsWith("macerator")) {
            return GT_Recipe.GT_Recipe_Map.sMaceratorRecipes;
        }
        if (tmp.startsWith("recycler")) {
            return GT_Recipe.GT_Recipe_Map.sRecyclerRecipes;
        }
        if (tmp.startsWith("thermalcentrifuge")) {
            return GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes;
        }
        if (tmp.startsWith("orewasher")) {
            return GT_Recipe.GT_Recipe_Map.sOreWasherRecipes;
        }
        if (tmp.startsWith("chemicalreactor")) {
            return GT_Recipe.GT_Recipe_Map.sChemicalRecipes;
        }
        if (tmp.startsWith("chemicalbath")) {
            return GT_Recipe.GT_Recipe_Map.sChemicalBathRecipes;
        }
        if (tmp.startsWith("electromagneticseparator")) {
            return GT_Recipe.GT_Recipe_Map.sElectroMagneticSeparatorRecipes;
        }
        if (tmp.startsWith("autoclave")) {
            return GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes;
        }
        if (tmp.startsWith("mixer")) {
            return GT_Recipe.GT_Recipe_Map.sMixerRecipes;
        }
        if (tmp.startsWith("hammer")) {
            return GT_Recipe.GT_Recipe_Map.sHammerRecipes;
        }
        if (tmp.startsWith("sifter")) {
            return GT_Recipe.GT_Recipe_Map.sSifterRecipes;
        }
        if (tmp.startsWith("extruder")) {
            return GT_Recipe.GT_Recipe_Map.sExtruderRecipes;
        }
        if (tmp.startsWith("laserengraver")) {
            return GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes;
        }
        if (tmp.startsWith("bender")) {
            return GT_Recipe.GT_Recipe_Map.sBenderRecipes;
        }
        if (tmp.startsWith("wiremill")) {
            return GT_Recipe.GT_Recipe_Map.sWiremillRecipes;
        }
        if (tmp.startsWith("arcfurnace")) {
            return GT_Recipe.GT_Recipe_Map.sArcFurnaceRecipes;
        }
        if (tmp.startsWith("brewery")) {
            return GT_Recipe.GT_Recipe_Map.sBrewingRecipes;
        }
        if (tmp.startsWith("canner")) {
            return GT_Recipe.GT_Recipe_Map.sCannerRecipes;
        }
        if (tmp.startsWith("cutter")) {
            return GT_Recipe.GT_Recipe_Map.sCutterRecipes;
        }
        if (tmp.startsWith("fermenter")) {
            return GT_Recipe.GT_Recipe_Map.sFermentingRecipes;
        }
        if (tmp.startsWith("fluidextractor")) {
            return GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes;
        }
        if (tmp.startsWith("fluidsolidifier")) {
            return GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes;
        }
        if (tmp.startsWith("lathe")) {
            return GT_Recipe.GT_Recipe_Map.sLatheRecipes;
        }
        if (tmp.startsWith("boxinator")) {
            return GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes;
        }
        if (tmp.startsWith("unboxinator")) {
            return GT_Recipe.GT_Recipe_Map.sUnboxinatorRecipes;
        }
        if (tmp.startsWith("polarizer")) {
            return GT_Recipe.GT_Recipe_Map.sPolarizerRecipes;
        }
        if (tmp.startsWith("press")) {
            return GT_Recipe.GT_Recipe_Map.sPressRecipes;
        }
        if (tmp.startsWith("plasmaarcfurnace")) {
            return GT_Recipe.GT_Recipe_Map.sPlasmaArcFurnaceRecipes;
        }
        if (tmp.startsWith("printer")) {
            return GT_Recipe.GT_Recipe_Map.sPrinterRecipes;
        }
        if (tmp.startsWith("press")) {
            return GT_Recipe.GT_Recipe_Map.sPressRecipes;
        }
        if (tmp.startsWith("fluidcanner")) {
            return GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes;
        }
        if (tmp.startsWith("fluidheater")) {
            return GT_Recipe.GT_Recipe_Map.sFluidHeaterRecipes;
        }
        if (tmp.startsWith("distillery")) {
            return GT_Recipe.GT_Recipe_Map.sDistilleryRecipes;
        }
        if (tmp.startsWith("slicer")) {
            return GT_Recipe.GT_Recipe_Map.sSlicerRecipes;
        }
        if (tmp.startsWith("amplifab")) {
            return GT_Recipe.GT_Recipe_Map.sAmplifiers;
        }
        if (tmp.startsWith("circuitassembler")) {
            return GT_Recipe.GT_Recipe_Map.sCircuitAssemblerRecipes;
        }
        if (tmp.startsWith("filter")) {
            return GT_Recipe.GT_Recipe_Map.sFilterRecipes;
        }
        if (tmp.startsWith("rockbreaker")) {
            return GT_Recipe.GT_Recipe_Map.sRockBreakerRecipes;
        }
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return aStack != null && aStack.func_77977_a().startsWith("gt.blockmachines.basicmachine.");
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (!this.isCorrectMachinePart(this.mInventory[1])) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map map = this.getRecipeMap();
        if (map == null) {
            return false;
        }
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        int tTier = 0;
        if (this.mInventory[1].func_77977_a().endsWith("1")) {
            tTier = 1;
        } else if (this.mInventory[1].func_77977_a().endsWith("2")) {
            tTier = 2;
        } else if (this.mInventory[1].func_77977_a().endsWith("3")) {
            tTier = 3;
        } else if (this.mInventory[1].func_77977_a().endsWith("4")) {
            tTier = 4;
        } else if (this.mInventory[1].func_77977_a().endsWith("5")) {
            tTier = 5;
        } else if (this.mInventory[1].func_77977_a().endsWith("6")) {
            tTier = 6;
        } else if (this.mInventory[1].func_77977_a().endsWith("7")) {
            tTier = 7;
        } else if (this.mInventory[1].func_77977_a().endsWith("8")) {
            tTier = 8;
        }
        if (this.processFluidCells && !map.mUnlocalizedName.equals("gt.recipe.centrifuge") && !map.mUnlocalizedName.equals("gt.recipe.electrolyzer") && !map.mUnlocalizedName.equals("gt.recipe.mixer")) {
            return false;
        }
        if (!this.mMachine.equals(this.mInventory[1].func_77977_a())) {
            this.mLastRecipe = null;
        }
        this.mMachine = this.mInventory[1].func_77977_a();
        ItemStack[] tInputs = tInputList.toArray(new ItemStack[tInputList.size()]);
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[tFluidList.size()]);
        if (tInputList.size() > 0 || tFluids.length > 0) {
            GT_Recipe tRecipe = null;
            this.mEUt = 0;
            this.mOutputItems = null;
            this.mOutputFluids = null;
            int machines = Math.min(64, this.mInventory[1].field_77994_a);
            int i = 0;
            if (this.separateBusesMode) {
                boolean tSucceed = false;
                block0: for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
                    i = 0;
                    tInputs = tBus.mInventory;
                    tInputList = new ArrayList<ItemStack>(Arrays.asList(tInputs));
                    tRecipe = this.findRecipe(map, this.mLastRecipe, tInputs, tFluids, GT_Values.V[tTier]);
                    if (tRecipe == null && this.processFluidCells) {
                        for (FluidStack tFluid : tFluids) {
                            if (tFluid.amount % 1000 != 0) continue;
                            tInputList.add(GT_Utility.fillFluidContainer(tFluid, GT_ModHandler.getIC2Item("cell", tFluid.amount / 1000), false, true));
                        }
                        int s = tInputList.size();
                        for (int q = 0; q < s; ++q) {
                            tInputList.add(GT_ModHandler.getIC2Item("cell", 64L));
                        }
                        tInputs = tInputList.toArray(new ItemStack[tInputList.size()]);
                        tRecipe = this.findRecipe(map, this.mLastRecipe, tInputs, tFluids, GT_Values.V[tTier]);
                        if (tRecipe == null || tRecipe.mOutputs.length > 0 && GT_Utility.areStacksEqual(tRecipe.mOutputs[0], GT_ModHandler.getIC2Item("electrolyzedWaterCell", 1L), true)) continue;
                    }
                    if (tRecipe == null || GT_Mod.gregtechproxy.mLowGravProcessing && tRecipe.mSpecialValue == -100 && !GT_MetaTileEntity_BasicMachine.isValidForLowGravity(tRecipe, this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) continue;
                    while (i < machines) {
                        if (this.processFluidCells ? !GT_MetaTileEntity_AdvancedProcessingArray.isRecipeInputEqualFluids(tRecipe, tInputs, tFluids, true) : !tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                            if (i == 0) continue block0;
                            tSucceed = true;
                            break block0;
                        }
                        ++i;
                    }
                    tSucceed = true;
                    break;
                }
                if (!tSucceed) {
                    return false;
                }
            } else {
                tRecipe = this.findRecipe(map, this.mLastRecipe, tInputs, tFluids, GT_Values.V[tTier]);
                if (tRecipe == null && this.processFluidCells) {
                    for (FluidStack tFluid : tFluids) {
                        if (tFluid.amount % 1000 != 0) continue;
                        tInputList.add(GT_Utility.fillFluidContainer(tFluid, GT_ModHandler.getIC2Item("cell", tFluid.amount / 1000), false, true));
                    }
                    int s = tInputList.size();
                    for (int q = 0; q < s; ++q) {
                        tInputList.add(GT_ModHandler.getIC2Item("cell", 64L));
                    }
                    tInputs = tInputList.toArray(new ItemStack[tInputList.size()]);
                    tRecipe = this.findRecipe(map, this.mLastRecipe, tInputs, tFluids, GT_Values.V[tTier]);
                    if (tRecipe == null || tRecipe.mOutputs.length > 0 && GT_Utility.areStacksEqual(tRecipe.mOutputs[0], GT_ModHandler.getIC2Item("electrolyzedWaterCell", 1L), true)) {
                        return false;
                    }
                }
                if (tRecipe == null) {
                    return false;
                }
                if (GT_Mod.gregtechproxy.mLowGravProcessing && tRecipe.mSpecialValue == -100 && !GT_MetaTileEntity_BasicMachine.isValidForLowGravity(tRecipe, this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
                    return false;
                }
                for (i = 0; i < machines; ++i) {
                    if (!(this.processFluidCells ? !GT_MetaTileEntity_AdvancedProcessingArray.isRecipeInputEqualFluids(tRecipe, tInputs, tFluids, true) : !tRecipe.isRecipeInputEqual(true, tFluids, tInputs))) continue;
                    if (i != 0) break;
                    return false;
                }
            }
            if (tRecipe == null) {
                return false;
            }
            this.mLastRecipe = tRecipe;
            this.mMaxProgresstime = tRecipe.mDuration;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            if (tRecipe.mEUt <= 16) {
                this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
            } else {
                this.mEUt = tRecipe.mEUt;
                this.mMaxProgresstime = tRecipe.mDuration;
                while ((long)this.mEUt <= GT_Values.V[tTier - 1] * (long)map.mAmperage) {
                    this.mEUt *= 4;
                    this.mMaxProgresstime /= 2;
                }
            }
            this.mEUt *= i;
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            Object[] tOut = new ItemStack[tRecipe.mOutputs.length];
            for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
                if (tRecipe.getOutput(h) == null) continue;
                tOut[h] = tRecipe.getOutput(h).func_77946_l();
                tOut[h].field_77994_a = 0;
            }
            FluidStack tFOut = null;
            if (tRecipe.getFluidOutput(0) != null) {
                tFOut = tRecipe.getFluidOutput(0).copy();
            }
            for (int f = 0; f < tOut.length; ++f) {
                if (tRecipe.mOutputs[f] == null || tOut[f] == null) continue;
                for (int g = 0; g < i; ++g) {
                    if (this.getBaseMetaTileEntity().getRandomNumber(10000) >= tRecipe.getOutputChance(f)) continue;
                    tOut[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
                }
            }
            if (tFOut != null) {
                int tSize = tFOut.amount;
                tFOut.amount = tSize * i;
            }
            tOut = GT_MetaTileEntity_AdvancedProcessingArray.clean((ItemStack[])tOut);
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            ArrayList<ItemStack> overStacks = new ArrayList<ItemStack>();
            for (int f = 0; f < tOut.length; ++f) {
                while (tOut[f].func_77976_d() < tOut[f].field_77994_a) {
                    if (tOut[f] == null) continue;
                    ItemStack tmp = tOut[f].func_77946_l();
                    tmp.field_77994_a = tmp.func_77976_d();
                    ((ItemStack)tOut[f]).field_77994_a -= tOut[f].func_77976_d();
                    overStacks.add(tmp);
                }
            }
            if (overStacks.size() > 0) {
                Object[] tmp = new ItemStack[overStacks.size()];
                tmp = overStacks.toArray(tmp);
                tOut = (ItemStack[])ArrayUtils.addAll((Object[])tOut, (Object[])tmp);
            }
            ArrayList<Object> tSList = new ArrayList<Object>();
            ArrayList<FluidStack> tFOuts = new ArrayList<FluidStack>();
            tFOuts.add(tFOut);
            for (Object tS : tOut) {
                if (this.processFluidCells) {
                    FluidStack tFluid = GT_Utility.getFluidForFilledItem((ItemStack)tS, true);
                    if (tFluid != null) {
                        tFluid.amount = 1000 * ((ItemStack)tS).field_77994_a;
                        tFOuts.add(tFluid);
                        continue;
                    }
                    if (GT_Utility.areStacksEqual((ItemStack)tS, GT_ModHandler.getIC2Item("cell", 1L), true)) continue;
                }
                if (((ItemStack)tS).field_77994_a <= 0) continue;
                tSList.add(tS);
            }
            tOut = tSList.toArray(new ItemStack[tSList.size()]);
            this.mOutputItems = tOut;
            this.mOutputFluids = tFOuts.toArray(new FluidStack[tFOuts.size()]);
            if (tRecipe.mSpecialValue == -200) {
                for (int k = 0; k < this.mOutputItems.length; ++k) {
                    if (this.mOutputItems[k] == null || this.getBaseMetaTileEntity().getRandomNumber(10000) <= this.mCleanroom.mEfficiency) continue;
                    this.mOutputItems[k] = null;
                }
            }
            this.updateSlots();
            return true;
        }
        return false;
    }

    @Override
    protected GT_Recipe findRecipe(GT_Recipe.GT_Recipe_Map map, GT_Recipe aLastRecipe, ItemStack[] aInputs, FluidStack[] aFluids, long aVoltage) {
        GT_Recipe recipe = super.findRecipe(map, aLastRecipe, aInputs, aFluids, aVoltage);
        if (recipe == null) {
            return recipe;
        }
        if (recipe.mSpecialValue == -200 && (this.mCleanroom == null || this.mCleanroom.mEfficiency == 0)) {
            return null;
        }
        return recipe;
    }

    public static ItemStack[] clean(ItemStack[] v) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(Arrays.asList(v));
        list.removeAll(Collections.singleton(null));
        return list.toArray(new ItemStack[list.size()]);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 2;
        int tAmount = 0;
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int h = -1; h < 4; ++h) {
                    IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, h, zDir + j);
                    if (i != 2 && i != -2 && j != 2 && j != -2) {
                        if (h == -1 || h == 3) {
                            if (this.addMaintenanceToMachineList(tTileEntity, 178) || this.addInputToMachineList(tTileEntity, 178) || this.addOutputToMachineList(tTileEntity, 178) || this.addEnergyInputToMachineList(tTileEntity, 178)) continue;
                            if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != GregTech_API.sBlockCasings8) {
                                return false;
                            }
                            if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j) != 2) {
                                return false;
                            }
                            ++tAmount;
                            continue;
                        }
                        if (aBaseMetaTileEntity.getAirOffset(xDir + i, h, zDir + j)) continue;
                        return false;
                    }
                    if (i + xDir == 0 && j + zDir == 0 && h == 0 || this.addMaintenanceToMachineList(tTileEntity, 178) || this.addInputToMachineList(tTileEntity, 178) || this.addOutputToMachineList(tTileEntity, 178) || this.addEnergyInputToMachineList(tTileEntity, 178)) continue;
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != GregTech_API.sBlockCasings8) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j) != 2) {
                        return false;
                    }
                    ++tAmount;
                }
            }
        }
        return tAmount >= 70;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        if (aPlayer.func_70093_af()) {
            boolean bl = this.processFluidCells = !this.processFluidCells;
            if (this.processFluidCells) {
                GT_Utility.sendChatToPlayer(aPlayer, "Fluid Autocanning Enabled");
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, "Fluid Autocanning Disabled");
            }
        } else {
            boolean bl = this.separateBusesMode = !this.separateBusesMode;
            if (this.separateBusesMode) {
                GT_Utility.sendChatToPlayer(aPlayer, "Processing all buses separately");
            } else {
                GT_Utility.sendChatToPlayer(aPlayer, "Processing all buses together");
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("processingMode", this.separateBusesMode);
        aNBT.func_74757_a("autocanning", this.processFluidCells);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.separateBusesMode = aNBT.func_74767_n("processingMode");
        this.processFluidCells = aNBT.func_74767_n("autocanning");
    }

    public static boolean isRecipeInputEqualFluids(GT_Recipe aRecipe, ItemStack[] aInputs, FluidStack[] aFluidInputs, boolean aDecreaseStacksizeBySuccess) {
        int amt;
        if (aFluidInputs.length > 0 && aInputs == null) {
            return false;
        }
        ArrayList<ItemStack> mInputs = new ArrayList<ItemStack>(Arrays.asList(aRecipe.mInputs));
        Iterator<ItemStack> iterator = mInputs.iterator();
        while (iterator.hasNext()) {
            ItemStack is = iterator.next();
            if (!GT_Utility.areStacksEqual(GT_ModHandler.getIC2Item("cell", 1L), is, true)) continue;
            iterator.remove();
        }
        ArrayList<FluidStack> mFluids = new ArrayList<FluidStack>(Arrays.asList(aRecipe.mFluidInputs));
        Iterator<ItemStack> itr = mInputs.iterator();
        while (itr.hasNext()) {
            ItemStack is = itr.next();
            FluidStack tFluid = GT_Utility.getFluidForFilledItem(is, true);
            if (tFluid == null) continue;
            tFluid.amount = 1000 * is.field_77994_a;
            mFluids.add(tFluid);
            itr.remove();
        }
        FluidStack[] mFluidInputs = mFluids.toArray(new FluidStack[mFluids.size()]);
        for (FluidStack fluidStack : mFluidInputs) {
            if (fluidStack == null) continue;
            boolean temp = true;
            amt = fluidStack.amount;
            for (FluidStack aFluid : aFluidInputs) {
                if (aFluid == null || !aFluid.isFluidEqual(fluidStack) || (amt -= aFluid.amount) >= 1) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (mInputs.size() > 0 && aInputs == null) {
            return false;
        }
        for (ItemStack tStack : mInputs) {
            if (tStack == null) continue;
            amt = tStack.field_77994_a;
            boolean temp = true;
            for (ItemStack aStack : aInputs) {
                if (!GT_Utility.areUnificationsEqual(aStack, tStack, true) && !GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, aStack), tStack, true) || (amt -= aStack.field_77994_a) >= 1) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            if (aFluidInputs != null) {
                block6: for (FluidStack fluidStack : mFluidInputs) {
                    if (fluidStack == null) continue;
                    amt = fluidStack.amount;
                    for (FluidStack aFluid : aFluidInputs) {
                        if (aFluid == null || !aFluid.isFluidEqual(fluidStack)) continue;
                        if (aFluid.amount < amt) {
                            amt -= aFluid.amount;
                            aFluid.amount = 0;
                            continue;
                        }
                        aFluid.amount -= amt;
                        amt = 0;
                        continue block6;
                    }
                }
            }
            if (aInputs != null) {
                block8: for (ItemStack tStack : mInputs) {
                    if (tStack == null) continue;
                    amt = tStack.field_77994_a;
                    for (ItemStack aStack : aInputs) {
                        if (!GT_Utility.areUnificationsEqual(aStack, tStack, true) && !GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, aStack), tStack, true)) continue;
                        if (aStack.field_77994_a < amt) {
                            amt -= aStack.field_77994_a;
                            aStack.field_77994_a = 0;
                            continue;
                        }
                        aStack.field_77994_a -= amt;
                        amt = 0;
                        continue block8;
                    }
                }
            }
        }
        return true;
    }

    @Override
    protected boolean canHaveRecipeConflicts() {
        return true;
    }
}

