/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.RelativeOffset;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_DataAccess;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_MetaBlock;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Casings2;
import gregtech.common.blocks.GT_Block_Casings3;
import ic2.core.block.BlockTexGlass;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_AssemblyLine
extends GT_MetaTileEntity_MultiBlockBase {
    private static final int TEXTURE_INDEX = 16;
    private static final int GRATE_META_ID = 10;
    private static final int STEEL_CASING_META_ID = 0;
    private static final int ASSEMBLER_CASING_META_ID = 9;
    private static final int LINE_CASING_META_ID = 5;
    private int checkRow;
    public ArrayList<GT_MetaTileEntity_Hatch_DataAccess> mDataAccessHatches = new ArrayList();

    public GT_MetaTileEntity_AssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_AssemblyLine(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AssemblyLine(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Assembly Line", "Size(WxHxD): (5-16)x4x3, various width", "Bottom: Solid Steel Machine Casing (or Maintenance, Input Hatches,", "Input Buses from left to right,  1x Output Bus any place)", "Middle: Reinforced Glass, Assembling Line Casing, Reinforced Glass", "UpMiddle:  Grate Machine Casing, Assembler Machine Casing,", "           Grate Machine Casing         ", "           (or Controller or optional Data Access Hatch)", "Top: Solid Steel Machine Casing, 1-2x Energy Hatch", "Up to 16 repeating slices, last is Output Bus"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[16], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[16]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "AssemblyLine.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        int i;
        ArrayList<ItemStack> tDataStickList;
        if (GT_Values.D1) {
            System.out.println("Start ALine recipe check");
        }
        if ((tDataStickList = this.getDataItems(2)).isEmpty()) {
            return false;
        }
        if (GT_Values.D1) {
            System.out.println("Stick accepted, " + tDataStickList.size() + " Data Sticks found");
        }
        ItemStack[] tStack = new ItemStack[15];
        FluidStack[] tFluids = new FluidStack[4];
        boolean findRecipe = false;
        block0: for (ItemStack tDataStick : tDataStickList) {
            int i2;
            NBTTagCompound tTag = tDataStick.func_77978_p();
            if (tTag == null) continue;
            for (i2 = 0; i2 < 15; ++i2) {
                int count = tTag.func_74762_e("a" + i2);
                if (!tTag.func_74764_b("" + i2) && count <= 0) continue;
                if (this.mInputBusses.get(i2) == null) continue block0;
                ItemStack stackInSlot = ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(i2)).getBaseMetaTileEntity().func_70301_a(0);
                boolean flag = true;
                if (count > 0) {
                    for (int j = 0; j < count; ++j) {
                        tStack[i2] = GT_Utility.loadItem(tTag, "a" + i2 + ":" + j);
                        if (tStack[i2] == null) continue;
                        if (GT_Values.D1) {
                            System.out.println("Item " + i2 + " : " + tStack[i2].func_77977_a());
                        }
                        if (!GT_Utility.areStacksEqual(tStack[i2], stackInSlot, true) || tStack[i2].field_77994_a > stackInSlot.field_77994_a) continue;
                        flag = false;
                        break;
                    }
                }
                if (flag) {
                    tStack[i2] = GT_Utility.loadItem(tTag, "" + i2);
                    if (tStack[i2] == null) {
                        flag = false;
                        continue;
                    }
                    if (GT_Values.D1) {
                        System.out.println("Item " + i2 + " : " + tStack[i2].func_77977_a());
                    }
                    if (GT_Utility.areStacksEqual(tStack[i2], stackInSlot, true) && tStack[i2].field_77994_a <= stackInSlot.field_77994_a) {
                        flag = false;
                    }
                }
                if (GT_Values.D1) {
                    System.out.println(i2 + (flag ? " not accepted" : " accepted"));
                }
                if (flag) continue block0;
            }
            if (GT_Values.D1) {
                System.out.println("All Items done, start fluid check");
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (!tTag.func_74764_b("f" + i2)) continue;
                tFluids[i2] = GT_Utility.loadFluid(tTag, "f" + i2);
                if (tFluids[i2] == null) continue;
                if (GT_Values.D1) {
                    System.out.println("Fluid " + i2 + " " + tFluids[i2].getUnlocalizedName());
                }
                if (this.mInputHatches.get(i2) == null) continue block0;
                FluidStack fluidInHatch = ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i2)).mFluid;
                if (fluidInHatch == null || !GT_Utility.areFluidsEqual(fluidInHatch, tFluids[i2], true) || fluidInHatch.amount < tFluids[i2].amount) {
                    if (!GT_Values.D1) continue block0;
                    System.out.println(i2 + " not accepted");
                    continue block0;
                }
                if (!GT_Values.D1) continue;
                System.out.println(i2 + " accepted");
            }
            if (GT_Values.D1) {
                System.out.println("Input accepted, check other values");
            }
            if (!tTag.func_74764_b("output")) continue;
            this.mOutputItems = new ItemStack[]{GT_Utility.loadItem(tTag, "output")};
            if (this.mOutputItems[0] == null || !GT_Utility.isStackValid(this.mOutputItems[0]) || !tTag.func_74764_b("time")) continue;
            this.mMaxProgresstime = tTag.func_74762_e("time");
            if (this.mMaxProgresstime <= 0 || !tTag.func_74764_b("eu")) continue;
            this.mEUt = tTag.func_74762_e("eu");
            if (GT_Values.D1) {
                System.out.println("Find avaiable recipe");
            }
            findRecipe = true;
            break;
        }
        if (!findRecipe) {
            return false;
        }
        if (GT_Values.D1) {
            System.out.println("All checked start consuming inputs");
        }
        for (i = 0; i < 15; ++i) {
            if (tStack[i] == null) continue;
            ItemStack stackInSlot = ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(i)).getBaseMetaTileEntity().func_70301_a(0);
            stackInSlot.field_77994_a -= tStack[i].field_77994_a;
        }
        for (i = 0; i < 4; ++i) {
            if (tFluids[i] == null) continue;
            ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid.amount -= tFluids[i].amount;
            if (((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid.amount > 0) continue;
            ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid = null;
        }
        if (GT_Values.D1) {
            System.out.println("Check overclock");
        }
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(this.getMaxInputVoltage()));
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        this.updateSlots();
        if (GT_Values.D1) {
            System.out.println("Recipe sucessfull");
        }
        return true;
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(212), 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity cBase, ItemStack aStack) {
        int maxrowlength = 16;
        this.checkRow = 0;
        for (int i = 1; i < maxrowlength && this.validateControllerLayerBlocks(GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.LEFT, i, 0, 0)); ++i) {
        }
        int topLeftOffset = this.checkRow;
        for (int i = 1; i < maxrowlength - topLeftOffset && this.validateControllerLayerBlocks(GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 0, 0)); ++i) {
        }
        int fixedLength = this.checkRow + 1;
        if (fixedLength < 5) {
            return false;
        }
        for (int i = 0 - topLeftOffset; i < 0 - topLeftOffset + fixedLength; ++i) {
            GT_MetaBlock mb = GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 1, 0);
            if (!this.validateCasing2Block(mb, 9)) {
                return false;
            }
            if (!this.validateControllerLayerBlocks(GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 2, 0))) {
                return false;
            }
            mb = GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 1, 1);
            if (!this.validateCasing2Block(mb, 0) && !this.addEnergyInputToMachineList(mb.getTile(), 16)) {
                return false;
            }
            if (!(GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 0, -1).getBlock() instanceof BlockTexGlass) || !(GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 2, -1).getBlock() instanceof BlockTexGlass)) {
                return false;
            }
            if (!this.validateCasing2Block(GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 1, -1), 5)) {
                return false;
            }
            if (this.validateBottomBlock(GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 0, -2)) && this.validateBottomBlock(GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 1, -2)) && this.validateBottomBlock(GT_Utility.getFrontRelativeOffsetBackBlock(cBase, RelativeOffset.RIGHT, i, 2, -2))) continue;
            return false;
        }
        return !this.mEnergyHatches.isEmpty() && this.mOutputBusses.size() == 1 && !this.mMaintenanceHatches.isEmpty();
    }

    private boolean validateBottomBlock(GT_MetaBlock mb) {
        return this.validateCasing2Block(mb, 0) || this.addInputToMachineList(mb.getTile(), 16) || this.addMaintenanceToMachineList(mb.getTile(), 16) || this.addOutputToMachineList(mb.getTile(), 16);
    }

    private boolean validateCasing2Block(GT_MetaBlock mb, int metaData) {
        return mb.getBlock() instanceof GT_Block_Casings2 && mb.getMetaId() == metaData;
    }

    private boolean validateControllerLayerBlocks(GT_MetaBlock block) {
        if (block.getBlock() instanceof GT_Block_Casings3 && block.getMetaId() == 10) {
            ++this.checkRow;
            return true;
        }
        if (block.getTile() instanceof BaseMetaTileEntity && this.addDataAccessToMachineList(block.getTile(), 16)) {
            ++this.checkRow;
            return true;
        }
        return false;
    }

    private boolean isCorrectDataItem(ItemStack aStack, int state) {
        if ((state & 1) != 0 && ItemList.Circuit_Integrated.isStackEqual(aStack, true, true)) {
            return true;
        }
        if ((state & 2) != 0 && ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
            return true;
        }
        return (state & 4) != 0 && ItemList.Tool_DataOrb.isStackEqual(aStack, false, true);
    }

    public ArrayList<ItemStack> getDataItems(int state) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStackValid(this.mInventory[1]) && this.isCorrectDataItem(this.mInventory[1], state)) {
            rList.add(this.mInventory[1]);
        }
        for (GT_MetaTileEntity_Hatch_DataAccess tHatch : this.mDataAccessHatches) {
            if (!GT_MetaTileEntity_AssemblyLine.isValidMetaTileEntity(tHatch)) continue;
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null || !this.isCorrectDataItem(tHatch.getBaseMetaTileEntity().func_70301_a(i), state)) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DataAccess) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDataAccessHatches.add((GT_MetaTileEntity_Hatch_DataAccess)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

