/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicHull;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine_GT_Recipe;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import ic2.core.block.BlockIC2Door;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GT_MetaTileEntity_Cleanroom
extends GT_MetaTileEntity_MultiBlockBase {
    private int sizeX;
    private int sizeY;
    private int sizeZ;
    private int openDoorsCount = 0;
    private static int euPerVent;
    private static int idleEnergyReduceMultiplier;
    private static int cleanBlockTimeByVentTicks;
    private static int mHullsLessInTimesThanWallsSquare;
    private int progressMultiplier = 1;
    private int mMaxDoorBlocksAllowed = 2;
    private int mMaxDoorBlocksUsed = 0;
    private int energyConsumptionMin = 0;
    private int energyConsumptionMax = 0;
    private int mHullsAllowed = 0;
    private int mHullsUsed = 0;

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        euPerVent = aConfig.get((Object)ConfigCategories.machineconfig, "Cleanroom.euPerVent", 3);
        cleanBlockTimeByVentTicks = aConfig.get((Object)ConfigCategories.machineconfig, "Cleanroom.cleanBlockTimeByVentTicks", 1600);
        idleEnergyReduceMultiplier = aConfig.get((Object)ConfigCategories.machineconfig, "Cleanroom.idleEnergyReduceMultiplier", 3);
        mHullsLessInTimesThanWallsSquare = aConfig.get((Object)ConfigCategories.machineconfig, "Cleanroom.mHullsLessInTimesThanWallsSquare", 3);
    }

    public GT_MetaTileEntity_Cleanroom(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_Cleanroom(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Cleanroom(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Cleanroom", "Min(WxHxD): 3x4x3 (Hollow), Max(WxHxD): 15x15x15 (Hollow)", "Controller (Top center)", "Top besides controller and edges Filter Machine Casings", "Blocks Plascrete for all edges", "1 Reinforced Door (keep closed for 100% efficency)", "1x Energy Hatch, the tier depends on energy consumption", "1x Maintenance Hatch", "A second door is allowed if the base area is at least 7*7", "Remaining Blocks Plascrete or Plascrete Window", "Up to 1/" + mHullsLessInTimesThanWallsSquare + " of wall blocks can be replaced with Machine", "Hulls to transfer Items & Energy through walls", "Energy consumption depends on ceiling square, " + euPerVent + " eu/t per block", "Cleaning time depends on ceiling height, " + cleanBlockTimeByVentTicks / 20 + " sec per block", "Energy consumption decreases after full cleaning in " + idleEnergyReduceMultiplier + " times", "Use Portable Scanner on Controller to get more info"};
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        byte requiredTier;
        this.mMaxProgresstime = 100;
        int ceilingSquare = (this.sizeX - 2) * (this.sizeZ - 2);
        this.mEUt = euPerVent * ceilingSquare;
        long tVoltage = this.getMaxInputVoltage();
        byte currentTier = (byte)Math.max(0, GT_Utility.getTier(tVoltage));
        this.progressMultiplier = currentTier <= (requiredTier = (byte)Math.max(0, GT_Utility.getTier(this.mEUt))) ? 1 : 1 << currentTier - requiredTier;
        int reduceEfficiencyGrowing = cleanBlockTimeByVentTicks * (this.sizeY - 2);
        int maxEfficiencyGrowing = 1000000;
        if (this.progressMultiplier > 1) {
            this.mEfficiencyIncrease = maxEfficiencyGrowing * this.progressMultiplier / reduceEfficiencyGrowing;
            this.mEUt *= this.progressMultiplier * 2;
        } else {
            this.mEfficiencyIncrease = maxEfficiencyGrowing / reduceEfficiencyGrowing;
        }
        this.energyConsumptionMax = this.mEUt;
        this.energyConsumptionMin = this.mEUt / idleEnergyReduceMultiplier;
        if (this.mEfficiency >= 10000) {
            this.mEUt /= idleEnergyReduceMultiplier;
        }
        if (this.openDoorsCount > 0) {
            this.mEfficiencyIncrease = -(this.mEfficiencyIncrease * this.openDoorsCount);
        }
        this.mEUt = -this.mEUt;
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (!this.mMachine) {
            return new String[]{"Cleanroom", "Incomplete Structure"};
        }
        int totalCleanTimeSec = (this.sizeY - 2) * (cleanBlockTimeByVentTicks / 20) / this.progressMultiplier;
        float currentCleanTimeSec = (float)totalCleanTimeSec * ((float)this.mEfficiency / 10000.0f);
        int problemsCount = this.getIdealStatus() - this.getRepairStatus();
        return new String[]{"Cleaning time: ", Math.round(currentCleanTimeSec) + " / " + totalCleanTimeSec + " s", "Energy consumption while idle/cleaning: ", this.energyConsumptionMin + " / " + this.energyConsumptionMax + " EU/t", "Efficiency: ", (float)this.mEfficiency / 100.0f + " %", "Machine Hulls (used/allowed): " + this.mHullsUsed + "/" + this.mHullsAllowed, "Doors (used/allowed): " + this.mMaxDoorBlocksUsed / 2 + "/" + this.mMaxDoorBlocksAllowed / 2, "Problems: ", "" + problemsCount};
    }

    private int calcMachinesHullAllowed(int x, int y) {
        return ((x - 2) * (y - 2) * 4 - 2) / mHullsLessInTimesThanWallsSquare;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        byte dX;
        byte i;
        byte x = 1;
        byte z = 1;
        byte y = 1;
        this.mMaxDoorBlocksUsed = 0;
        this.mMaxDoorBlocksAllowed = 2;
        this.mHullsUsed = 0;
        this.openDoorsCount = 0;
        for (i = 1; i < 8; ++i) {
            Block tBlockX = aBaseMetaTileEntity.getBlockOffset(i, 0, 0);
            Block tBlockZ = aBaseMetaTileEntity.getBlockOffset(0, 0, i);
            byte tMetaX = aBaseMetaTileEntity.getMetaIDOffset(i, 0, 0);
            byte tMetaZ = aBaseMetaTileEntity.getMetaIDOffset(0, 0, i);
            if (tBlockX == GregTech_API.sBlockCasings3 && tMetaX == 11 && tBlockZ == GregTech_API.sBlockCasings3 && tMetaZ == 11) continue;
            if (tBlockX != GregTech_API.sBlockReinforced || tMetaX != 2 || tBlockZ != GregTech_API.sBlockReinforced || tMetaZ != 2) {
                return false;
            }
            x = i;
            z = i;
            break;
        }
        i = -1;
        while (i > -16) {
            Block tBlock = aBaseMetaTileEntity.getBlockOffset(x, i, z);
            byte tMeta = aBaseMetaTileEntity.getMetaIDOffset(x, i, z);
            if (tBlock != GregTech_API.sBlockReinforced || tMeta != 2) break;
            y = i--;
        }
        if (y > -3) {
            return false;
        }
        this.sizeX = x * 2 + 1;
        this.sizeY = -y + 1;
        this.sizeZ = z * 2 + 1;
        this.mHullsAllowed = this.calcMachinesHullAllowed(this.sizeX, this.sizeY);
        if (this.sizeX * this.sizeZ >= 49) {
            this.mMaxDoorBlocksAllowed = 4;
        }
        for (dX = -x; dX <= x; ++dX) {
            for (byte dZ = -z; dZ <= z; ++dZ) {
                for (byte dY = 0; dY >= y; --dY) {
                    if (dX != -x && dX != x && dY != 0 && dY != y && dZ != -z && dZ != z || dX == 0 && dY == 0 && dZ == 0) continue;
                    Block tBlock = aBaseMetaTileEntity.getBlockOffset(dX, dY, dZ);
                    byte tMeta = aBaseMetaTileEntity.getMetaIDOffset(dX, dY, dZ);
                    IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(dX, dY, dZ);
                    if (!((dX != -x && dX != x || dY != 0 && dY != y) && (dX != -x && dX != x || dZ != -z && dZ != z) && (dZ != -z && dZ != z || dY != 0 && dY != y))) {
                        if (tBlock == GregTech_API.sBlockReinforced && tMeta == 2 || this.addMaintenanceToMachineList(tTileEntity, 82) || this.addEnergyInputToMachineList(tTileEntity, 82)) continue;
                        return false;
                    }
                    if (dY == 0) {
                        if (tBlock == GregTech_API.sBlockCasings3 && tMeta == 11) continue;
                        return false;
                    }
                    if (tBlock == GregTech_API.sBlockReinforced && tMeta == 2 || this.addMaintenanceToMachineList(tTileEntity, 82) || this.addEnergyInputToMachineList(tTileEntity, 82)) continue;
                    if (tBlock instanceof BlockIC2Door) {
                        if ((tMeta & 8) == 0 && Math.abs(dX) > Math.abs(dZ) == ((tMeta & 1) != 0) != ((tMeta & 4) != 0)) {
                            ++this.openDoorsCount;
                        }
                        ++this.mMaxDoorBlocksUsed;
                        continue;
                    }
                    if (tBlock == GregTech_API.sBlockGlass && tMeta == 0) continue;
                    if (tTileEntity == null) {
                        return false;
                    }
                    IMetaTileEntity aMetaTileEntity = tTileEntity.getMetaTileEntity();
                    if (aMetaTileEntity == null) {
                        return false;
                    }
                    if (aMetaTileEntity instanceof GT_MetaTileEntity_BasicHull) {
                        ++this.mHullsUsed;
                        continue;
                    }
                    return false;
                }
            }
        }
        if (this.mMaintenanceHatches.size() != 1 || this.mEnergyHatches.size() != 1 || this.mMaxDoorBlocksUsed < 2 || this.mMaxDoorBlocksUsed > this.mMaxDoorBlocksAllowed || this.mHullsUsed > this.mHullsAllowed) {
            return false;
        }
        for (dX = -x + 1; dX <= x - 1; ++dX) {
            for (int dZ = -z + 1; dZ <= z - 1; ++dZ) {
                for (int dY = -1; dY >= y + 1; --dY) {
                    IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(dX, dY, dZ);
                    if (tTileEntity == null) continue;
                    IMetaTileEntity aMetaTileEntity = tTileEntity.getMetaTileEntity();
                    if (aMetaTileEntity instanceof GT_MetaTileEntity_BasicMachine_GT_Recipe) {
                        ((GT_MetaTileEntity_BasicMachine_GT_Recipe)aMetaTileEntity).mCleanroom = this;
                    }
                    if (!(aMetaTileEntity instanceof GT_MetaTileEntity_MultiBlockBase)) continue;
                    ((GT_MetaTileEntity_MultiBlockBase)aMetaTileEntity).mCleanroom = this;
                }
            }
        }
        for (i = 0; i < 6; i = (byte)(i + 1)) {
            byte t = (byte)Math.max(1, (byte)(15.0f / (10000.0f / (float)this.mEfficiency)));
            aBaseMetaTileEntity.setInternalOutputRedstoneSignal(i, t);
        }
        return true;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == 0 || aSide == 1) {
            return new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.BLOCK_PLASCRETE), new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_TOP_CLEANROOM_ACTIVE : Textures.BlockIcons.OVERLAY_TOP_CLEANROOM)};
        }
        return new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.BLOCK_PLASCRETE)};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone, byte aFluidFacing) {
        return this.getTexture(aBaseMetaTileEntity, aSide, aFacing, aColorIndex, aActive, aRedstone);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public int getAmountOfOutputs() {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (!this.drainEnergyInput(-this.mEUt)) {
            this.stopMachine();
            return false;
        }
        return true;
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdate = 15;
    }
}

