/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_LargeBoiler
extends GT_MetaTileEntity_MultiBlockBase {
    private boolean firstRun = true;
    private int integratedCircuitConfig = 0;
    private int excessFuel = 0;
    private int excessProjectedEU = 0;
    private int progressTimeStash = 0;
    private int defaultProgressChunk = 20;
    private int lastFuelEfficiencyIncrease = 0;
    private int tGeneratedEU = 0;
    private boolean solidSuperFuel = false;
    private float water;
    protected boolean oxygenBoost = false;

    public GT_MetaTileEntity_LargeBoiler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeBoiler(String aName) {
        super(aName);
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        this.defaultProgressChunk = Math.min(80, Math.max(20, aConfig.get((Object)ConfigCategories.machineconfig, "LargeBoiler.defaultProgressChunk", 20)));
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Large Boiler", "Produces " + (float)(this.getEUt() * 40) * ((float)this.runtimeBoost(20) / 20.0f) + "L of Steam with 1 Coal at " + this.getEUt() * 40 + "L/s", "A programmed circuit in the main block throttles the boiler (-1000L/s per config)", "Size(WxHxD): 3x5x3, Controller (Front middle in Fireboxes)", "3x1x3 of " + this.getCasingMaterial() + " Firebox Casings (Bottom layer, Min 3)", "3x4x3 of " + this.getCasingMaterial() + " " + this.getCasingBlockType() + " (Above Fireboxes, hollow, Min 24!)", "1x3x1 of " + this.getCasingMaterial() + " Pipe Casings (Inside the Hollow Machine Casings/Plated Bricks)", "1x Fuel Input Hatch/Bus instead any Firebox", "1x Input Hatch instead any Firebox for Water / Distilled Water", "1x Steam Output Hatch instead any Casing", "1x Maintenance Hatch instead any Firebox", "1x Muffler Hatch instead any Firebox", "Firstly Consumes Distilled Water, Secondly Water", "Diesel fuels have 1/4 efficiency", this.getOxygenPerOperation() > 0L ? this.getOxygenPerOperation() + "L/s of Oxygen and Solid Super Fuel will give a Superheated Steam" : "Only Large Titanium or Large TungstenSteel Boilers can be boosted", String.format("Takes %.2f seconds to heat up", 500.0 / (double)this.getEfficiencyIncrease()), "Causes up to " + 20 * this.getPollutionPerTick(null) + " Pollution per second"};
    }

    public abstract String getCasingMaterial();

    public abstract Block getCasingBlock();

    public abstract String getCasingBlockType();

    public abstract byte getCasingMeta();

    public abstract byte getCasingTextureIndex();

    public abstract Block getPipeBlock();

    public abstract byte getPipeMeta();

    public abstract Block getFireboxBlock();

    public abstract byte getFireboxMeta();

    public abstract byte getFireboxTextureIndex();

    public abstract long getOxygenPerOperation();

    public abstract int getEUt();

    public abstract int getEfficiencyIncrease();

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[this.getCasingTextureIndex()], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[this.getCasingTextureIndex()]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeBoiler.png");
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74776_a("water", this.water);
        aNBT.func_74768_a("excessProjectedEU", this.excessProjectedEU);
        aNBT.func_74768_a("progressTimeStash", this.progressTimeStash);
        aNBT.func_74768_a("excessFuel", this.excessFuel);
        aNBT.func_74757_a("oxygenBoost", this.oxygenBoost);
        aNBT.func_74757_a("solidSuperFuel", this.solidSuperFuel);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.water = aNBT.func_74760_g("water");
        this.excessProjectedEU = aNBT.func_74762_e("excessProjectedEU");
        this.progressTimeStash = aNBT.func_74762_e("progressTimeStash");
        this.excessFuel = aNBT.func_74762_e("excessFuel");
        this.oxygenBoost = aNBT.func_74767_n("oxygenBoost");
        this.solidSuperFuel = aNBT.func_74767_n("solidSuperFuel");
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    private void calcProgressVars() {
        this.oxygenBoost = this.getOxygenPerOperation() > 0L && this.solidSuperFuel ? this.depleteInput(Materials.Oxygen.getGas(this.getOxygenPerOperation() * (long)this.mMaxProgresstime)) : false;
        this.mEfficiencyIncrease = this.lastFuelEfficiencyIncrease;
        this.mMaxProgresstime = this.adjustBurnTimeForConfig(this.runtimeBoost(this.mMaxProgresstime));
        this.mEUt = this.adjustEUtForConfig(this.getEUt());
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        FluidStack tFluid;
        if (this.mInventory[1] != null && this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit")) {
            int circuit_config = this.mInventory[1].func_77960_j();
            if (circuit_config >= 1 && circuit_config <= 25) {
                this.integratedCircuitConfig = circuit_config;
            }
        } else {
            this.integratedCircuitConfig = 0;
        }
        if (this.progressTimeStash >= this.defaultProgressChunk) {
            this.progressTimeStash -= this.defaultProgressChunk;
            this.mMaxProgresstime = this.defaultProgressChunk;
            this.calcProgressVars();
            return true;
        }
        this.solidSuperFuel = false;
        for (GT_Recipe tRecipe : GT_Recipe.GT_Recipe_Map.sDieselFuels.mRecipeList) {
            tFluid = GT_Utility.getFluidForFilledItem(tRecipe.getRepresentativeInput(0), true);
            if (tFluid == null || tRecipe.mSpecialValue <= 1) continue;
            tFluid.amount = 8000;
            if (!this.depleteInput(tFluid)) continue;
            this.mMaxProgresstime = tRecipe.mSpecialValue * (tFluid.amount / 1000) / 2;
            if (this.mMaxProgresstime >= this.defaultProgressChunk) {
                this.progressTimeStash = this.mMaxProgresstime - this.defaultProgressChunk;
                this.mMaxProgresstime = this.defaultProgressChunk;
            }
            this.lastFuelEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease() * 4;
            this.calcProgressVars();
            return true;
        }
        for (GT_Recipe tRecipe : GT_Recipe.GT_Recipe_Map.sDenseLiquidFuels.mRecipeList) {
            tFluid = GT_Utility.getFluidForFilledItem(tRecipe.getRepresentativeInput(0), true);
            if (tFluid == null) continue;
            tFluid.amount = 8000;
            if (!this.depleteInput(tFluid)) continue;
            this.mMaxProgresstime = Math.max(1, tRecipe.mSpecialValue * (tFluid.amount / 1000) * 2);
            if (this.mMaxProgresstime >= this.defaultProgressChunk) {
                this.progressTimeStash = this.mMaxProgresstime - this.defaultProgressChunk;
                this.mMaxProgresstime = this.defaultProgressChunk;
            }
            this.lastFuelEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
            this.calcProgressVars();
            return true;
        }
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        if (!tInputList.isEmpty()) {
            for (ItemStack tInput : tInputList) {
                if (tInput == GT_OreDictUnificator.get(OrePrefixes.bucket, Materials.Lava, 1L)) continue;
                int fuelValue = GT_ModHandler.getFuelValue(tInput) / 80;
                boolean bl = this.solidSuperFuel = fuelValue >= 1250;
                if (GT_Utility.getFluidForFilledItem(tInput, true) != null || fuelValue <= 0) continue;
                this.mMaxProgresstime = 0;
                while (tInput.field_77994_a > 0 && this.mMaxProgresstime < this.defaultProgressChunk) {
                    this.mMaxProgresstime += fuelValue;
                    this.excessFuel += GT_ModHandler.getFuelValue(tInput) % 80;
                    this.mMaxProgresstime += this.excessFuel / 80;
                    this.excessFuel %= 80;
                    this.mOutputItems = new ItemStack[]{GT_Utility.getContainerItem(tInput, true)};
                    --tInput.field_77994_a;
                }
                this.mMaxProgresstime += this.progressTimeStash;
                this.progressTimeStash = 0;
                if (this.mMaxProgresstime >= this.defaultProgressChunk) {
                    this.progressTimeStash = this.mMaxProgresstime - this.defaultProgressChunk;
                    this.mMaxProgresstime = this.defaultProgressChunk;
                }
                this.lastFuelEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
                this.calcProgressVars();
                this.updateSlots();
                return true;
            }
        }
        if (this.progressTimeStash > 0) {
            this.mMaxProgresstime = this.progressTimeStash;
            this.progressTimeStash = 0;
            this.calcProgressVars();
            this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
            return true;
        }
        this.mMaxProgresstime = 0;
        this.mEUt = 0;
        return false;
    }

    abstract int runtimeBoost(int var1);

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            this.mEfficiency = Math.max(0, Math.min(this.mEfficiency, this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000));
            this.tGeneratedEU = (int)((long)this.mEUt * 2L * (long)this.mEfficiency / 10000L);
            if (this.tGeneratedEU > 0) {
                this.water += (float)this.tGeneratedEU / 160.0f;
                int amount = (int)this.water;
                this.water -= (float)amount;
                if (this.depleteInput(GT_ModHandler.getDistilledWater(amount)) || this.depleteInput(Materials.Water.getFluid(amount))) {
                    this.addOutput(this.oxygenBoost ? FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)this.tGeneratedEU) : GT_ModHandler.getSteam(this.tGeneratedEU));
                } else {
                    this.explodeMultiblock();
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mProgresstime > 0 && this.firstRun) {
            this.firstRun = false;
            GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "extremepressure");
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int j;
        int i;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tCasingAmount = 0;
        int tFireboxAmount = 0;
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                int k;
                if (i != 0 || j != 0) {
                    for (k = 1; k <= 4; ++k) {
                        if (this.addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, k, zDir + j), this.getCasingTextureIndex())) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + i, k, zDir + j) != this.getCasingBlock()) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, k, zDir + j) != this.getCasingMeta()) {
                            return false;
                        }
                        ++tCasingAmount;
                    }
                    continue;
                }
                for (k = 1; k <= 3; ++k) {
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i, k, zDir + j) != this.getPipeBlock()) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, k, zDir + j) == this.getPipeMeta()) continue;
                    return false;
                }
                if (this.addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 4, zDir + j), this.getCasingTextureIndex())) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 4, zDir + j) != this.getCasingBlock()) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 4, zDir + j) != this.getCasingMeta()) {
                    return false;
                }
                ++tCasingAmount;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                IGregTechTileEntity tTileEntity;
                if (xDir + i == 0 && zDir + j == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j), this.getFireboxTextureIndex()) || this.addInputToMachineList(tTileEntity, this.getFireboxTextureIndex()) || this.addMufflerToMachineList(tTileEntity, this.getFireboxTextureIndex())) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 0, zDir + j) != this.getFireboxBlock()) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 0, zDir + j) != this.getFireboxMeta()) {
                    return false;
                }
                ++tFireboxAmount;
            }
        }
        return tCasingAmount >= 24 && tFireboxAmount >= 3;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        int adjustedEUOutput = Math.max(25, this.getEUt() - 25 * this.integratedCircuitConfig);
        return Math.max(1, 12 * (adjustedEUOutput *= this.oxygenBoost ? 3 : 1) / this.getEUt());
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private boolean isHeatingUp() {
        return this.mEfficiency < this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
    }

    private int adjustEUtForConfig(int rawEUt) {
        if (this.isHeatingUp()) {
            return rawEUt;
        }
        int adjustedSteamOutput = rawEUt - 25 * this.integratedCircuitConfig;
        return Math.max(adjustedSteamOutput, 25);
    }

    private int adjustBurnTimeForConfig(int rawBurnTime) {
        if (this.isHeatingUp()) {
            return rawBurnTime;
        }
        int adjustedEUt = Math.max(25, this.getEUt() - 25 * this.integratedCircuitConfig);
        int adjustedBurnTime = rawBurnTime * this.getEUt() / adjustedEUt;
        this.excessProjectedEU += this.getEUt() * rawBurnTime - adjustedEUt * adjustedBurnTime;
        this.excessProjectedEU %= adjustedEUt;
        return adjustedBurnTime += this.excessProjectedEU / adjustedEUt;
    }

    @Override
    public String[] getInfoData() {
        String tRunning = this.mMaxProgresstime > 0 ? "Running" : "Stopped";
        return new String[]{this.getCasingMaterial() + " Boiler", tRunning, "Producing: ", this.oxygenBoost ? "SH Steam" : "Steam ", "Amount: ", (this.mEUt > 0 ? this.tGeneratedEU : 0) + " L/t", "Efficiency: ", this.mEfficiency / 100 + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": ", "" + (this.getIdealStatus() - this.getRepairStatus())};
    }
}

