/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_Gas
extends GT_MetaTileEntity_LargeTurbine {
    private static float oxygenFactor = 28.0f;
    private int oxygenConsume = 0;
    private int prevOxygenConsume = 0;
    private boolean isBoosted = false;

    public GT_MetaTileEntity_LargeTurbine_Gas(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_Gas(String aName) {
        super(aName);
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        oxygenFactor = (float)Math.max(1.0, Math.min(1000.0, aConfig.get((Object)ConfigCategories.machineconfig, "LargeTurbineGas.oxygenFactor", 28.0)));
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1];
        iTextureArray[1] = aFacing == aSide ? (aActive ? new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_SS_ACTIVE5) : new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_SS5)) : Textures.BlockIcons.CASING_BLOCKS[58];
        return iTextureArray;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isBoosted", this.isBoosted);
        aNBT.func_74768_a("oxygenConsume", this.oxygenConsume);
        aNBT.func_74768_a("prevOxygenConsume", this.prevOxygenConsume);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isBoosted = aNBT.func_74767_n("isBoosted");
        this.oxygenConsume = aNBT.func_74762_e("oxygenConsume");
        this.prevOxygenConsume = aNBT.func_74762_e("prevOxygenConsume");
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Large Gas Turbine", "Size(WxHxD): 3x3x4 (Hollow), Controller (Front centered)", "1x Gas Input Hatch (Side centered)", "1x Maintenance Hatch (Side centered)", "1x Muffler Hatch (Side centered)", "1x Dynamo Hatch (Back centered)", "Stainless Steel Turbine Casings for the rest (24 at least!)", "Needs a Turbine Item (Inside controller GUI)", "Energy Output depending on Rotor: 102-6720EU/t", "Oxygen can boost output x3 but fuel consume x2", "Oxygen consuming depends on generating EU/t", "Causes " + 20 * this.getPollutionPerTick(null) + " Pollution per second"};
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null || GT_Recipe.GT_Recipe_Map.sTurbineFuels == null) {
            return 0;
        }
        Collection tRecipeList = GT_Recipe.GT_Recipe_Map.sTurbineFuels.mRecipeList;
        if (tRecipeList != null) {
            for (GT_Recipe tFuel : tRecipeList) {
                FluidStack tLiquid = GT_Utility.getFluidForFilledItem(tFuel.getRepresentativeInput(0), true);
                if (tLiquid == null || !aLiquid.isFluidEqual(tLiquid)) continue;
                return tFuel.mSpecialValue;
            }
        }
        return 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_Gas(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 10;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 58;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return this.isBoosted ? 16 : 8;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            this.isBoosted = false;
            this.oxygenConsume = 0;
            return 0;
        }
        if (aStack.func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            return Math.max(this.mEfficiency, 10000);
        }
        return 0;
    }

    private int calcBoostDelta(int maxOxygenConsume, int currentOxygenConsume) {
        int res = 5;
        if (maxOxygenConsume > currentOxygenConsume) {
            res = -6;
            if (this.mEfficiency > 12550) {
                res -= (this.mEfficiency - 12550) / 10;
            }
        }
        return res;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        if (aFluids.size() >= 1) {
            float fuelOverload = 0.0f;
            if (this.mEfficiency >= 10000) {
                fuelOverload = (float)(this.mEfficiency - 10000) / 5000.0f;
                this.oxygenConsume = Math.max(1, (int)((float)this.mEUt / (2.0f * oxygenFactor)));
                if (this.mEfficiency < 12550) {
                    float overload = (float)Math.sqrt(fuelOverload);
                    this.oxygenConsume = (int)((float)this.oxygenConsume * overload);
                }
                this.oxygenConsume = Math.max(1, this.oxygenConsume);
                if (this.prevOxygenConsume <= this.oxygenConsume) {
                    this.prevOxygenConsume = this.oxygenConsume;
                } else {
                    --this.prevOxygenConsume;
                    this.oxygenConsume = this.prevOxygenConsume;
                }
                int realOxygenConsumed = this.depleteInputUpTo(Materials.Oxygen.getGas(this.oxygenConsume));
                boolean bl = this.isBoosted = realOxygenConsumed > 0 || this.mEfficiency > 10000;
                if (!this.isBoosted) {
                    this.oxygenConsume = 0;
                } else {
                    int deltaEfficient = this.calcBoostDelta(this.oxygenConsume, realOxygenConsumed);
                    this.mEfficiency = Math.min(this.mEfficiency + deltaEfficient, 15000);
                    this.oxygenConsume = realOxygenConsumed;
                }
            } else {
                this.isBoosted = false;
                this.oxygenConsume = 0;
            }
            FluidStack firstFuelType = null;
            boolean foundFuel = false;
            for (FluidStack fs : aFluids) {
                if (foundFuel) continue;
                firstFuelType = new FluidStack(fs, 0);
                foundFuel = this.getFuelValue(firstFuelType) != 0;
            }
            if (!foundFuel) {
                return 0;
            }
            int fuelValue = this.getFuelValue(firstFuelType);
            int actualOptimalFlow = aOptFlow / fuelValue;
            if (fuelOverload > 0.0f) {
                actualOptimalFlow += Math.round((float)actualOptimalFlow * fuelOverload);
            }
            this.realOptFlow = actualOptimalFlow;
            float remainingFlowFactor = 1.25f;
            int remainingFlow = (int)((float)actualOptimalFlow * remainingFlowFactor);
            int totalFlow = 0;
            int aFluids_sS = aFluids.size();
            for (int i = 0; i < aFluids_sS; ++i) {
                if (!aFluids.get(i).isFluidEqual(firstFuelType)) continue;
                int flow = aFluids.get((int)i).amount;
                flow = Math.min(flow, Math.min(remainingFlow, (int)((float)actualOptimalFlow * 1.25f)));
                this.depleteInput(new FluidStack(aFluids.get(i), flow));
                this.storedFluid = aFluids.get((int)i).amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            int tEU = (int)(Math.min((float)actualOptimalFlow, (float)totalFlow) * (float)fuelValue);
            if (totalFlow != actualOptimalFlow) {
                float efficiency = 1.0f - Math.abs(((float)totalFlow - (float)actualOptimalFlow) / (float)actualOptimalFlow);
                if (totalFlow > actualOptimalFlow) {
                    efficiency = 1.0f;
                }
                if (efficiency < 0.0f) {
                    efficiency = 0.0f;
                }
                tEU = (int)((float)tEU * efficiency);
                tEU = Math.max(1, (int)((long)tEU * (long)aBaseEff / 10000L));
            } else {
                tEU = (int)((long)tEU * (long)aBaseEff / 10000L);
            }
            return tEU;
        }
        return 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!aBaseMetaTileEntity.isAllowedToWork()) {
            this.isBoosted = false;
            this.oxygenConsume = 0;
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public int getRealOutEu() {
        return (int)((float)(this.mEUt * this.mEfficiency) / 10000.0f);
    }

    @Override
    public String[] getInfoData() {
        String tRunning = this.mMaxProgresstime > 0 ? "Running" : "Stopped";
        int tDura = 0;
        if (this.mInventory[1] != null && this.mInventory[1].func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            tDura = (int)(100.0f / (float)GT_MetaGenerated_Tool.getToolMaxDamage(this.mInventory[1]) * (float)GT_MetaGenerated_Tool.getToolDamage(this.mInventory[1]) + 1.0f);
        }
        return new String[]{"Gas Turbine", tRunning, "Mode: " + (this.isBoosted ? "Boosted" : "Normal"), this.getRealOutEu() + " EU/t", "Oxygen Consuming: ", this.oxygenConsume + " L/t", "Optimal Fuel Flow: ", (int)this.realOptFlow + " L/t", "Fuel: ", this.storedFluid + "L", "Speed: ", this.mEfficiency / 100 + "%", "Damage: ", tDura + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": ", "" + (this.getIdealStatus() - this.getRepairStatus())};
    }
}

