/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_Steam
extends GT_MetaTileEntity_LargeTurbine {
    private float water;
    private boolean achievement = false;

    public GT_MetaTileEntity_LargeTurbine_Steam(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_Steam(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1];
        iTextureArray[1] = aFacing == aSide ? (aActive ? new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_ST_ACTIVE5) : new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_ST5)) : Textures.BlockIcons.CASING_BLOCKS[57];
        return iTextureArray;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Large Steam Turbine", "Size(WxHxD): 3x3x4 (Hollow), Controller (Front centered)", "1x Steam Input Hatch (Side centered)", "Optional Output Hatch for Distilled Water (Side centered)", "1x Maintenance Hatch (Side centered)", "1x Dynamo Hatch (Back centered)", "Turbine Casings for the rest (24 at least!)", "Needs a Turbine Item (Inside controller GUI)", "Energy Output depending on Rotor: 60-3360EU/t"};
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_Steam(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 9;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 46;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    private int useWater(float input) {
        this.water += input;
        int usage = (int)this.water;
        this.water -= (float)usage;
        return usage;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        int remainingFlow = (int)((float)aOptFlow * 1.25f);
        this.realOptFlow = (double)(aOptFlow / 2) / 0.5;
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            String fluidName = aFluids.get(i).getFluid().getUnlocalizedName(aFluids.get(i));
            if (fluidName.equals("fluid.steam") || fluidName.equals("ic2.fluidSteam") || fluidName.equals("fluid.mfr.steam.still.name")) {
                flow = aFluids.get((int)i).amount;
                flow = Math.min(flow, Math.min(remainingFlow, (int)((float)aOptFlow * 1.25f)));
                this.depleteInput(new FluidStack(aFluids.get(i), flow));
                this.storedFluid = aFluids.get((int)i).amount;
                remainingFlow -= flow;
                totalFlow += flow;
                if (this.achievement) continue;
                GT_Mod.achievements.issueAchievement(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()), "muchsteam");
                this.achievement = true;
                continue;
            }
            if (!fluidName.equals("ic2.fluidSuperheatedSteam")) continue;
            this.depleteInput(new FluidStack(aFluids.get(i), aFluids.get((int)i).amount));
        }
        tEU = (int)Math.min((float)aOptFlow, (float)totalFlow);
        int waterToOutput = this.useWater((float)totalFlow / 160.0f);
        this.addOutput(GT_ModHandler.getDistilledWater(waterToOutput));
        if (totalFlow > 0 && totalFlow != aOptFlow) {
            float efficiency = 1.0f - Math.abs(((float)totalFlow - (float)aOptFlow) / (float)aOptFlow);
            if (totalFlow > aOptFlow) {
                efficiency = 1.0f;
            }
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, (int)((long)tEU * (long)aBaseEff / 20000L));
        } else {
            tEU = (int)((long)tEU * (long)aBaseEff / 20000L);
        }
        return tEU;
    }
}

