/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_OilDrillBase
extends GT_MetaTileEntity_DrillerBase {
    private boolean completedCycle = false;
    protected boolean isAllowPutPipesToController = false;
    private ArrayList<Chunk> mOilFieldChunks = new ArrayList();
    private int mOilId = 0;

    public GT_MetaTileEntity_OilDrillBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_OilDrillBase(String aName) {
        super(aName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mOilId", this.mOilId);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mOilId = aNBT.func_74762_e("mOilId");
    }

    @Override
    protected boolean allowPutPipesToController() {
        return this.isAllowPutPipesToController;
    }

    protected String[] getDescriptionInternal(String tierSuffix) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        return new String[]{"Controller Block for the Oil Drilling Rig " + (tierSuffix != null ? tierSuffix : ""), "Size(WxHxD): 3x7x3", "Controller (Front middle at bottom)", "3x1x3 Base of " + casings, "1x3x1 " + casings + " pillar (Center of base)", "1x3x1 " + this.getFrameMaterial().mName + " Frame Boxes (Each pillar side and on top)", "1x Output Hatch (One of base casings)", "1x Maintenance Hatch (One of base casings)", "1x " + GT_Values.VN[this.getMinTier()] + "+ Energy Hatch (Any bottom layer casing)", "Pumps " + 50.0 * Math.pow(3.0, this.getMinTier() - 2) + "% of nominal volume per cycle (" + 80.0 / Math.pow(2.0, this.getMinTier() - 2) + " ticks at a base voltage).", "Working on " + this.getRangeInChunks() + " * " + this.getRangeInChunks() + " chunks", "Use Programmed Circuits to ignore near exhausted oil field"};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "DrillingRig.png");
    }

    protected int getRangeInChunks() {
        return 0;
    }

    @Override
    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        ItemStack pipesInController = this.func_70301_a(1);
        boolean foundPipesStack = false;
        for (ItemStack itst : this.getStoredInputs()) {
            if (foundPipesStack || !itst.func_77969_a(miningPipe)) continue;
            foundPipesStack = true;
            this.addOutput(itst.func_77946_l());
            this.depleteInput(itst);
        }
        if (foundPipesStack) {
            return true;
        }
        if (pipesInController != null && pipesInController.field_77994_a > 0) {
            this.addOutput(pipesInController.func_77946_l());
            this.func_70299_a(1, null);
            return true;
        }
        return super.workingUpward(aStack, xDrill, yDrill, zDrill, xPipe, zPipe, yHead, oldYHead);
    }

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mOutputHatches.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    @Override
    protected void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(1, GT_Utility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -3 * (1 << (tier << 1));
        this.mMaxProgresstime = (this.workState == 1 ? 320 : 80) / (1 << tier);
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
    }

    @Override
    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        float speed;
        FluidStack tFluid;
        switch (this.tryLowerPipe(true)) {
            case 0: {
                this.workState = 0;
                this.setElectricityStats();
                return true;
            }
        }
        if (this.reachingVoidOrBedrock() && this.tryFillChunkList() && (tFluid = this.pumpOil(speed = 1.0f / (float)this.getMinTier() / (float)(this.getMinTier() > 2 ? 2 : 1))) != null && tFluid.amount > this.getTotalConfigValue()) {
            this.mOutputFluids = new FluidStack[]{tFluid};
            return true;
        }
        return true;
    }

    private boolean tryFillChunkList() {
        FluidStack tFluid;
        if (this.mOilId <= 0) {
            tFluid = GT_UndergroundOil.undergroundOilReadInformation(this.getBaseMetaTileEntity());
            if (tFluid == null) {
                return false;
            }
            this.mOilId = tFluid.getFluidID();
        }
        FluidStack tOil = new FluidStack(FluidRegistry.getFluid((int)this.mOilId), 0);
        if (this.mOilFieldChunks.isEmpty()) {
            Chunk tChunk = this.getBaseMetaTileEntity().getWorld().func_72938_d(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
            int range = this.getRangeInChunks();
            int xChunk = Math.floorDiv(tChunk.field_76635_g, range) * range;
            int zChunk = Math.floorDiv(tChunk.field_76647_h, range) * range;
            for (int i = 0; i < range; ++i) {
                for (int j = 0; j < range; ++j) {
                    tChunk = this.getBaseMetaTileEntity().getWorld().func_72964_e(xChunk + i, zChunk + j);
                    tFluid = GT_UndergroundOil.undergroundOilReadInformation(tChunk);
                    if (!tOil.isFluidEqual(tFluid) || tFluid.amount <= 0) continue;
                    this.mOilFieldChunks.add(tChunk);
                }
            }
        }
        return !this.mOilFieldChunks.isEmpty();
    }

    private FluidStack pumpOil(float speed) {
        if (this.mOilId <= 0) {
            return null;
        }
        FluidStack tOil = new FluidStack(FluidRegistry.getFluid((int)this.mOilId), 0);
        ArrayList<Chunk> emptyChunks = new ArrayList<Chunk>();
        for (Chunk tChunk : this.mOilFieldChunks) {
            FluidStack tFluid = GT_UndergroundOil.undergroundOil(tChunk, speed);
            if (tFluid == null || tFluid.amount < 1) {
                emptyChunks.add(tChunk);
            }
            if (!tOil.isFluidEqual(tFluid)) continue;
            tOil.amount += tFluid.amount;
        }
        for (Chunk tChunk : emptyChunks) {
            this.mOilFieldChunks.remove(tChunk);
        }
        return tOil.amount == 0 ? null : tOil;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_OilDrillBase.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + Integer.toString(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + Integer.toString(-this.mEUt) + EnumChatFormatting.RESET + " EU/t " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %"};
    }
}

