/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.GT_GUIContainer_DrillerBase;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import gregtech.common.tileentities.storage.OreCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_OreDrillingPlantBase
extends GT_MetaTileEntity_DrillerBase {
    private final ArrayList<ChunkPosition> oreBlockPositions = new ArrayList();
    public static int dFluidPerOperation;
    public static int dFluidUnderBedrock;
    public static int dFluidUnderBedrockIfEmpty;
    public static int consumeMiningPipeAfterCycles;
    public static int optimizationRate;
    public static int[] origOreFactors;
    public boolean isInCycleFoundStone = false;
    public int oreFactor;
    int currentOreFactor;
    int totalMinedOresCount;
    int moreCyclesTimes = 1;
    boolean isAllowPutPipesToController = false;
    int underBrOperationsCount = 0;
    float operationsCountPerCalcPeriod = -1.0f;
    ArrayList<OreHash> oreHashes;

    public static NBTTagCompound getTranslatedDataOrbNbtPages(NBTTagCompound origNbt) {
        NBTTagCompound trNbt = new NBTTagCompound();
        trNbt.func_74768_a("coordX", origNbt.func_74762_e("coordX"));
        trNbt.func_74768_a("coordY", origNbt.func_74762_e("coordY"));
        trNbt.func_74768_a("coordZ", origNbt.func_74762_e("coordZ"));
        trNbt.func_74768_a("dimensionId", origNbt.func_74762_e("dimensionId"));
        int minerTotalBlocksCount = origNbt.func_74762_e("minerTotalBlocksCount");
        int minerOreTypesCount = origNbt.func_74762_e("minerOreTypesCount");
        ArrayList<OreCollection> aList = OreCollection.getCollectionFromNbt(origNbt);
        NBTTagList tTagList = OreCollection.getTooltipLines(aList, minerTotalBlocksCount, minerOreTypesCount);
        trNbt.func_74782_a("pages", (NBTBase)tTagList);
        origNbt.func_74782_a("pages", (NBTBase)tTagList);
        return trNbt;
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        optimizationRate = aConfig.get((Object)ConfigCategories.machineconfig, "OreDrillingPlant.optimizationRate", 1);
        optimizationRate = Math.max(1, Math.min(optimizationRate, 4));
        dFluidPerOperation = aConfig.get((Object)ConfigCategories.machineconfig, "OreDrillingPlant.dFluidPerOperation", 2000);
        dFluidUnderBedrock = aConfig.get((Object)ConfigCategories.machineconfig, "OreDrillingPlant.dFluidUnderBedrock", 1000) * optimizationRate;
        dFluidUnderBedrockIfEmpty = aConfig.get((Object)ConfigCategories.machineconfig, "OreDrillingPlant.dFluidUnderBedrockIfEmpty", 1000) * optimizationRate;
        consumeMiningPipeAfterCycles = aConfig.get((Object)ConfigCategories.machineconfig, "OreDrillingPlant.consumeMiningPipeAfterCycles", 1000) / optimizationRate;
        try {
            boolean isFactorsConfigInvalid;
            origOreFactors = new int[]{35000, 60000, 131000, 288000};
            String factorsStr = aConfig.get((Object)ConfigCategories.machineconfig, "OreDrillingPlant.oreFactors", "35000,60000,131000,288000");
            String[] factors = factorsStr.split(",");
            boolean bl = isFactorsConfigInvalid = factors.length != 4;
            if (!isFactorsConfigInvalid) {
                int[] newFactors = new int[4];
                for (int i = 0; i < 4; ++i) {
                    newFactors[i] = Integer.parseInt(factors[i]);
                    if (newFactors[i] >= 10000) continue;
                    newFactors[i] = 10000;
                }
                origOreFactors = newFactors;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("ERROR - (may be because of) OreDrillingPlant.oreFactors config is invalid, it should be 4 numbers separated by comma without spaces");
            e.printStackTrace(GT_Log.err);
        }
    }

    public GT_MetaTileEntity_OreDrillingPlantBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_OreDrillingPlantBase(String aName) {
        super(aName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("underBrOperationsCount", this.underBrOperationsCount);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.underBrOperationsCount = aNBT.func_74762_e("underBrOperationsCount");
    }

    @Override
    protected boolean allowPutPipesToController() {
        return this.isAllowPutPipesToController;
    }

    private void prepareDataOrbTitle(IGregTechTileEntity te, NBTTagCompound nbt) {
        StringBuilder coords = new StringBuilder();
        coords.append(EnumChatFormatting.GOLD);
        coords.append("(x ");
        coords.append(te.getXCoord());
        coords.append(", y ");
        coords.append(te.getYCoord());
        coords.append(", z ");
        coords.append(te.getZCoord());
        coords.append(")");
        coords.append(EnumChatFormatting.RESET);
        nbt.func_74768_a("subTitleLinesCount", 3);
        nbt.func_74778_a("subTitleLine0", "DataOrb.Miner.dimension_id_" + te.getWorld().field_73011_w.field_76574_g);
        nbt.func_74778_a("subTitleLine1", coords.toString());
        nbt.func_74778_a("subTitleLine2", "DataOrb.Miner.use_data_reader");
    }

    private void updateDataOrbNbt(GT_ItemStack gtStack) {
        ArrayList<ItemStack> orbs = this.getDataItems(4);
        boolean foundOneOrb = false;
        for (ItemStack orb : orbs) {
            IGregTechTileEntity te;
            if (foundOneOrb || orbs.get((int)0).field_77994_a != 1) continue;
            HashMap<GT_ItemStack, Integer> gtStackMap = new HashMap<GT_ItemStack, Integer>();
            foundOneOrb = true;
            NBTTagCompound orbNbt = orb.func_77978_p();
            if (orbNbt == null) {
                orbNbt = new NBTTagCompound();
            }
            if ((te = this.getBaseMetaTileEntity()).getXCoord() == orbNbt.func_74762_e("coordX") && te.getYCoord() == orbNbt.func_74762_e("coordY") && te.getZCoord() == orbNbt.func_74762_e("coordZ") && te.getWorld().field_73011_w.field_76574_g == orbNbt.func_74762_e("dimensionId")) {
                int[] blocksCounts = orbNbt.func_74759_k("blocksCounts");
                if (blocksCounts != null) {
                    for (int i = 0; i < blocksCounts.length; ++i) {
                        GT_ItemStack savedGtStack = new GT_ItemStack(ItemStack.func_77949_a((NBTTagCompound)orbNbt.func_74775_l("minerOre" + i)));
                        gtStackMap.put(savedGtStack, blocksCounts[i]);
                    }
                }
            } else {
                orbNbt = new NBTTagCompound();
            }
            gtStackMap.putIfAbsent(gtStack, 0);
            byte blocksCount = gtStack.mStackSize;
            gtStackMap.put(gtStack, (Integer)gtStackMap.get(gtStack) + blocksCount);
            this.saveDataToOrb(orb, orbNbt, gtStackMap);
        }
    }

    private void saveDataToOrb(ItemStack orb, NBTTagCompound orbNbt, Map<GT_ItemStack, Integer> gtStackMap) {
        IGregTechTileEntity te = this.getBaseMetaTileEntity();
        orbNbt.func_74768_a("coordX", te.getXCoord());
        orbNbt.func_74768_a("coordY", (int)te.getYCoord());
        orbNbt.func_74768_a("coordZ", te.getZCoord());
        orbNbt.func_74768_a("dimensionId", te.getWorld().field_73011_w.field_76574_g);
        int[] blocksCounts = new int[gtStackMap.keySet().size()];
        int currentIdx = 0;
        int totalBlocksCount = 0;
        ArrayList<OreCollection> oreCollection = new ArrayList<OreCollection>();
        HashMap<String, Integer> oresMap = new HashMap<String, Integer>();
        for (GT_ItemStack gts : gtStackMap.keySet()) {
            ItemStack itst = gts.toStack();
            blocksCounts[currentIdx] = gtStackMap.get(gts);
            oresMap.putIfAbsent(itst.func_77977_a(), 0);
            oresMap.put(itst.func_77977_a(), (Integer)oresMap.get(itst.func_77977_a()) + blocksCounts[currentIdx]);
            totalBlocksCount += blocksCounts[currentIdx];
            NBTTagCompound sNbt = new NBTTagCompound();
            itst.func_77955_b(sNbt);
            orbNbt.func_74782_a("minerOre" + currentIdx, (NBTBase)sNbt);
            ++currentIdx;
        }
        for (String oreName : oresMap.keySet()) {
            oreCollection.add(new OreCollection(oreName, (Integer)oresMap.get(oreName), this.calcOreFlow((Integer)oresMap.get(oreName))));
        }
        int oreTypesCount = oresMap.size();
        orbNbt.func_74783_a("blocksCounts", blocksCounts);
        this.prepareDataOrbTitle(te, orbNbt);
        NBTTagCompound rawOresData = OreCollection.getRawOresData(oreCollection);
        orbNbt.func_74782_a("rawOresData", (NBTBase)rawOresData);
        orbNbt.func_74768_a("minerTotalBlocksCount", totalBlocksCount);
        orbNbt.func_74768_a("minerOreTypesCount", oreTypesCount);
        orb.func_77982_d(orbNbt);
    }

    private String calcOreFlow(int blocksCount) {
        double roundValue;
        double chanceToGet = (double)blocksCount / (double)this.getOreFactor();
        double oreFlow = chanceToGet * (double)this.getUnderBrOperationsCountPerPeriod();
        double d = oreFlow < 0.001 ? 0.0 : (oreFlow < 0.01 ? 1000.0 : (oreFlow < 0.1 ? 100.0 : (roundValue = oreFlow > 10.0 ? 10.0 : 100.0)));
        if (roundValue == 0.0) {
            return EnumChatFormatting.RED + "<" + EnumChatFormatting.RESET + " 0.001";
        }
        oreFlow = (double)Math.round(oreFlow * roundValue) / roundValue;
        return "" + oreFlow;
    }

    float getUnderBrOperationsCountPerPeriod() {
        if (this.operationsCountPerCalcPeriod > 0.0f) {
            return this.operationsCountPerCalcPeriod;
        }
        float ticksIn1hour = 72000.0f;
        this.operationsCountPerCalcPeriod = ticksIn1hour / 960.0f;
        return this.operationsCountPerCalcPeriod;
    }

    private ItemStack tryMineUnderBedrock() {
        ArrayList<ItemStack> orbs = this.getDataItems(4);
        boolean foundOneOrb = false;
        ItemStack result = null;
        for (ItemStack orb : orbs) {
            if (foundOneOrb || orbs.get((int)0).field_77994_a != 1) continue;
            foundOneOrb = true;
            IGregTechTileEntity te = this.getBaseMetaTileEntity();
            NBTTagCompound orbNbt = orb.func_77978_p();
            if (te.getXCoord() != orbNbt.func_74762_e("coordX") || te.getYCoord() != orbNbt.func_74762_e("coordY") || te.getZCoord() != orbNbt.func_74762_e("coordZ") || te.getWorld().field_73011_w.field_76574_g != orbNbt.func_74762_e("dimensionId")) continue;
            if (this.oreHashes == null) {
                this.prepareUnderBedrockOres(orbNbt);
            }
            result = this.getRandomUnderBedrockOre();
        }
        return result;
    }

    private void prepareUnderBedrockOres(NBTTagCompound orbNbt) {
        int[] blocksCounts = orbNbt.func_74759_k("blocksCounts");
        int currentVal = 1;
        this.oreHashes = new ArrayList();
        if (blocksCounts != null) {
            for (int i = 0; i < blocksCounts.length; ++i) {
                ItemStack aStack = ItemStack.func_77949_a((NBTTagCompound)orbNbt.func_74775_l("minerOre" + i));
                aStack.field_77994_a = 1;
                this.oreHashes.add(new OreHash(aStack, currentVal, blocksCounts[i] + currentVal - 1));
                this.totalMinedOresCount = (currentVal += blocksCounts[i]) - 1;
            }
        }
        this.currentOreFactor = this.totalMinedOresCount;
        if (this.currentOreFactor > this.getOreFactor()) {
            this.moreCyclesTimes = (int)Math.ceil((float)this.currentOreFactor / (float)this.getOreFactor());
            this.currentOreFactor = this.getOreFactor() * this.moreCyclesTimes;
        } else {
            this.currentOreFactor = this.getOreFactor();
        }
    }

    private int getOreFactor() {
        if (this.oreFactor > 0) {
            return this.oreFactor;
        }
        this.oreFactor = origOreFactors[this.getMinTier() - 2];
        return this.oreFactor;
    }

    private ItemStack getRandomUnderBedrockOre() {
        ItemStack output = null;
        int randVal = this.getBaseMetaTileEntity().getRandomNumber(this.currentOreFactor);
        for (OreHash hash : this.oreHashes) {
            if (output != null) continue;
            output = hash.tryGetItem(randVal);
        }
        if (output == null) {
            this.isInCycleFoundStone = true;
            output = GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L);
        } else {
            this.isInCycleFoundStone = false;
        }
        if (this.moreCyclesTimes > 1) {
            output.field_77994_a *= this.moreCyclesTimes;
        }
        if (optimizationRate > 1) {
            output.field_77994_a *= optimizationRate;
        }
        return output;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_DrillerBase(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "OreDrillingPlant.png");
    }

    @Override
    protected boolean workingDownward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        this.getBaseMetaTileEntity().setExtraInfo(yHead);
        if (yHead != oldYHead) {
            this.oreBlockPositions.clear();
        }
        this.fillMineListIfEmpty(xDrill, yDrill, zDrill, xPipe, zPipe, yHead);
        if (this.oreBlockPositions.isEmpty()) {
            switch (this.tryLowerPipe()) {
                case 2: {
                    this.mMaxProgresstime = 0;
                    return false;
                }
                case 3: {
                    this.workState = 2;
                    return true;
                }
                case 1: {
                    this.workState = 1;
                    return true;
                }
            }
            if (this.workState == 0) {
                this.fillMineListIfEmpty(xDrill, yDrill, zDrill, xPipe, zPipe, yHead);
            }
        }
        ChunkPosition oreBlockPos = null;
        Block oreBlock = null;
        IGregTechTileEntity te = this.getBaseMetaTileEntity();
        if (!this.tryConsumeDrillingFluid(dFluidPerOperation)) {
            return false;
        }
        while (!(oreBlock != null && oreBlock != Blocks.field_150350_a || this.oreBlockPositions.isEmpty())) {
            oreBlockPos = this.oreBlockPositions.remove(0);
            if (!GT_Utility.eraseBlockByFakePlayer(this.getFakePlayer(te), oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c, true)) continue;
            oreBlock = te.getBlock(oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c);
        }
        if (oreBlock != null && oreBlock != Blocks.field_150350_a) {
            ArrayList<ItemStack> oreBlockDrops = this.getBlockDrops(oreBlock, oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c);
            this.saveMinedOreBlocks((ArrayList)oreBlockDrops.clone());
            this.getBaseMetaTileEntity().getWorld().func_147468_f(oreBlockPos.field_151329_a, oreBlockPos.field_151327_b, oreBlockPos.field_151328_c);
            this.mOutputItems = this.getOutputByDrops(oreBlockDrops);
        }
        return true;
    }

    @Override
    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        IGregTechTileEntity te = this.getBaseMetaTileEntity();
        te.setExtraInfo(-2);
        ItemStack pipesInController = this.func_70301_a(1);
        boolean foundPipesStack = false;
        for (ItemStack itst : this.getStoredInputs()) {
            if (foundPipesStack || !itst.func_77969_a(miningPipe)) continue;
            foundPipesStack = true;
            this.addOutput(itst.func_77946_l());
            this.depleteInput(itst);
        }
        if (foundPipesStack) {
            return true;
        }
        if (pipesInController != null && pipesInController.field_77994_a > 0) {
            this.addOutput(pipesInController.func_77946_l());
            this.func_70299_a(1, null);
            return true;
        }
        return super.workingUpward(aStack, xDrill, yDrill, zDrill, xPipe, zPipe, yHead, oldYHead);
    }

    @Override
    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.reachingVoidOrBedrock()) {
            ItemStack output = this.tryMineUnderBedrock();
            if (output == null) {
                this.workState = 2;
                return true;
            }
            this.getBaseMetaTileEntity().setExtraInfo(-1);
            if (!this.consumeExpendableMaterials()) {
                this.mMaxProgresstime = 0;
                return false;
            }
            ArrayList<ItemStack> outStacks = new ArrayList<ItemStack>();
            outStacks.add(output);
            this.mOutputItems = this.getOutputByDrops(outStacks);
        }
        return true;
    }

    private boolean consumeExpendableMaterials() {
        boolean isSuccess;
        if (this.isHasMiningPipes()) {
            if (consumeMiningPipeAfterCycles <= this.underBrOperationsCount) {
                this.getBaseMetaTileEntity().func_70298_a(1, 1);
                this.underBrOperationsCount = 0;
            }
            isSuccess = this.tryConsumeDrillingFluid(this.isInCycleFoundStone ? dFluidUnderBedrockIfEmpty : dFluidUnderBedrock);
        } else {
            isSuccess = false;
        }
        if (isSuccess) {
            ++this.underBrOperationsCount;
        }
        return isSuccess;
    }

    private void saveMinedOreBlocks(ArrayList<ItemStack> oreBlockDrops) {
        for (ItemStack itst : oreBlockDrops) {
            if (!(itst.func_77973_b() instanceof ItemBlock)) continue;
            this.updateDataOrbNbt(new GT_ItemStack(itst));
        }
    }

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mInputHatches.isEmpty() && !this.mOutputBusses.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    @Override
    protected void setElectricityStats() {
        int mProgTime;
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(1, GT_Utility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -3 * (1 << (tier << 1));
        switch (this.workState) {
            case 0: {
                mProgTime = this.getBaseProgressTime();
                break;
            }
            case 1: {
                mProgTime = this.getBaseProgressTime() * optimizationRate;
                break;
            }
            default: {
                mProgTime = 80;
            }
        }
        this.mMaxProgresstime = mProgTime / (1 << tier);
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
    }

    private ItemStack[] getOutputByDrops(ArrayList<ItemStack> oreBlockDrops) {
        long voltage = this.getMaxInputVoltage();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        while (!oreBlockDrops.isEmpty()) {
            ItemStack currentItem = oreBlockDrops.remove(0).func_77946_l();
            if (!this.doUseMaceratorRecipe(currentItem)) {
                this.multiplyStackSize(currentItem);
                outputItems.add(currentItem);
                continue;
            }
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, voltage, null, currentItem);
            if (tRecipe == null) {
                outputItems.add(currentItem);
                continue;
            }
            for (int i = 0; i < tRecipe.mOutputs.length; ++i) {
                ItemStack recipeOutput = tRecipe.mOutputs[i].func_77946_l();
                if (this.getBaseMetaTileEntity().getRandomNumber(10000) < tRecipe.getOutputChance(i)) {
                    this.multiplyStackSize(recipeOutput);
                }
                outputItems.add(recipeOutput);
            }
        }
        return outputItems.toArray(new ItemStack[0]);
    }

    private boolean doUseMaceratorRecipe(ItemStack currentItem) {
        ItemData itemData = GT_OreDictUnificator.getItemData(currentItem);
        return itemData == null || itemData.mPrefix != OrePrefixes.crushed && itemData.mPrefix != OrePrefixes.dustImpure && itemData.mPrefix != OrePrefixes.dust && itemData.mMaterial.mMaterial != Materials.Oilsands;
    }

    private void multiplyStackSize(ItemStack itemStack) {
        itemStack.field_77994_a *= this.getBaseMetaTileEntity().getRandomNumber(4) + 1;
    }

    private ArrayList<ItemStack> getBlockDrops(final Block oreBlock, int posX, int posY, int posZ) {
        final byte blockMeta = this.getBaseMetaTileEntity().getMetaID(posX, posY, posZ);
        if (oreBlock.canSilkHarvest(this.getBaseMetaTileEntity().getWorld(), null, posX, posY, posZ, (int)blockMeta)) {
            return new ArrayList<ItemStack>(){
                {
                    this.add(new ItemStack(oreBlock, 1, blockMeta));
                }
            };
        }
        return oreBlock.getDrops(this.getBaseMetaTileEntity().getWorld(), posX, posY, posZ, (int)blockMeta, 1);
    }

    private boolean tryConsumeDrillingFluid(int fAmount) {
        if (!this.depleteInput(new FluidStack(ItemList.sDrillingFluid, fAmount))) {
            this.mMaxProgresstime = 0;
            return false;
        }
        return true;
    }

    private void fillMineListIfEmpty(int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead) {
        if (!this.oreBlockPositions.isEmpty()) {
            return;
        }
        this.tryAddOreBlockToMineList(xPipe, yHead - 1, zPipe);
        if (yHead == yDrill) {
            return;
        }
        int radius = this.getRadiusInChunks() << 4;
        for (int xOff = -radius; xOff <= radius; ++xOff) {
            for (int zOff = -radius; zOff <= radius; ++zOff) {
                this.tryAddOreBlockToMineList(xDrill + xOff, yHead, zDrill + zOff);
            }
        }
    }

    private void tryAddOreBlockToMineList(int x, int y, int z) {
        Block block = this.getBaseMetaTileEntity().getBlock(x, y, z);
        byte blockMeta = this.getBaseMetaTileEntity().getMetaID(x, y, z);
        ChunkPosition blockPos = new ChunkPosition(x, y, z);
        if (this.oreBlockPositions.contains(blockPos)) {
            return;
        }
        if (block instanceof GT_Block_Ores_Abstract) {
            TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntity(x, y, z);
            if (tTileEntity != null && tTileEntity instanceof GT_TileEntity_Ores && ((GT_TileEntity_Ores)tTileEntity).mNatural) {
                this.oreBlockPositions.add(blockPos);
            }
        } else {
            ItemData association = GT_OreDictUnificator.getAssociation(new ItemStack(block, 1, (int)blockMeta));
            if (association != null && association.mPrefix.toString().startsWith("ore")) {
                this.oreBlockPositions.add(blockPos);
            }
        }
    }

    protected abstract int getRadiusInChunks();

    protected abstract int getBaseProgressTime();

    protected String[] getDescriptionInternal(String tierSuffix) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        return new String[]{"Controller Block for the Ore Drilling Plant " + (tierSuffix != null ? tierSuffix : ""), "Size(WxHxD): 3x7x3, Controller (Front middle bottom)", "3x1x3 Base of " + casings, "1x3x1 " + casings + " pillar (Center of base)", "1x3x1 " + this.getFrameMaterial().mName + " Frame Boxes (Each pillar side and on top)", "1x Input Hatch for drilling fluid (Any bottom layer casing)", "1x Input Bus for mining pipes (Any bottom layer casing; not necessary)", "1x Output Bus (Any bottom layer casing)", "1x Maintenance Hatch (Any bottom layer casing)", "1x Data Access Hatch with Data Orb for endless mode(Any bottom layer; optional)", "1x " + GT_Values.VN[this.getMinTier()] + "+ Energy Hatch (Any bottom layer casing)", "Radius is " + (this.getRadiusInChunks() << 4) + " blocks"};
    }

    class OreHash {
        int min;
        int max;
        ItemStack itemStack;

        OreHash(ItemStack itst, int i, int a) {
            this.itemStack = itst;
            this.min = i;
            this.max = a;
        }

        ItemStack tryGetItem(int val) {
            return this.min < val && this.max > val ? this.itemStack : null;
        }
    }
}

