/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Pollution;
import gregtech.common.gui.GT_Container_PrimitiveBlastFurnace;
import gregtech.common.gui.GT_GUIContainer_PrimitiveBlastFurnace;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_PrimitiveBlastFurnace
extends MetaTileEntity {
    public static final int INPUT_SLOTS = 3;
    public static final int OUTPUT_SLOTS = 3;
    public int mMaxProgresstime = 0;
    public int mUpdate = 5;
    public int mProgresstime = 0;
    public boolean mMachine = false;
    public ItemStack[] mOutputItems = new ItemStack[3];
    @Deprecated
    public ItemStack mOutputItem1;
    @Deprecated
    public ItemStack mOutputItem2;

    public GT_MetaTileEntity_PrimitiveBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6);
    }

    public GT_MetaTileEntity_PrimitiveBlastFurnace(String aName) {
        super(aName, 6);
    }

    @Override
    public boolean isSteampowered() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isPneumatic() {
        return false;
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public boolean isEnetOutput() {
        return false;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        this.mProgresstime += aProgress;
        return this.mMaxProgresstime - this.mProgresstime;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone, byte aFluidFacing) {
        return this.getTexture(aBaseMetaTileEntity, aSide, aFacing, aColorIndex, aActive, aRedstone);
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return GregTech_API.getCoverBehavior(aCoverID.toStack()).isSimpleCover() && super.allowCoverOnSide(aSide, aCoverID);
    }

    @Override
    public abstract MetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        if (this.mOutputItems != null) {
            for (int i = 0; i < this.mOutputItems.length; ++i) {
                if (this.mOutputItems[i] == null) continue;
                NBTTagCompound tNBT = new NBTTagCompound();
                this.mOutputItems[i].func_77955_b(tNBT);
                aNBT.func_74782_a("mOutputItem" + i, (NBTBase)tNBT);
            }
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mUpdate = 5;
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        this.mOutputItems = new ItemStack[3];
        for (int i = 0; i < 3; ++i) {
            this.mOutputItems[i] = GT_Utility.loadItem(aNBT, "mOutputItem" + i);
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_PrimitiveBlastFurnace(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_PrimitiveBlastFurnace(aPlayerInventory, aBaseMetaTileEntity, this.getName(), GT_Recipe.GT_Recipe_Map.sPrimitiveBlastRecipes.mNEIName);
    }

    private boolean checkMachine() {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 3; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (xDir + i == 0 && j == 0 && zDir + k == 0 || !(i != 0 || j == -1 || k != 0 ? !this.isCorrectCasingBlock(this.getBaseMetaTileEntity().getBlockOffset(xDir + i, j, zDir + k)) || !this.isCorrectCasingMetaID(this.getBaseMetaTileEntity().getMetaIDOffset(xDir + i, j, zDir + k)) : !GT_Utility.arrayContains(this.getBaseMetaTileEntity().getBlockOffset(xDir + i, j, zDir + k), Blocks.field_150353_l, Blocks.field_150356_k, null) && !this.getBaseMetaTileEntity().getAirOffset(xDir + i, j, zDir + k))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected abstract boolean isCorrectCasingBlock(Block var1);

    protected abstract boolean isCorrectCasingMetaID(int var1);

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdate = 5;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            aBaseMetaTileEntity.getWorld().func_72869_a("largesmoke", (double)((float)aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1) + new XSTR().nextFloat()), (double)aBaseMetaTileEntity.getOffsetY(aBaseMetaTileEntity.getBackFacing(), 1), (double)((float)aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1) + new XSTR().nextFloat()), 0.0, 0.3, 0.0);
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mUpdate-- == 0) {
                this.mMachine = this.checkMachine();
            }
            if (this.mMachine) {
                if (this.mMaxProgresstime > 0) {
                    if (++this.mProgresstime >= this.mMaxProgresstime) {
                        this.addOutputProducts();
                        this.mOutputItems = null;
                        this.mProgresstime = 0;
                        this.mMaxProgresstime = 0;
                        GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "steel");
                    }
                } else if (aBaseMetaTileEntity.isAllowedToWork()) {
                    this.checkRecipe();
                }
            }
            if (this.mMaxProgresstime > 0 && aTimer % 20L == 0L) {
                GT_Pollution.addPollution(this.getBaseMetaTileEntity().getWorld(), new ChunkPosition(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord()), 50);
            }
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0 && this.mMachine);
            if (aBaseMetaTileEntity.isActive()) {
                if (aBaseMetaTileEntity.getAir(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1))) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
                if (aBaseMetaTileEntity.getAir(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1))) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
            } else {
                if (aBaseMetaTileEntity.getBlock(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1)) == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
                if (aBaseMetaTileEntity.getBlock(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1)) == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
            }
        }
    }

    private void addOutputProducts() {
        if (this.mOutputItems == null) {
            return;
        }
        int limit = Math.min(this.mOutputItems.length, 3);
        for (int i = 0; i < limit; ++i) {
            int absi = 3 + i;
            if (this.mInventory[absi] == null) {
                this.mInventory[absi] = GT_Utility.copy(this.mOutputItems[i]);
                continue;
            }
            if (!GT_Utility.areStacksEqual(this.mInventory[absi], this.mOutputItems[i])) continue;
            this.mInventory[absi].field_77994_a = Math.min(this.mInventory[absi].func_77976_d(), this.mInventory[absi].field_77994_a + this.mOutputItems[i].field_77994_a);
        }
    }

    private boolean spaceForOutput(ItemStack outputStack, int relativeOutputSlot) {
        int absoluteSlot = relativeOutputSlot + 3;
        if (this.mInventory[absoluteSlot] == null || outputStack == null) {
            return true;
        }
        return this.mInventory[absoluteSlot].field_77994_a + outputStack.field_77994_a <= this.mInventory[absoluteSlot].func_77976_d() && GT_Utility.areStacksEqual(this.mInventory[absoluteSlot], outputStack);
    }

    private boolean checkRecipe() {
        int i;
        if (!this.mMachine) {
            return false;
        }
        ItemStack[] inputs = new ItemStack[3];
        System.arraycopy(this.mInventory, 0, inputs, 0, 3);
        GT_Recipe recipe = GT_Recipe.GT_Recipe_Map.sPrimitiveBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, 0L, null, inputs);
        if (recipe == null) {
            this.mOutputItems = null;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (this.spaceForOutput(recipe.getOutput(i), i)) continue;
            this.mOutputItems = null;
            return false;
        }
        if (!recipe.isRecipeInputEqual(true, null, inputs)) {
            this.mOutputItems = null;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a != 0) continue;
            this.mInventory[i] = null;
        }
        this.mMaxProgresstime = recipe.mDuration;
        this.mOutputItems = recipe.mOutputs;
        return true;
    }

    @Override
    public boolean isGivingInformation() {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex > 3;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return !GT_Utility.areStacksEqual(aStack, this.mInventory[0]);
    }

    @Override
    public byte getTileEntityBaseType() {
        return 0;
    }

    public abstract String getName();
}

