/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.pumps;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Fluid;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.biome.BiomeGenSwamp;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public abstract class GT_MetaTileEntity_WaterPumpBase
extends GT_MetaTileEntity_MultiBlockBase {
    public static Map<Integer, Map<Long, GT_MetaTileEntity_WaterPumpBase>> mPumps = new HashMap<Integer, Map<Long, GT_MetaTileEntity_WaterPumpBase>>();
    public List<GT_MetaTileEntity_WaterPumpBase> mConnectedPumps = new ArrayList<GT_MetaTileEntity_WaterPumpBase>(2);
    protected List<GT_MetaPipeEntity_Fluid> mPipes = new ArrayList<GT_MetaPipeEntity_Fluid>();
    protected GT_MetaPipeEntity_Fluid mPipe = null;
    public double mPumpingEfficiency = 0.0;
    public double mEfficiencyRate = 1.0;
    protected int mWorkCycles = 0;
    public int mWaterSurface = 0;
    protected int mHeadX = 0;
    protected int mHeadY = -1;
    protected int mHeadZ = 0;
    protected int mFilledPipes = 0;
    public int mMainFacing = 2;
    protected boolean mRiver = false;
    protected boolean mOcean = false;
    protected boolean mSwamp = false;
    protected double waterToOutput = 0.0;

    public GT_MetaTileEntity_WaterPumpBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_WaterPumpBase(String aName) {
        super(aName);
    }

    public abstract int getRadius();

    public abstract int getSurfaceBlocksCount();

    public abstract int getPipeLength();

    public abstract double getOutputRate();

    public abstract int getFilterMeta();

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        this.mSolderingTool = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mCrowbar = true;
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mEfficiencyIncrease = 10000;
        return false;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mMainFacing = aNBT.func_74762_e("mMainF");
        this.mEfficiencyRate = aNBT.func_74769_h("mEffRate");
        if (this.mEfficiencyRate < 1.0E-7) {
            this.mEfficiencyRate = 1.0;
        }
        this.mWorkCycles = aNBT.func_74762_e("mCycles");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mMainF", this.mMainFacing);
        aNBT.func_74780_a("mEffRate", this.mEfficiencyRate);
        aNBT.func_74768_a("mCycles", this.mWorkCycles);
        super.saveNBTData(aNBT);
    }

    @Override
    public void onProcessEnd() {
        if (++this.mWorkCycles == 16800) {
            this.mWorkCycles = 0;
            this.mEfficiencyRate *= 0.99;
        }
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (!super.onRunningTick(aStack)) {
            return false;
        }
        double tOut = this.getOutputRate() * (this.mPumpingEfficiency / 10000.0) + this.waterToOutput;
        int rOut = (int)(tOut *= this.mEfficiencyRate);
        this.waterToOutput = tOut - (double)rOut;
        if (this.mRiver) {
            this.addOutput(GT_ModHandler.getWater(rOut));
        } else if (this.mOcean) {
            this.addOutput(Materials.SaltWater.getFluid(rOut));
        } else if (this.mSwamp) {
            this.addOutput(Materials.DirtyWater.getFluid(rOut));
        }
        return true;
    }

    public boolean checkBiome(BiomeGenBase aBiome) {
        if (aBiome instanceof BiomeGenRiver && this.mRiver) {
            return true;
        }
        if (aBiome instanceof BiomeGenOcean && this.mOcean) {
            return true;
        }
        return aBiome instanceof BiomeGenSwamp && this.mSwamp;
    }

    @Override
    public boolean addOutput(FluidStack aLiquid) {
        while (this.mFilledPipes < this.mPipes.size() && aLiquid.amount > 0) {
            GT_MetaPipeEntity_Fluid tPipe = this.mPipes.get(this.mFilledPipes);
            int aConsume = tPipe.fill_default(ForgeDirection.DOWN, aLiquid, true);
            if (aConsume <= 0) {
                ++this.mFilledPipes;
            }
            aLiquid.amount -= aConsume;
        }
        if (this.mFilledPipes == this.mPipes.size()) {
            int aConsume = this.mPipe.fill_default(ForgeDirection.DOWN, aLiquid, true);
            if (aConsume <= 0) {
                ++this.mFilledPipes;
            }
            return true;
        }
        return super.addOutput(aLiquid);
    }

    public boolean constructStructure(byte aDir) {
        IGregTechTileEntity tBase = this.getBaseMetaTileEntity();
        TileEntity[] tTiles = new TileEntity[]{tBase.getTileEntityAtSide(aDir), tBase.getTileEntityAtSide((byte)1), tBase.getTileEntityOffset(ForgeDirection.getOrientation((int)aDir).offsetX, 1, ForgeDirection.getOrientation((int)aDir).offsetZ)};
        if (!this.addToStructure(tTiles[0], tTiles[1], tTiles[2], false)) {
            return false;
        }
        return this.addToStructure(tTiles[0], tTiles[1], tTiles[2], true);
    }

    public abstract boolean addToStructure(TileEntity var1, TileEntity var2, TileEntity var3, boolean var4);

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        GT_MetaPipeEntity_Fluid qPipe;
        this.mSolderingTool = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mCrowbar = true;
        this.mWrench = true;
        this.mScrewdriver = true;
        byte tDir = -1;
        for (byte i = 2; i < 6; i = (byte)(i + 1)) {
            if (i == aBaseMetaTileEntity.getFrontFacing() || !this.constructStructure(i)) continue;
            tDir = i;
            break;
        }
        if (tDir == -1 || tDir == this.mMainFacing || aBaseMetaTileEntity.getFrontFacing() == this.mMainFacing) {
            return false;
        }
        TileEntity aPipe = aBaseMetaTileEntity.getTileEntityAtSide((byte)1);
        if (aPipe instanceof IGregTechTileEntity && ((IGregTechTileEntity)aPipe).getMetaTileEntity() instanceof GT_MetaPipeEntity_Fluid) {
            qPipe = (GT_MetaPipeEntity_Fluid)((IGregTechTileEntity)aPipe).getMetaTileEntity();
            qPipe.mStructurePart = true;
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                qPipe.disconnect(i);
            }
        } else {
            return false;
        }
        qPipe.connect((byte)0);
        qPipe.connect(tDir);
        this.mPipe = qPipe;
        this.mPipes.clear();
        TileEntity tile = aBaseMetaTileEntity.getTileEntityAtSide((byte)this.mMainFacing);
        GT_MetaPipeEntity_Fluid tPipe = null;
        if (tile instanceof IGregTechTileEntity && ((IGregTechTileEntity)tile).getMetaTileEntity() instanceof GT_MetaPipeEntity_Fluid && ((GT_MetaPipeEntity_Fluid)((IGregTechTileEntity)tile).getMetaTileEntity()).isConnectedAtSide(GT_Utility.getOppositeSide(this.mMainFacing))) {
            tPipe = (GT_MetaPipeEntity_Fluid)((IGregTechTileEntity)tile).getMetaTileEntity();
        }
        if (tPipe == null) {
            return false;
        }
        if (!this.checkHead(this.mPipes, 0, tPipe, this.mMainFacing)) {
            return false;
        }
        for (GT_MetaPipeEntity_Fluid pipe : this.mPipes) {
            pipe.mStructurePart = true;
        }
        int aX = this.getHeadX();
        int aZ = this.getHeadZ();
        BiomeGenBase tBiome = aBaseMetaTileEntity.getWorld().func_72807_a(aX, aZ);
        if (tBiome instanceof BiomeGenRiver) {
            this.mRiver = true;
        } else if (tBiome instanceof BiomeGenOcean) {
            this.mOcean = true;
        } else if (tBiome instanceof BiomeGenSwamp) {
            this.mSwamp = true;
        } else {
            return false;
        }
        this.mConnectedPumps.clear();
        ArrayList<GT_MetaTileEntity_WaterPumpBase> tAffectedPumps = new ArrayList<GT_MetaTileEntity_WaterPumpBase>();
        this.mWaterSurface = 0;
        mPumps.computeIfAbsent(aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g, k -> new HashMap());
        this.fillList(tAffectedPumps, new HashSet<Long>(), this.getHeadX(), this.getHeadZ(), 0);
        for (GT_MetaTileEntity_WaterPumpBase p : tAffectedPumps) {
            if (Math.abs(this.getHeadX() - p.getHeadX()) > 4 || Math.abs(this.getHeadZ() - p.getHeadZ()) > 4) continue;
            return false;
        }
        for (GT_MetaTileEntity_WaterPumpBase pump : tAffectedPumps) {
            pump.onAdded(this);
        }
        mPumps.get(aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g).put(this.getCoordID(aX, aZ), this);
        this.mConnectedPumps.addAll(tAffectedPumps);
        this.recalculateEfficiency();
        return true;
    }

    public boolean checkHead(List<GT_MetaPipeEntity_Fluid> aPipes, int aDepth, GT_MetaPipeEntity_Fluid aCurrentNode, int aSide) {
        if (aDepth > this.getPipeLength()) {
            return false;
        }
        if ((double)aCurrentNode.mCapacity < this.getOutputRate()) {
            return false;
        }
        byte tSide = GT_Utility.getOppositeSide(aSide);
        int nextSide = -1;
        int tConnections = 0;
        for (byte i = 0; i < 6; ++i) {
            if (!aCurrentNode.isConnectedAtSide(i)) continue;
            if (i != tSide) {
                nextSide = i;
            }
            ++tConnections;
        }
        if (tConnections > 2) {
            return false;
        }
        TileEntity tTile = aCurrentNode.getBaseMetaTileEntity().getTileEntityAtSide((byte)nextSide);
        if (tTile instanceof IGregTechTileEntity && ((IGregTechTileEntity)tTile).getMetaTileEntity() instanceof GT_MetaPipeEntity_Fluid) {
            if (this.checkHead(aPipes, ++aDepth, (GT_MetaPipeEntity_Fluid)((IGregTechTileEntity)tTile).getMetaTileEntity(), nextSide)) {
                aPipes.add(aCurrentNode);
                return true;
            }
            aCurrentNode.mStructurePart = false;
        }
        int tOccurrences = 0;
        byte sSide = -1;
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (aCurrentNode.getBaseMetaTileEntity().getBlockAtSide(i) != GregTech_API.sBlockCasings8 || aCurrentNode.getBaseMetaTileEntity().getMetaIDAtSide(i) != this.getFilterMeta()) continue;
            tOccurrences = (byte)(tOccurrences + 1);
            sSide = i;
        }
        if (tOccurrences == 1) {
            this.mHeadX = aCurrentNode.getBaseMetaTileEntity().getOffsetX(sSide, 1);
            this.mHeadY = aCurrentNode.getBaseMetaTileEntity().getOffsetY(sSide, 1);
            this.mHeadZ = aCurrentNode.getBaseMetaTileEntity().getOffsetZ(sSide, 1);
            aPipes.add(aCurrentNode);
            aCurrentNode.mStructurePart = true;
            aCurrentNode.connect(sSide);
            return true;
        }
        return false;
    }

    @Override
    public int getCapacity() {
        return 1;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        if (aSide.ordinal() != this.getBaseMetaTileEntity().getFrontFacing() && aSide.ordinal() == this.mMainFacing || aSide == ForgeDirection.UP) {
            return super.getTankInfo(aSide);
        }
        return new FluidTankInfo[0];
    }

    public int getMaxPipeLength() {
        return 10;
    }

    public void fillList(ArrayList<GT_MetaTileEntity_WaterPumpBase> aAffectedPumps, HashSet<Long> aPassedPositions, int aX, int aZ, int aDepth) {
        if (Math.abs(this.getHeadX() - aX) > this.getRadius() || Math.abs(this.getHeadZ() - aZ) > this.getRadius() || aDepth > 128) {
            return;
        }
        long tPosition = this.getCoordID(aX, aZ);
        World tWorld = this.getBaseMetaTileEntity().getWorld();
        if (aDepth != 0 && (aPassedPositions.contains(tPosition) || !this.checkBiome(tWorld.func_72807_a(aX, aZ)) || tWorld.func_147439_a(aX, this.getHeadY(), aZ) != Blocks.field_150355_j && (tWorld.func_147439_a(aX, this.getHeadY(), aZ) != GregTech_API.sBlockCasings8 || tWorld.func_72805_g(aX, this.getHeadY(), aZ) < 10))) {
            return;
        }
        ++this.mWaterSurface;
        aPassedPositions.add(tPosition);
        ++aDepth;
        GT_MetaTileEntity_WaterPumpBase tPumpInChunk = mPumps.get(tWorld.field_73011_w.field_76574_g).get(tPosition);
        if (tPumpInChunk != null && tPumpInChunk != this) {
            aAffectedPumps.add(tPumpInChunk);
        }
        this.fillList(aAffectedPumps, aPassedPositions, aX + 1, aZ, aDepth);
        this.fillList(aAffectedPumps, aPassedPositions, aX, aZ + 1, aDepth);
        this.fillList(aAffectedPumps, aPassedPositions, aX - 1, aZ, aDepth);
        this.fillList(aAffectedPumps, aPassedPositions, aX, aZ - 1, aDepth);
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        for (GT_MetaTileEntity_WaterPumpBase d : this.mConnectedPumps) {
            d.onRemoved(this);
        }
        for (GT_MetaPipeEntity_Fluid tPipe : this.mPipes) {
            tPipe.mStructurePart = false;
        }
        if (this.mPipe != null) {
            this.mPipe.mStructurePart = false;
        }
        if (mPumps.get(this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g) != null) {
            mPumps.get(this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g).remove(this.getCoordID(this.getHeadX(), this.getHeadZ()));
        }
    }

    @Override
    public void onChunkUnload() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.onRemoval();
        }
    }

    @Override
    public boolean onWrenchRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!aPlayer.func_70093_af()) {
            if (aWrenchingSide > 1 && this.getBaseMetaTileEntity().isServerSide()) {
                this.mMainFacing = aWrenchingSide;
                this.getBaseMetaTileEntity().sendBlockEvent((byte)1, (byte)this.mMainFacing);
                GregTech_API.causeMachineUpdate(this.getBaseMetaTileEntity().getWorld(), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
                return true;
            }
        } else if (this.getBaseMetaTileEntity().isValidFacing(aWrenchingSide)) {
            this.getBaseMetaTileEntity().setFrontFacing(aWrenchingSide);
            return true;
        }
        return false;
    }

    @Override
    public void onValueUpdate(byte aValue) {
        if (aValue != this.mMainFacing) {
            this.mMainFacing = aValue;
            this.getBaseMetaTileEntity().rebakeMap();
        }
    }

    @Override
    public void sendClientData() {
        super.sendClientData();
        this.getBaseMetaTileEntity().sendBlockEvent((byte)1, (byte)this.mMainFacing);
    }

    public abstract ITexture getBaseTexture();

    public abstract IIconContainer getInputFacing();

    public abstract IIconContainer[] getFacings();

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{this.getBaseTexture(), new GT_RenderedTexture(this.getFacings()[aActive ? 0 : 1])};
        }
        if (aSide == this.mMainFacing) {
            return new ITexture[]{this.getBaseTexture(), new GT_RenderedTexture(this.getInputFacing())};
        }
        return new ITexture[]{this.getBaseTexture()};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public long maxEUStore() {
        return 0L;
    }

    @Override
    public void onServerStart() {
        mPumps.clear();
    }

    public int getHeadX() {
        return this.mHeadX;
    }

    public int getHeadY() {
        return this.mHeadY;
    }

    public int getHeadZ() {
        return this.mHeadZ;
    }

    public boolean onAdded(GT_MetaTileEntity_WaterPumpBase aNewPump) {
        if (this.mConnectedPumps.contains(aNewPump) && aNewPump.getBaseMetaTileEntity() != null && !aNewPump.getBaseMetaTileEntity().isDead()) {
            return false;
        }
        this.mConnectedPumps.add(aNewPump);
        this.recalculateEfficiency();
        return true;
    }

    public void onRemoved(GT_MetaTileEntity_WaterPumpBase aPump) {
        this.mConnectedPumps.remove(aPump);
        this.recalculateEfficiency();
    }

    public void recalculateEfficiency() {
        this.mPumpingEfficiency = 10000.0;
        if (this.mConnectedPumps.size() > 0) {
            this.mPumpingEfficiency *= 1.0 / ((double)this.mConnectedPumps.size() + 1.0);
        }
        if (this.mWaterSurface < this.getSurfaceBlocksCount()) {
            this.mPumpingEfficiency *= (double)this.mWaterSurface / (double)this.getSurfaceBlocksCount();
        }
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Progress: ", this.mProgresstime / 20 + " secs", "Efficiency: ", (int)(this.mPumpingEfficiency / 100.0) + "." + (int)this.mPumpingEfficiency % 100 + "%", "Intake efficiency: ", (int)(this.mEfficiencyRate * 100.0) + "." + (int)(this.mEfficiencyRate * 1000.0) % 100 + "%", "Water surface covered: ", Math.min(this.getSurfaceBlocksCount(), this.mWaterSurface) + "/" + this.getSurfaceBlocksCount() + " blocks", "Pumps: ", (int)(this.getOutputRate() * (this.mPumpingEfficiency / 10000.0) + this.waterToOutput) + "L of Water", "Uses: ", this.getConsumptionDescription()};
    }

    protected abstract String getConsumptionDescription();

    protected long getCoordID(int aX, int aZ) {
        return (long)aX << 32 | (long)aZ & 0xFFFFFFFFL;
    }
}

