/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.common.Optional;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.AE2DigitalChestHandler;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_QuantumChest;
import gregtech.common.gui.GT_GUIContainer_QuantumChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

@Optional.Interface(iface="appeng.api.storage.IMEInventory", modid="appliedenergistics2")
public abstract class GT_MetaTileEntity_DigitalChestBase
extends GT_MetaTileEntity_TieredMachineBlock
implements IMEInventory<IAEItemStack> {
    public GT_MetaTileEntity_DigitalChestBase(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "This Chest stores " + GT_MetaTileEntity_DigitalChestBase.CommonSizeCompute(aTier) + " Blocks", new ITexture[0]);
    }

    public GT_MetaTileEntity_DigitalChestBase(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_DigitalChestBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_QuantumChest(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_QuantumChest(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            if (this.getItemCount() <= 0) {
                this.setItemStack(null);
                this.setItemCount(0);
            }
            if (this.getItemStack() == null && this.mInventory[0] != null) {
                this.setItemStack(this.mInventory[0].func_77946_l());
            }
            int count = this.getItemCount();
            ItemStack stack = this.getItemStack();
            if (this.mInventory[0] != null && count < this.getMaxItemCount() && GT_Utility.areStacksEqual(this.mInventory[0], stack)) {
                if ((count += this.mInventory[0].field_77994_a) > this.getMaxItemCount()) {
                    this.mInventory[0].field_77994_a = count - this.getMaxItemCount();
                    count = this.getMaxItemCount();
                } else {
                    this.mInventory[0] = null;
                }
            }
            if (this.mInventory[1] == null && stack != null) {
                this.mInventory[1] = stack.func_77946_l();
                this.mInventory[1].field_77994_a = Math.min(stack.func_77976_d(), count);
                count -= this.mInventory[1].field_77994_a;
            } else if (count > 0 && GT_Utility.areStacksEqual(this.mInventory[1], stack) && this.mInventory[1].func_77976_d() > this.mInventory[1].field_77994_a) {
                int tmp = Math.min(count, this.mInventory[1].func_77976_d() - this.mInventory[1].field_77994_a);
                this.mInventory[1].field_77994_a += tmp;
                count -= tmp;
            }
            this.setItemCount(count);
            if (stack != null) {
                this.mInventory[2] = stack.func_77946_l();
                this.mInventory[2].field_77994_a = Math.min(stack.func_77976_d(), count);
            } else {
                this.mInventory[2] = null;
            }
        }
    }

    protected abstract int getItemCount();

    @Override
    public abstract void setItemCount(int var1);

    protected abstract ItemStack getItemStack();

    protected abstract void setItemStack(ItemStack var1);

    @Override
    public int getProgresstime() {
        return this.getItemCount() + (this.mInventory[0] == null ? 0 : this.mInventory[0].field_77994_a) + (this.mInventory[1] == null ? 0 : this.mInventory[1].field_77994_a);
    }

    @Override
    public int maxProgresstime() {
        return this.getMaxItemCount();
    }

    protected static int CommonSizeCompute(int tier) {
        switch (tier) {
            case 1: {
                return 4000000;
            }
            case 2: {
                return 8000000;
            }
            case 3: {
                return 16000000;
            }
            case 4: {
                return 32000000;
            }
            case 5: {
                return 64000000;
            }
            case 6: {
                return 128000000;
            }
            case 7: {
                return 256000000;
            }
            case 8: {
                return 512000000;
            }
            case 9: {
                return 1024000000;
            }
            case 10: {
                return 0x7FFFFFF8;
            }
        }
        return 0;
    }

    @Override
    public int getMaxItemCount() {
        return GT_MetaTileEntity_DigitalChestBase.CommonSizeCompute(this.mTier);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 0 && (this.mInventory[0] == null || GT_Utility.areStacksEqual(this.mInventory[0], aStack));
    }

    protected abstract String chestName();

    @Optional.Method(modid="appliedenergistics2")
    public static void registerAEIntegration() {
        AEApi.instance().registries().externalStorage().addExternalStorageInterface((IExternalStorageHandler)new AE2DigitalChestHandler());
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mItemCount", this.getItemCount());
        if (this.getItemStack() != null) {
            aNBT.func_74782_a("mItemStack", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mItemCount")) {
            this.setItemCount(aNBT.func_74762_e("mItemCount"));
        }
        if (aNBT.func_74764_b("mItemStack")) {
            this.setItemStack(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)aNBT.func_74781_a("mItemStack"))));
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aBaseMetaTileEntity.getFrontFacing() == 0 && aSide == 4) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_QCHEST)};
        }
        if (aSide == aBaseMetaTileEntity.getFrontFacing()) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_QCHEST);
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
        }
        return iTextureArray;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    @Override
    public String[] getInfoData() {
        if (this.getItemStack() == null) {
            return new String[]{EnumChatFormatting.RESET + this.chestName() + EnumChatFormatting.RESET, "Stored Items:", EnumChatFormatting.RED + "0" + EnumChatFormatting.RESET, "Total Items:", EnumChatFormatting.YELLOW + Integer.toString(this.getMaxItemCount()) + EnumChatFormatting.RESET};
        }
        return new String[]{EnumChatFormatting.RESET + this.chestName() + EnumChatFormatting.RESET, "Stored Items:", EnumChatFormatting.GREEN + Integer.toString(this.getItemCount()) + EnumChatFormatting.RESET, "Total Items:", EnumChatFormatting.YELLOW + Integer.toString(this.getMaxItemCount()) + EnumChatFormatting.RESET};
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        ItemStack inputStack = input.getItemStack();
        if (inputStack == null) {
            return null;
        }
        ItemStack storedStack = this.getItemStack();
        if (storedStack != null) {
            if (GT_Utility.areStacksEqual(storedStack, inputStack)) {
                if (input.getStackSize() + (long)this.getItemCount() > (long)this.getMaxItemCount()) {
                    return this.createOverflowStack(input.getStackSize() + (long)this.getItemCount(), mode);
                }
                if (mode != Actionable.SIMULATE) {
                    this.setItemCount(this.getItemCount() + (int)input.getStackSize());
                }
                return null;
            }
            return input;
        }
        if (mode != Actionable.SIMULATE) {
            this.setItemStack(inputStack.func_77946_l());
        }
        if (input.getStackSize() > (long)this.getMaxItemCount()) {
            return this.createOverflowStack(input.getStackSize(), mode);
        }
        if (mode != Actionable.SIMULATE) {
            this.setItemCount((int)input.getStackSize());
        }
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    private IAEItemStack createOverflowStack(long size, Actionable mode) {
        AEItemStack overflow = AEItemStack.create((ItemStack)this.getItemStack());
        overflow.setStackSize(size - (long)this.getMaxItemCount());
        if (mode != Actionable.SIMULATE) {
            this.setItemCount(this.getMaxItemCount());
        }
        return overflow;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (request.equals(this.getItemStack())) {
            if (request.getStackSize() >= (long)this.getItemCount()) {
                AEItemStack result = AEItemStack.create((ItemStack)this.getItemStack());
                result.setStackSize((long)this.getItemCount());
                if (mode != Actionable.SIMULATE) {
                    this.setItemCount(0);
                }
                return result;
            }
            if (mode != Actionable.SIMULATE) {
                this.setItemCount(this.getItemCount() - (int)request.getStackSize());
            }
            return request.copy();
        }
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        ItemStack storedStack = this.getItemStack();
        if (storedStack != null) {
            AEItemStack s = AEItemStack.create((ItemStack)storedStack);
            s.setStackSize((long)this.getItemCount());
            out.add((IAEStack)s);
        }
        return out;
    }
}

