/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import gregtech.api.util.GT_LanguageManager;
import gregtech.common.blocks.GT_Item_Ores;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;

public class OreCollection
implements Comparator<OreCollection> {
    String oreName;
    String oreFlow;
    int oreCount;

    public OreCollection() {
    }

    public OreCollection(String oreName, int oreCount, String oreFlow) {
        this.oreName = oreName;
        this.oreCount = oreCount;
        this.oreFlow = oreFlow;
    }

    @Override
    public int compare(OreCollection a, OreCollection b) {
        return b.oreCount - a.oreCount;
    }

    public static String getText(String unlocText) {
        StringBuffer sb = new StringBuffer();
        if ("underBrOresMainTitle" == unlocText) {
            sb.append(EnumChatFormatting.WHITE);
            sb.append("     ");
            sb.append(GT_LanguageManager.getTranslation("underBrOresMainTitle1"));
            sb.append("\n     ");
            sb.append(GT_LanguageManager.getTranslation("underBrOresMainTitle2"));
            sb.append(EnumChatFormatting.RESET);
            return sb.toString();
        }
        if ("warningLabel" == unlocText) {
            sb.append(EnumChatFormatting.RED);
            sb.append("     ");
            sb.append(GT_LanguageManager.getTranslation("warningLabel"));
            sb.append("! ");
            sb.append(EnumChatFormatting.RESET);
            return sb.toString();
        }
        if ("underBrWarningLabel" == unlocText) {
            return GT_LanguageManager.getTranslation("DataOrb.Miner.Warning");
        }
        if ("minedOresCountLabel" == unlocText) {
            return GT_LanguageManager.getTranslation("minedOresCount");
        }
        if ("underBrOresFlowLabel2" == unlocText) {
            sb.append(EnumChatFormatting.DARK_GRAY);
            sb.append("   ");
            sb.append(GT_LanguageManager.getTranslation("DataOrb.Miner.ubFlow"));
            sb.append("\n   ");
            sb.append(GT_LanguageManager.getTranslation("DataOrb.Miner.onMv"));
            sb.append("\n   ");
            sb.append(GT_LanguageManager.getTranslation("DataOrb.Miner.oresEachHour"));
            sb.append(':');
            sb.append(EnumChatFormatting.RESET);
            return sb.toString();
        }
        if ("minedOreTypesCountLabel" == unlocText) {
            return GT_LanguageManager.getTranslation("minedOreTypesCount");
        }
        return unlocText;
    }

    public static NBTTagCompound getRawOresData(ArrayList<OreCollection> aList) {
        NBTTagCompound oreTag = new NBTTagCompound();
        for (int i = 0; i < aList.size(); ++i) {
            oreTag.func_74778_a("oreName" + i, aList.get((int)i).oreName);
            oreTag.func_74768_a("oreCount" + i, aList.get((int)i).oreCount);
            oreTag.func_74778_a("oreFlow" + i, aList.get((int)i).oreFlow);
        }
        return oreTag;
    }

    public static ArrayList<OreCollection> getCollectionFromNbt(NBTTagCompound nbt) {
        ArrayList<OreCollection> aList = new ArrayList<OreCollection>();
        int oreTypesCount = nbt.func_74762_e("minerOreTypesCount");
        NBTTagCompound rawOresData = nbt.func_74775_l("rawOresData");
        for (int i = 0; i < oreTypesCount; ++i) {
            OreCollection oreCol = new OreCollection(rawOresData.func_74779_i("oreName" + i), rawOresData.func_74762_e("oreCount" + i), rawOresData.func_74779_i("oreFlow" + i));
            aList.add(oreCol);
        }
        return aList;
    }

    public static String getTranslatedOreName(String unlockOreName) {
        if (unlockOreName.indexOf("gt.blockores.") == 0) {
            String gtOreId = unlockOreName.replaceAll(".+\\.", "");
            return new ItemStack(GT_Item_Ores.func_150899_d((int)1095), 1, Integer.valueOf(gtOreId).intValue()).func_82833_r();
        }
        return GT_LanguageManager.getTranslation(unlockOreName);
    }

    public static NBTTagList getTooltipLines(ArrayList<OreCollection> aList, int totalBlocksCount, int oreTypesCount) {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append(OreCollection.getText("underBrOresMainTitle"));
        sBuf.append("\n\n");
        sBuf.append(OreCollection.getText("warningLabel"));
        sBuf.append(OreCollection.getText("underBrWarningLabel"));
        sBuf.append("\n\n");
        sBuf.append("     ");
        sBuf.append(EnumChatFormatting.DARK_GREEN + OreCollection.getText("minedOresCountLabel"));
        sBuf.append(" ");
        sBuf.append(EnumChatFormatting.AQUA);
        sBuf.append(totalBlocksCount);
        sBuf.append("\n\n     ");
        sBuf.append(EnumChatFormatting.DARK_GREEN);
        sBuf.append(OreCollection.getText("minedOreTypesCountLabel"));
        sBuf.append(" ");
        sBuf.append(EnumChatFormatting.AQUA);
        sBuf.append(oreTypesCount);
        sBuf.append(EnumChatFormatting.RESET);
        ArrayList<String> pages = new ArrayList<String>();
        pages.add(sBuf.toString());
        NBTTagList tTagList = new NBTTagList();
        Collections.sort(aList, new OreCollection());
        StringBuffer lineSb = new StringBuffer();
        for (int i = 0; i < aList.size(); ++i) {
            String tempLine = EnumChatFormatting.GRAY + OreCollection.getTranslatedOreName(aList.get((int)i).oreName) + " " + EnumChatFormatting.AQUA + aList.get((int)i).oreFlow;
            if (lineSb.length() == 0) {
                lineSb.append(OreCollection.getText("underBrOresFlowLabel2"));
                lineSb.append("\n\n");
                lineSb.append("  ");
                lineSb.append(tempLine);
                continue;
            }
            if (i % 7 == 6) {
                lineSb.append("\n\n  ");
                lineSb.append(tempLine);
                pages.add(lineSb.toString());
                lineSb = new StringBuffer();
                continue;
            }
            lineSb.append("\n\n  ");
            lineSb.append(tempLine);
            if (i != aList.size() - 1) continue;
            pages.add(lineSb.toString());
        }
        int idx = 0;
        for (String str : pages) {
            sBuf = new StringBuffer();
            sBuf.append(EnumChatFormatting.GRAY);
            sBuf.append("                         ");
            sBuf.append(idx + 1);
            sBuf.append(" / ");
            sBuf.append(pages.size());
            sBuf.append(EnumChatFormatting.RESET);
            sBuf.append("\n\n");
            sBuf.append(str);
            tTagList.func_74742_a((NBTBase)new NBTTagString(sBuf.toString()));
            ++idx;
        }
        return tTagList;
    }
}

