/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.preload;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import gregtech.api.interfaces.internal.IGT_Config;
import gregtech.common.config.GT_DebugConfig;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class GT_LoaderConfig
implements Runnable {
    static List<Class<? extends IGT_Config>> configList = Arrays.asList(GT_DebugConfig.class);
    FMLPreInitializationEvent event;

    public GT_LoaderConfig(FMLPreInitializationEvent event) {
        this.event = event;
    }

    @Override
    public void run() {
        for (Class<? extends IGT_Config> cl : configList) {
            try {
                this.load(cl);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("failed loading configs, please check your config class signature", e);
            }
        }
    }

    private void load(Class<? extends IGT_Config> configClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        IGT_Config configObject = configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        String configName = (String)configClass.getMethod("getName", new Class[0]).invoke((Object)configObject, new Object[0]);
        Configuration configuration = this.loadConfiguration(configName);
        configClass.getMethod("load", Configuration.class).invoke((Object)configObject, configuration);
        configuration.save();
    }

    private Configuration loadConfiguration(String fileName) {
        File file = new File(new File(this.event.getModConfigurationDirectory(), "GregTech"), fileName + ".cfg");
        Configuration config = new Configuration(file);
        config.load();
        return config;
    }
}

