/*
 * Decompiled with CFR 0.152.
 */
package idealindustrial;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import idealindustrial.commands.CommandFixMaterials;
import idealindustrial.commands.CommandFixQuests;
import idealindustrial.commands.DimTPCommand;
import idealindustrial.commands.ReloadRecipesCommand;
import idealindustrial.integration.ingameinfo.InGameInfoLoader;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import net.minecraft.command.ICommand;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

@Mod(modid="iicore", name="II_Core", version="MC1710", useMetadata=false, dependencies="after:gregtech")
public class II_Core {
    private static final String PACKAGES_URL = "https://github.com/IdealIndustrial/GT5Unofficial/packages/2134484";
    private static final Pattern PARSE_PATTERN = Pattern.compile("gt-ii-edition-(.*?)-.*?-(\\d+).jar", 8);
    private static final String PROPERTY_VERSION_URL = "/version.properties";
    private static final String version = "1.19.2";
    private String auto_version = "??";
    private String auto_build = "??";
    private String auto_last_version = null;
    private String auto_last_build = null;
    private String first_line = "Current version: %1$s-%2$s";
    private String second_line = "Latest dev build: %1$s-%2$s";

    public II_Core() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void onPreLoad(FMLPreInitializationEvent aEvent) {
        if (!II_Core.checkEnvironment()) {
            CrashReport tCrashReport = new CrashReport("Wrong enviroment detected, please install BQfix for thermos: https://github.com/IdealIndustrial/Ideal-Industrial-Quests", (Throwable)new RuntimeException("no fix for better questing is detected"));
            throw new ReportedException(tCrashReport);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"InGameInfoXML") && FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            new InGameInfoLoader().load();
        }
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
    }

    private static boolean checkEnvironment() {
        try {
            Class.forName("thermos.Thermos");
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        try {
            Class.forName("betterquesting.core.BetterQuesting");
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        try {
            Class.forName("a.b.c.gambiarra.Plugin");
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.juanmuscaria.playercontainerfix.FMLCoreMod");
            }
            catch (ClassNotFoundException f) {
                return false;
            }
        }
        return true;
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent aEvent) {
        aEvent.registerServerCommand((ICommand)new CommandFixQuests());
        aEvent.registerServerCommand((ICommand)new DimTPCommand());
        aEvent.registerServerCommand((ICommand)new ReloadRecipesCommand());
    }

    @Mod.EventHandler
    private void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        File iiSaveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "IIM");
        if (!iiSaveDir.isDirectory() && !iiSaveDir.mkdir()) {
            throw new IllegalStateException("Cannot create IIM save folder");
        }
        try {
            CommandFixMaterials.loadWorld(iiSaveDir);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static String getVersion() {
        return version;
    }
}

