/*
 * Decompiled with CFR 0.152.
 */
package idealindustrial.commands;

import gloomyfolken.hooklib.minecraft.HookLibPlugin;
import gregtech.api.items.GT_MetaGenerated_Item;
import idealindustrial.hooks.HookLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Stream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandFixMaterials
extends CommandBase {
    private static boolean executing;
    private static int executeState;
    private static final Map<Integer, Integer> subIDsMap;
    private static boolean wasExecutedAlready;
    private static File fileSave;

    public int func_82362_a() {
        return 4;
    }

    public String func_71517_b() {
        return "fixMaterials";
    }

    public void func_71515_b(ICommandSender ics, String[] args) {
        Method saveEverything;
        if (!HookLoader.gtMats) {
            ics.func_145747_a((IChatComponent)new ChatComponentText("First enable GT materials remap in II_Patches.cfg"));
            return;
        }
        if (wasExecutedAlready) {
            ics.func_145747_a((IChatComponent)new ChatComponentText("Materials were already fixed"));
            return;
        }
        try {
            saveEverything = HookLibPlugin.getObfuscated() ? MinecraftServer.class.getDeclaredMethod("func_71267_a", Boolean.TYPE) : MinecraftServer.class.getDeclaredMethod("saveAllWorlds", Boolean.TYPE);
            saveEverything.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            ics.func_145747_a((IChatComponent)new ChatComponentText("Something went wrong, may be you're using patched minecraft server"));
            e.printStackTrace();
            return;
        }
        executing = true;
        executeState = 1;
        System.out.println("patches injected, saving all worlds");
        try {
            saveEverything.invoke((Object)MinecraftServer.func_71276_C(), false);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("failed to save all", e);
        }
        MinecraftServer.func_71276_C().func_71203_ab().func_72389_g();
        System.out.println("removing dummy tags from items");
        executeState = 2;
        try {
            saveEverything.invoke((Object)MinecraftServer.func_71276_C(), false);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("failed to save all", e);
        }
        MinecraftServer.func_71276_C().func_71203_ab().func_72389_g();
        System.out.println("remapped items successfully");
        executeState = 0;
        executing = false;
        wasExecutedAlready = true;
        try {
            CommandFixMaterials.writeFile(fileSave, true);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static boolean isExecuting() {
        return executing;
    }

    public static NBTTagCompound processStack(ItemStack stack, NBTTagCompound nbt) {
        if (executeState == 1) {
            if (stack != null && stack.func_77973_b() instanceof GT_MetaGenerated_Item && subIDsMap.containsKey(stack.func_77960_j() % 1000) && (nbt == null || !nbt.func_74767_n("Passed"))) {
                int meta = stack.func_77960_j();
                int rightSubID = subIDsMap.get(meta % 1000);
                meta -= meta % 1000;
                stack.func_77964_b(meta += rightSubID);
                nbt.func_74777_a("Damage", (short)meta);
                nbt.func_74757_a("Passed", true);
            }
            return nbt;
        }
        if (executeState == 2 && nbt != null && nbt.func_74767_n("Passed")) {
            nbt.func_82580_o("Passed");
        }
        return nbt;
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "fixes enderio gt material IDs";
    }

    public static void loadWorld(File iiDirectory) throws IOException {
        File worldSettings = new File(iiDirectory, "server.txt");
        if (!worldSettings.exists()) {
            try {
                worldSettings.createNewFile();
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return;
            }
            CommandFixMaterials.writeFile(worldSettings, false);
        }
        Scanner scanner = new Scanner(worldSettings);
        try {
            wasExecutedAlready = Boolean.parseBoolean(scanner.nextLine().split("=")[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandFixMaterials.writeFile(worldSettings, false);
        }
        fileSave = worldSettings;
    }

    private static void writeFile(File worldSettings, boolean wasExecutedAlready) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(worldSettings));
        writer.println("materialsFixed=" + wasExecutedAlready);
        writer.println("IIM.ver=1.17.1");
        writer.flush();
        writer.close();
    }

    static {
        executeState = 0;
        subIDsMap = new HashMap<Integer, Integer>();
        wasExecutedAlready = false;
        Stream.of("381->379", "379->380", "365->368", "380->381").map(str -> str.split("->")).forEach(strings -> subIDsMap.put(Integer.parseInt(strings[0]), Integer.parseInt(strings[1])));
    }
}

