/*
 * Decompiled with CFR 0.152.
 */
package idealindustrial.commands;

import codechicken.nei.recipe.ShapedRecipeHandler;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.nei.GT_NEI_DefaultHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ReloadRecipesCommand
extends CommandBase {
    private static final List<Class<? extends Runnable>> runnableLoaders = new ArrayList<Class<? extends Runnable>>();
    private static final List<Class<? extends Runnable>> currentRunnableLoaders = new ArrayList<Class<? extends Runnable>>();
    private static final Map<String, Class> classMap = new HashMap<String, Class>();

    public int func_82362_a() {
        return 4;
    }

    public String func_71517_b() {
        return "rr";
    }

    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args.length == 0) {
            this.clearRecipeMaps();
            try {
                this.executeAll();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            this.invalidateNEICaches();
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("clear")) {
            currentRunnableLoaders.clear();
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("add")) {
            Class cl = classMap.get(args[1]);
            if (cl == null) {
                ics.func_145747_a((IChatComponent)new ChatComponentText("Unknown class"));
            } else if (Runnable.class.isAssignableFrom(cl)) {
                currentRunnableLoaders.add(cl);
                ics.func_145747_a((IChatComponent)new ChatComponentText("added"));
            }
        }
    }

    public List func_71516_a(ICommandSender ics, String[] args) {
        if (args.length == 1) {
            // empty if block
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("add")) {
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : classMap.keySet()) {
                if (!s.startsWith(args[1])) continue;
                ret.add(s);
            }
            return ret;
        }
        return null;
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "reload recipes /rr - reloads all recipe classes";
    }

    private void clearRecipeMaps() {
        for (GT_Recipe.GT_Recipe_Map tMap : GT_Recipe.GT_Recipe_Map.sMappings) {
            tMap.clear();
        }
        ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        tList.clear();
    }

    private void executeAll() throws IllegalAccessException, InstantiationException {
        for (Class<? extends Runnable> cl : currentRunnableLoaders) {
            Runnable runnable = cl.newInstance();
            runnable.run();
        }
    }

    private void invalidateNEICaches() {
        ShapedRecipeHandler.recipesMap.clear();
        ShapedRecipeHandler.usesMap.clear();
        try {
            Class<ShapedRecipeHandler> cl = ShapedRecipeHandler.class;
            Field rMaps = cl.getDeclaredField("recipesMap");
            Field uMaps = cl.getDeclaredField("usesMap");
            Map rM = (Map)rMaps.get(null);
            Map uM = (Map)uMaps.get(null);
            rM.clear();
            uM.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        GT_NEI_DefaultHandler.inputMaps.clear();
        GT_NEI_DefaultHandler.outputMaps.clear();
    }

    static {
        GT_ModHandler.sRecipeLoaderClasses.stream().filter(Runnable.class::isAssignableFrom).forEach(runnableLoaders::add);
        runnableLoaders.forEach(l -> classMap.put(l.getSimpleName(), (Class)l));
    }
}

