/*
 * Decompiled with CFR 0.152.
 */
package idealindustrial.hooks;

import cofh.api.energy.IEnergyContainerItem;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.power.PowerConduit;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import gloomyfolken.hooklib.asm.Hook;
import gloomyfolken.hooklib.asm.ReturnCondition;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityChargepadBlock;
import ic2.core.item.GatewayElectricItemManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class II_EUtoRFPatch {
    @Hook(injectOnExit=false, returnCondition=ReturnCondition.ALWAYS)
    public static IElectricItemManager getManager(GatewayElectricItemManager manager, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == null) {
            return null;
        }
        if (item instanceof ISpecialElectricItem) {
            return ((ISpecialElectricItem)item).getManager(stack);
        }
        if (item instanceof IEnergyContainerItem) {
            return new DummyEUtoRFCompatManager((IEnergyContainerItem)item);
        }
        return item instanceof IElectricItem ? ElectricItem.rawManager : ElectricItem.getBackupManager((ItemStack)stack);
    }

    @Hook(injectOnExit=false, returnCondition=ReturnCondition.ALWAYS)
    public static void chargeitems(TileEntityChargepadBlock block, ItemStack itemstack, int chargefactor) {
        if ((itemstack.func_77973_b() instanceof IElectricItem || itemstack.func_77973_b() instanceof IEnergyContainerItem) && itemstack.func_77973_b() != Ic2Items.debug.func_77973_b()) {
            double freeamount = ElectricItem.manager.charge(itemstack, Double.POSITIVE_INFINITY, block.tier, true, true);
            double charge = 0.0;
            if (freeamount >= 0.0) {
                charge = block.energy >= freeamount ? (freeamount >= (double)(chargefactor * 2) ? (double)(chargefactor * 2) : freeamount) : block.energy;
                block.energy -= ElectricItem.manager.charge(itemstack, charge, block.tier, true, false);
            }
        }
    }

    @Hook(injectOnExit=false, returnCondition=ReturnCondition.ALWAYS)
    public static IPowerInterface getExternalPowerReceptor(PowerConduit conduit, ForgeDirection direction) {
        TileEntity te = conduit.getBundle().getEntity();
        World world = te.func_145831_w();
        if (world == null) {
            return null;
        }
        TileEntity test = world.func_147438_o(te.field_145851_c + direction.offsetX, te.field_145848_d + direction.offsetY, te.field_145849_e + direction.offsetZ);
        if (test instanceof BaseMetaTileEntity && ((BaseMetaTileEntity)test).outputsEnergyTo((byte)direction.getOpposite().ordinal())) {
            return new DummyIPowerInterfaceImpl((BaseMetaTileEntity)test);
        }
        return test instanceof IConduitBundle ? null : PowerHandlerUtil.create((Object)test);
    }

    private static class DummyIPowerInterfaceImpl
    implements IPowerInterface {
        BaseMetaTileEntity tile;

        public DummyIPowerInterfaceImpl(BaseMetaTileEntity test) {
            this.tile = test;
        }

        public Object getDelegate() {
            return null;
        }

        public boolean canConduitConnect(ForgeDirection forgeDirection) {
            return this.tile.outputsEnergyTo((byte)forgeDirection.getOpposite().ordinal());
        }

        public int getEnergyStored(ForgeDirection forgeDirection) {
            return 0;
        }

        public int getMaxEnergyStored(ForgeDirection forgeDirection) {
            return 0;
        }

        public int getPowerRequest(ForgeDirection forgeDirection) {
            return 0;
        }

        public int getMinEnergyReceived(ForgeDirection forgeDirection) {
            return 0;
        }

        public int recieveEnergy(ForgeDirection forgeDirection, int i) {
            return 0;
        }

        public boolean isOutputOnly() {
            return true;
        }

        public boolean isInputOnly() {
            return false;
        }
    }

    private static class DummyEUtoRFCompatManager
    implements IElectricItemManager {
        private final IEnergyContainerItem item;

        public DummyEUtoRFCompatManager(IEnergyContainerItem item) {
            this.item = item;
        }

        public double charge(ItemStack is, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
            amount = Math.min(amount, (double)GT_Values.V[tier]);
            int max = this.item.getMaxEnergyStored(is);
            int cur = this.item.getEnergyStored(is);
            double canUse = Math.min(amount, (double)(max - cur));
            amount = DummyEUtoRFCompatManager.toRF(canUse);
            this.item.receiveEnergy(is, (int)amount, simulate);
            return amount;
        }

        public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
            amount = Math.min(amount, (double)GT_Values.V[tier]);
            amount = DummyEUtoRFCompatManager.toRF(amount);
            return this.item.extractEnergy(itemStack, (int)amount, simulate);
        }

        public double getCharge(ItemStack is) {
            return DummyEUtoRFCompatManager.toEU(this.item.getEnergyStored(is));
        }

        public boolean canUse(ItemStack is, double amount) {
            return this.getCharge(is) > amount;
        }

        public boolean use(ItemStack is, double amount, EntityLivingBase entity) {
            if (this.canUse(is, amount)) {
                this.item.extractEnergy(is, (int)amount, false);
                return true;
            }
            return false;
        }

        public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        }

        public String getToolTip(ItemStack itemStack) {
            return null;
        }

        private static double toRF(double eu) {
            return eu * (double)GregTech_API.mEUtoRF / 100.0;
        }

        private static double toEU(double rf) {
            return rf / (double)GregTech_API.mEUtoRF * 100.0;
        }
    }
}

