/*
 * Decompiled with CFR 0.152.
 */
package idealindustrial.hooks;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import gloomyfolken.hooklib.asm.Hook;
import gloomyfolken.hooklib.asm.ReturnCondition;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.crash.CrashReport;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S03PacketTimeUpdate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;

public class II_WorldMultithreadingPatch {
    static Field tickCounter;
    static Field configManager;
    static Field tickTime;
    static Field tickTables;

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void updateTimeLightAndEntities(MinecraftServer server) throws IllegalAccessException {
        int id;
        int id2;
        int n;
        server.field_71304_b.func_76320_a("levels");
        ChunkIOExecutor.tick();
        int tickCounter = (Integer)II_WorldMultithreadingPatch.tickCounter.get(server);
        Integer[] ids = DimensionManager.getIDs((tickCounter % 200 == 0 ? 1 : 0) != 0);
        Hashtable worldTickTimes = (Hashtable)tickTime.get(server);
        ServerConfigurationManager serverConfigurationManager = (ServerConfigurationManager)configManager.get(server);
        Integer[] integerArray = ids;
        int n2 = integerArray.length;
        for (n = 0; n < n2; ++n) {
            id2 = integerArray[n];
            II_WorldMultithreadingPatch.preEntitiesUpdateWork(serverConfigurationManager, id2, tickCounter);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>(ids.length);
        Object object = ids;
        n = ((Integer[])object).length;
        for (id2 = 0; id2 < n; ++id2) {
            id = object[id2];
            II_WorldMultithreadingPatch.startThread(worldTickTimes, tickCounter, id, threads);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        object = ids;
        n = ((Object)object).length;
        for (int i = 0; i < n; ++i) {
            id = (Integer)object[i];
            II_WorldMultithreadingPatch.postEntitiesUpdateWork(id);
        }
        server.field_71304_b.func_76318_c("dim_unloading");
        DimensionManager.unloadWorlds((Hashtable)worldTickTimes);
        server.field_71304_b.func_76318_c("connection");
        server.func_147137_ag().func_151269_c();
        server.field_71304_b.func_76318_c("players");
        serverConfigurationManager.func_72374_b();
        server.field_71304_b.func_76318_c("tickables");
        List tickables = (List)tickTables.get(server);
        for (int i = 0; i < tickables.size(); ++i) {
            ((IUpdatePlayerListBox)tickables.get(i)).func_73660_a();
        }
        server.field_71304_b.func_76319_b();
    }

    private static void preEntitiesUpdateWork(ServerConfigurationManager configurationManager, int id, int tickCounter) {
        WorldServer worldserver = DimensionManager.getWorld((int)id);
        if (tickCounter % 20 == 0) {
            configurationManager.func_148537_a((Packet)new S03PacketTimeUpdate(worldserver.func_82737_E(), worldserver.func_72820_D(), worldserver.func_82736_K().func_82766_b("doDaylightCycle")), worldserver.field_73011_w.field_76574_g);
        }
        FMLCommonHandler.instance().onPreWorldTick((World)worldserver);
    }

    private static void postEntitiesUpdateWork(int id) {
        WorldServer worldserver = DimensionManager.getWorld((int)id);
        FMLCommonHandler.instance().onPostWorldTick((World)worldserver);
        worldserver.func_73039_n().func_72788_a();
    }

    private static void startThread(Hashtable<Integer, long[]> worldTickTimes, int tickCounter, int id, List<Thread> threads) {
        Thread thread = new Thread((Runnable)new Updater(worldTickTimes, tickCounter, id), "Server thread updater-" + id);
        thread.start();
        threads.add(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateEntities(Hashtable<Integer, long[]> worldTickTimes, int tickCounter, int id) {
        long j = System.nanoTime();
        WorldServer worldserver = DimensionManager.getWorld((int)id);
        try {
            worldserver.func_72835_b();
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)"Exception ticking world");
            worldserver.func_72914_a(crashreport);
            throw new ReportedException(crashreport);
        }
        try {
            worldserver.func_72939_s();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception ticking world entities");
            worldserver.func_72914_a(crashreport);
            throw new ReportedException(crashreport);
        }
        Hashtable<Integer, long[]> hashtable = worldTickTimes;
        synchronized (hashtable) {
            worldTickTimes.get((Object)Integer.valueOf((int)id))[tickCounter % 100] = System.nanoTime() - j;
        }
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static Side getEffectiveSide(FMLCommonHandler handler) {
        Thread thr = Thread.currentThread();
        if (thr.getName().startsWith("Server thread")) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    static {
        Class<MinecraftServer> serverClass = MinecraftServer.class;
        try {
            tickCounter = serverClass.getDeclaredField("tickCounter");
            tickCounter.setAccessible(true);
            configManager = serverClass.getDeclaredField("serverConfigManager");
            configManager.setAccessible(true);
            tickTime = serverClass.getDeclaredField("worldTickTimes");
            tickTime.setAccessible(true);
            tickTables = serverClass.getDeclaredField("tickables");
            tickTables.setAccessible(true);
        }
        catch (NoSuchFieldException exception) {
            exception.printStackTrace();
        }
    }

    private static class Updater
    implements Runnable {
        Hashtable<Integer, long[]> worldTickTimes;
        int tickCounter;
        int id;

        public Updater(Hashtable<Integer, long[]> worldTickTimes, int tickCounter, int id) {
            this.worldTickTimes = worldTickTimes;
            this.tickCounter = tickCounter;
            this.id = id;
        }

        @Override
        public void run() {
            II_WorldMultithreadingPatch.updateEntities(this.worldTickTimes, this.tickCounter, this.id);
        }
    }
}

