/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.plugin.gregtech5;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtech.api.GregTech_API;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import pers.gwyog.gtneioreplugin.plugin.gregtech5.PluginGT5Base;
import pers.gwyog.gtneioreplugin.util.GT5OreSmallHelper;

public class PluginGT5SmallOreStat
extends PluginGT5Base {
    public void drawExtras(int recipe) {
        CachedOreSmallRecipe crecipe = (CachedOreSmallRecipe)((Object)this.arecipes.get(recipe));
        GT5OreSmallHelper.OreSmallWrapper oreSmall = GT5OreSmallHelper.mapOreSmallWrapper.get(crecipe.oreGenName);
        String sDimNames = GT5OreSmallHelper.bufferedDims.get(oreSmall);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.oreName", (Object[])new Object[0]) + ": " + PluginGT5SmallOreStat.getGTOreLocalizedName((short)(oreSmall.oreMeta + 16000))), (int)2, (int)18, (int)0x404040, (boolean)false);
        this.drawToolTip(sDimNames);
        if (!this.ttDisplayed) {
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.genHeight", (Object[])new Object[0]) + ": " + oreSmall.worldGenHeightRange), (int)2, (int)31, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.amount", (Object[])new Object[0]) + ": " + oreSmall.amountPerChunk), (int)2, (int)44, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.chanceDrops", (Object[])new Object[0]) + ": "), (int)2, (int)(83 + this.getRestrictBiomeOffset()), (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.worldNames", (Object[])new Object[0]) + ": "), (int)2, (int)110, (int)0x404040, (boolean)false);
            if (sDimNames.length() > 36) {
                GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + sDimNames.substring(0, 36)), (int)2, (int)120, (int)0x404040, (boolean)false);
                if (sDimNames.length() > 70) {
                    GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + sDimNames.substring(36, 70)), (int)2, (int)130, (int)0x404040, (boolean)false);
                    GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + sDimNames.substring(70, sDimNames.length() - 1)), (int)2, (int)140, (int)0x404040, (boolean)false);
                } else {
                    GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + sDimNames.substring(36, sDimNames.length() - 1)), (int)2, (int)130, (int)0x404040, (boolean)false);
                }
            } else {
                GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + sDimNames.substring(0, sDimNames.length() - 1)), (int)2, (int)120, (int)0x404040, (boolean)false);
            }
        }
        GuiDraw.drawStringR((String)(EnumChatFormatting.BOLD + I18n.func_135052_a((String)"gtnop.gui.nei.seeAll", (Object[])new Object[0])), (int)(this.getGuiWidth() - 3), (int)5, (int)0x404040, (boolean)false);
    }

    public int getRestrictBiomeOffset() {
        return GT5OreSmallHelper.restrictBiomeSupport ? 0 : -13;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOutputId())) {
            for (ItemStack stack : GT5OreSmallHelper.oreSmallList) {
                this.loadCraftingRecipes(stack);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack stack) {
        if (stack.func_77977_a().startsWith("gt.blockores")) {
            if (stack.func_77960_j() < 16000) {
                super.loadCraftingRecipes(stack);
                return;
            }
            short baseMeta = (short)(stack.func_77960_j() % 1000);
            for (GT5OreSmallHelper.OreSmallWrapper oreSmallWorldGen : GT5OreSmallHelper.mapOreSmallWrapper.values()) {
                if (oreSmallWorldGen.oreMeta != baseMeta) continue;
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                int maximumIndex = this.getMaximumMaterialIndex(baseMeta, true);
                for (int i = 0; i < maximumIndex; ++i) {
                    stackList.add(new ItemStack(GregTech_API.sBlockOres1, 1, oreSmallWorldGen.oreMeta + 16000 + i * 1000));
                }
                ArrayList<ItemStack> materialDustStackList = new ArrayList<ItemStack>();
                for (int i = 0; i < maximumIndex; ++i) {
                    materialDustStackList.add(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)GT5OreSmallHelper.getDroppedDusts()[i], (long)1L));
                }
                this.arecipes.add(new CachedOreSmallRecipe(oreSmallWorldGen.oreGenName, stackList, materialDustStackList, GT5OreSmallHelper.mapOreMetaToOreDrops.get(baseMeta)));
            }
        } else if (GT5OreSmallHelper.mapOreDropUnlocalizedNameToOreMeta.keySet().contains(stack.func_77977_a())) {
            short baseMeta = GT5OreSmallHelper.mapOreDropUnlocalizedNameToOreMeta.get(stack.func_77977_a());
            for (String oreGenName : GT5OreSmallHelper.mapOreSmallWrapper.keySet()) {
                GT5OreSmallHelper.OreSmallWrapper oreSmallWrapper = GT5OreSmallHelper.mapOreSmallWrapper.get(oreGenName);
                if (oreSmallWrapper.oreMeta != baseMeta) continue;
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                for (int i = 0; i < 7; ++i) {
                    stackList.add(new ItemStack(GregTech_API.sBlockOres1, 1, baseMeta + 16000 + i * 1000));
                }
                ArrayList<ItemStack> materialDustStackList = new ArrayList<ItemStack>();
                for (int i = 0; i < 7; ++i) {
                    materialDustStackList.add(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)GT5OreSmallHelper.getDroppedDusts()[i], (long)1L));
                }
                this.arecipes.add(new CachedOreSmallRecipe(GT5OreSmallHelper.mapOreSmallWrapper.get((Object)oreGenName).oreGenName, stackList, materialDustStackList, GT5OreSmallHelper.mapOreMetaToOreDrops.get(baseMeta)));
            }
        } else {
            super.loadCraftingRecipes(stack);
        }
    }

    @Override
    public String getOutputId() {
        return "GTOrePluginOreSmall";
    }

    @Override
    public String getRecipeName() {
        return I18n.func_135052_a((String)"gtnop.gui.smallOreStat.name", (Object[])new Object[0]);
    }

    public class CachedOreSmallRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public String oreGenName;
        public PositionedStack positionedStackOreSmall;
        public PositionedStack positionedStackMaterialDust;
        public List<PositionedStack> positionedDropStackList;

        public CachedOreSmallRecipe(String oreGenName, List<ItemStack> stackList, List<ItemStack> materialDustStackList, List<ItemStack> dropStackList) {
            super((TemplateRecipeHandler)PluginGT5SmallOreStat.this);
            this.oreGenName = oreGenName;
            this.positionedStackOreSmall = new PositionedStack(stackList, 2, 0);
            this.positionedStackMaterialDust = new PositionedStack(materialDustStackList, 43, 79 + PluginGT5SmallOreStat.this.getRestrictBiomeOffset());
            ArrayList<PositionedStack> positionedDropStackList = new ArrayList<PositionedStack>();
            int i = 1;
            for (ItemStack stackDrop : dropStackList) {
                positionedDropStackList.add(new PositionedStack((Object)stackDrop, 43 + 20 * (i % 4), 79 + 16 * (i++ / 4) + PluginGT5SmallOreStat.this.getRestrictBiomeOffset()));
            }
            this.positionedDropStackList = positionedDropStackList;
        }

        public List<PositionedStack> getIngredients() {
            this.positionedStackOreSmall.setPermutationToRender(PluginGT5SmallOreStat.this.cycleticks / 20 % this.positionedStackOreSmall.items.length);
            this.positionedStackMaterialDust.setPermutationToRender(PluginGT5SmallOreStat.this.cycleticks / 20 % this.positionedStackMaterialDust.items.length);
            this.positionedDropStackList.add(this.positionedStackOreSmall);
            this.positionedDropStackList.add(this.positionedStackMaterialDust);
            return this.positionedDropStackList;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

