/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkItemEventListener;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.BlockTileEntity;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.item.IHandHeldInventory;
import ic2.core.network.DataEncoder;
import ic2.core.network.IRpcProvider;
import ic2.core.network.NetworkManager;
import ic2.core.util.LogCategory;
import ic2.core.util.ReflectionUtil;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.zip.InflaterInputStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

@SideOnly(value=Side.CLIENT)
public class NetworkManagerClient
extends NetworkManager {
    private ByteArrayOutputStream largePacketBuffer;

    @Override
    protected boolean isClient() {
        return true;
    }

    @Override
    public void initiateClientItemEvent(ItemStack itemStack, int event) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(1);
            DataEncoder.encode(os, itemStack, false);
            os.writeInt(event);
            os.close();
            this.sendPacket(buffer.toByteArray());
        }
        catch (IOException var5) {
            throw new RuntimeException(var5);
        }
    }

    @Override
    public void initiateKeyUpdate(int keyState) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(2);
            os.writeInt(keyState);
            os.close();
            this.sendPacket(buffer.toByteArray());
        }
        catch (IOException var4) {
            throw new RuntimeException(var4);
        }
    }

    @Override
    public void initiateClientTileEntityEvent(TileEntity te, int event) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(3);
            DataEncoder.encode(os, te, false);
            os.writeInt(event);
            os.close();
            this.sendPacket(buffer.toByteArray());
        }
        catch (IOException var5) {
            throw new RuntimeException(var5);
        }
    }

    @Override
    public void initiateRpc(int id, Class<? extends IRpcProvider<?>> provider, Object[] args) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(4);
            os.writeInt(id);
            os.writeUTF(provider.getName());
            DataEncoder.encode(os, args);
            os.close();
            this.sendPacket(buffer.toByteArray());
        }
        catch (IOException var6) {
            throw new RuntimeException(var6);
        }
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.onPacketData((InputStream)new ByteBufInputStream(event.packet.payload()), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    protected void onPacketData(InputStream isRaw, EntityPlayer player) {
        isRaw.mark(Integer.MAX_VALUE);
        DataInputStream is = new DataInputStream(isRaw);
        try {
            if (isRaw.available() == 0) {
                return;
            }
            switch (is.read()) {
                case 0: {
                    int len;
                    int state = is.read();
                    if ((state & 1) != 0) {
                        this.largePacketBuffer = new ByteArrayOutputStream(16384);
                    }
                    byte[] buffer = new byte[4096];
                    while ((len = is.read(buffer)) != -1) {
                        this.largePacketBuffer.write(buffer, 0, len);
                    }
                    if ((state & 2) != 0) {
                        ByteArrayInputStream inflateInput = new ByteArrayInputStream(this.largePacketBuffer.toByteArray());
                        InflaterInputStream inflate = new InflaterInputStream(inflateInput);
                        ByteArrayOutputStream inflateBuffer = new ByteArrayOutputStream(16384);
                        while ((len = inflate.read(buffer)) != -1) {
                            inflateBuffer.write(buffer, 0, len);
                        }
                        inflate.close();
                        byte[] subData = inflateBuffer.toByteArray();
                        switch (state >> 2) {
                            case 0: {
                                NetworkManagerClient.processInitPacket(subData);
                                break;
                            }
                            case 1: {
                                NetworkManagerClient.processChatPacket(subData);
                                break;
                            }
                            case 2: {
                                NetworkManagerClient.processConsolePacket(subData);
                            }
                        }
                        this.largePacketBuffer = null;
                    }
                    break;
                }
                case 1: {
                    TileEntity te = DataEncoder.decode(is, TileEntity.class);
                    int event = is.readInt();
                    if (te instanceof INetworkTileEntityEventListener) {
                        ((INetworkTileEntityEventListener)te).onNetworkEvent(event);
                    }
                    break;
                }
                case 2: {
                    EntityPlayer entityPlayer;
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    if (Minecraft.func_71410_x().func_71356_B()) {
                        Object obj;
                        UUID uuid = new UUID(is.readLong(), is.readLong());
                        Iterator componentName = world.field_73010_i.iterator();
                        do {
                            if (componentName.hasNext()) continue;
                            return;
                        } while (!uuid.equals((entityPlayer = (EntityPlayer)(obj = componentName.next())).func_146103_bH().getId()));
                    } else {
                        Entity ent = world.func_73045_a(is.readInt());
                        entityPlayer = ent instanceof EntityPlayer ? (EntityPlayer)ent : null;
                    }
                    ItemStack stack = DataEncoder.decode(is, ItemStack.class);
                    int event2 = is.readInt();
                    if (entityPlayer == null) {
                        return;
                    }
                    if (stack.func_77973_b() instanceof INetworkItemEventListener) {
                        ((INetworkItemEventListener)stack.func_77973_b()).onNetworkEvent(stack, entityPlayer, event2);
                    }
                    break;
                }
                default: {
                    isRaw.reset();
                    super.onPacketData(isRaw, player);
                    break;
                }
                case 4: {
                    EntityPlayer entityPlayer2 = IC2.platform.getPlayerInstance();
                    boolean isAdmin = is.readBoolean();
                    if (!is.readBoolean()) {
                        TileEntity te2 = DataEncoder.decode(is, TileEntity.class);
                        int windowId = is.readInt();
                        if (te2 instanceof IHasGui) {
                            IC2.platform.launchGuiClient(entityPlayer2, (IHasGui)te2, isAdmin);
                        }
                        entityPlayer2.field_71070_bA.field_75152_c = windowId;
                    } else {
                        int windowId2 = is.readInt();
                        ItemStack currentItem = entityPlayer2.field_71071_by.func_70448_g();
                        if (currentItem != null && currentItem.func_77973_b() instanceof IHandHeldInventory) {
                            IC2.platform.launchGuiClient(entityPlayer2, ((IHandHeldInventory)currentItem.func_77973_b()).getInventory(entityPlayer2, currentItem), isAdmin);
                        }
                        entityPlayer2.field_71070_bA.field_75152_c = windowId2;
                    }
                    return;
                }
                case 5: {
                    int x = is.readInt();
                    int y = is.readInt();
                    int z = is.readInt();
                    WorldClient world2 = Minecraft.func_71410_x().field_71441_e;
                    world2.func_72908_a((double)x, (double)y, (double)z, "random.explode", 4.0f, (1.0f + (world2.field_73012_v.nextFloat() - world2.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    world2.func_72869_a("hugeexplosion", (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                    break;
                }
                case 6: {
                    return;
                }
                case 7: {
                    int x2 = is.readInt();
                    int y2 = is.readInt();
                    int z2 = is.readInt();
                    String componentName2 = is.readUTF();
                    int dataLen = is.readInt();
                    if (dataLen > 65536) {
                        throw new IOException("data length limit exceeded");
                    }
                    byte[] data = new byte[dataLen];
                    is.readFully(data);
                    WorldClient world3 = Minecraft.func_71410_x().field_71441_e;
                    TileEntity teRaw = world3.func_147438_o(x2, y2, z2);
                    if (!(teRaw instanceof TileEntityBlock)) {
                        return;
                    }
                    TileEntityComponent component = ((TileEntityBlock)teRaw).getComponent(componentName2);
                    if (component == null) {
                        return;
                    }
                    DataInputStream dataIs = new DataInputStream(new ByteArrayInputStream(data));
                    component.onNetworkUpdate(dataIs);
                    break;
                }
            }
        }
        catch (IOException var15) {
            IC2.log.warn(LogCategory.Network, var15, "Network read failed.");
        }
    }

    private static void processInitPacket(byte[] data) throws IOException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(data);
        DataInputStream is = new DataInputStream(buffer);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (!Minecraft.func_71410_x().func_71356_B() || world.field_73011_w.field_76574_g == is.readInt()) {
            block4: while (true) {
                int x;
                try {
                    x = is.readInt();
                }
                catch (EOFException var16) {
                    is.close();
                    return;
                }
                int y = is.readInt();
                int z = is.readInt();
                byte[] fieldData = new byte[is.readInt()];
                is.readFully(fieldData);
                ByteArrayInputStream fieldDataBuffer = new ByteArrayInputStream(fieldData);
                DataInputStream fieldDataStream = new DataInputStream(fieldDataBuffer);
                HashMap<String, Object> fieldValues = new HashMap<String, Object>(30);
                while (true) {
                    String fieldName;
                    try {
                        fieldName = fieldDataStream.readUTF();
                    }
                    catch (EOFException var17) {
                        TileEntity te;
                        Block block = world.func_147439_a(x, y, z);
                        if (block == Blocks.field_150350_a) continue block4;
                        if (block instanceof BlockTileEntity) {
                            int tileEntityId = (Integer)fieldValues.get("tileEntityId");
                            te = ((BlockTileEntity)block).getTileEntity(tileEntityId);
                            if (te != null) {
                                world.func_147455_a(x, y, z, te);
                            }
                        } else {
                            te = world.func_147438_o(x, y, z);
                        }
                        if (te == null) continue block4;
                        fieldValues.forEach((field, value) -> {
                            ReflectionUtil.setValueRecursive(te, field, value);
                            if (te instanceof INetworkUpdateListener) {
                                ((INetworkUpdateListener)te).onNetworkUpdate((String)field);
                            }
                        });
                        continue block4;
                    }
                    Object value2 = DataEncoder.decode(fieldDataStream);
                    fieldValues.put(fieldName, value2);
                }
                break;
            }
        }
    }

    private static void processChatPacket(byte[] data) {
        String messages = new String(data, StandardCharsets.UTF_8);
        for (String line : messages.split("[\\r\\n]+")) {
            IC2.platform.messagePlayer(null, line, new Object[0]);
        }
    }

    private static void processConsolePacket(byte[] data) {
        String messages = new String(data, StandardCharsets.UTF_8);
        PrintStream console = new PrintStream(new FileOutputStream(FileDescriptor.out));
        for (String line : messages.split("[\\r\\n]+")) {
            console.println(line);
        }
        console.flush();
    }
}

