/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import cpw.mods.fml.relauncher.ReflectionHelper;
import ic2.core.IC2;
import ic2.core.network.DataEncoder;
import ic2.core.util.LogCategory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ReflectionUtil {
    private static final HashMap<Class<?>, HashMap<String, Field>> FIELD_CACHE = new HashMap(50);
    private static final Field DUMMY_FIELD = ReflectionHelper.findField(ReflectionUtil.class, (String[])new String[]{"FIELD_CACHE"});

    public static Field getField(Class<?> clazz, String ... names) {
        for (String name : names) {
            try {
                Field ret = clazz.getDeclaredField(name);
                ret.setAccessible(true);
                return ret;
            }
            catch (NoSuchFieldException var7) {
            }
            catch (SecurityException var8) {
                throw new RuntimeException(var8);
            }
        }
        return null;
    }

    public static Field getField(Class<?> clazz, Class<?> type) {
        Field ret = null;
        for (Field field : clazz.getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            if (ret != null) {
                return null;
            }
            field.setAccessible(true);
            ret = field;
        }
        return ret;
    }

    public static Field getFieldRecursive(Class<?> clazz, String fieldName) {
        HashMap class2Fields = FIELD_CACHE.computeIfAbsent(clazz, aClass -> new HashMap());
        Field field = (Field)class2Fields.get(fieldName);
        if (field != null) {
            return field == DUMMY_FIELD ? null : field;
        }
        while (clazz != Object.class) {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
            if (field == null && clazz != null) continue;
        }
        class2Fields.put(fieldName, field == null ? DUMMY_FIELD : field);
        return field;
    }

    public static Object getValue(Object e, Class<?> type) {
        Field field = ReflectionUtil.getField(e.getClass(), type);
        if (field == null) {
            return null;
        }
        try {
            return field.get(e);
        }
        catch (Exception var4) {
            throw new RuntimeException(var4);
        }
    }

    public static Object getValueRecursive(Object object, String fieldName) throws NoSuchFieldException {
        Field field = ReflectionUtil.getFieldRecursive(object.getClass(), fieldName);
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception var4) {
            throw new RuntimeException(var4);
        }
    }

    public static boolean setValueRecursive(Object object, String fieldName, Object value) {
        Field field = ReflectionUtil.getFieldRecursive(object.getClass(), fieldName);
        if (field == null) {
            IC2.log.warn(LogCategory.General, "Can't find field %s in %s to set it to %s.", fieldName, object, value);
            return false;
        }
        field.setAccessible(true);
        if (field.getType().isEnum() && value instanceof Integer) {
            value = field.getType().getEnumConstants()[(Integer)value];
        }
        try {
            Object oldValue = field.get(object);
            if (!DataEncoder.copyValue(value, oldValue)) {
                field.set(object, value);
            }
            return true;
        }
        catch (Exception var5) {
            throw new RuntimeException("can't set field " + fieldName + " in " + object + " to " + value, var5);
        }
    }

    public static boolean setValue(Object object, Field field, Object value) {
        field.setAccessible(true);
        if (field.getType().isEnum() && value instanceof Integer) {
            value = field.getType().getEnumConstants()[(Integer)value];
        }
        try {
            Object oldValue = field.get(object);
            if (!DataEncoder.copyValue(value, oldValue)) {
                field.set(object, value);
            }
            return true;
        }
        catch (Exception var4) {
            throw new RuntimeException("can't set field " + field.getName() + " in " + object + " to " + value, var4);
        }
    }

    public static Method getMethod(Class<?> clazz, String[] names, Class<?> ... parameterTypes) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                Method ret = clazz.getDeclaredMethod(name, parameterTypes);
                ret.setAccessible(true);
                return ret;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

