/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.hessenberg;

import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class TridiagonalDecompositionHouseholderOrig_D64 {
    DenseMatrix64F QT = new DenseMatrix64F(this.N, this.N);
    int N = 1;
    double[] w = new double[this.N];
    double[] gammas;
    double[] b = new double[this.N];

    public TridiagonalDecompositionHouseholderOrig_D64() {
        this.gammas = new double[this.N];
    }

    public DenseMatrix64F getQT() {
        return this.QT;
    }

    public DenseMatrix64F getT(DenseMatrix64F T) {
        if (T == null) {
            T = new DenseMatrix64F(this.N, this.N);
        } else {
            if (this.N != T.numRows || this.N != T.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            T.zero();
        }
        T.data[0] = this.QT.data[0];
        T.data[1] = this.QT.data[1];
        for (int i = 1; i < this.N - 1; ++i) {
            T.set(i, i, this.QT.get(i, i));
            T.set(i, i + 1, this.QT.get(i, i + 1));
            T.set(i, i - 1, this.QT.get(i - 1, i));
        }
        T.data[(this.N - 1) * this.N + this.N - 1] = this.QT.data[(this.N - 1) * this.N + this.N - 1];
        T.data[(this.N - 1) * this.N + this.N - 2] = this.QT.data[(this.N - 2) * this.N + this.N - 1];
        return T;
    }

    public DenseMatrix64F getQ(DenseMatrix64F Q) {
        int i;
        if (Q == null) {
            Q = new DenseMatrix64F(this.N, this.N);
            for (i = 0; i < this.N; ++i) {
                Q.data[i * this.N + i] = 1.0;
            }
        } else {
            if (this.N != Q.numRows || this.N != Q.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            CommonOps.setIdentity(Q);
        }
        for (i = 0; i < this.N; ++i) {
            this.w[i] = 0.0;
        }
        for (int j = this.N - 2; j >= 0; --j) {
            this.w[j + 1] = 1.0;
            for (int k = j + 2; k < this.N; ++k) {
                this.w[k] = this.QT.get(j, k);
            }
            QrHelperFunctions.rank1UpdateMultR(Q, this.w, this.gammas[j + 1], j + 1, j + 1, this.N, this.b);
        }
        return Q;
    }

    public void decompose(DenseMatrix64F A) {
        this.init(A);
        for (int k = 1; k < this.N; ++k) {
            this.similarTransform(k);
        }
    }

    private void similarTransform(int k) {
        double[] t = this.QT.data;
        double max = 0.0;
        int rowU = (k - 1) * this.N;
        for (int i = k; i < this.N; ++i) {
            double val = Math.abs(t[rowU + i]);
            if (!(val > max)) continue;
            max = val;
        }
        if (max > 0.0) {
            double gamma;
            double tau = 0.0;
            for (int j = k; j < this.N; ++j) {
                double n2;
                double[] array = t;
                int n = rowU + j;
                array[n] = n2 = array[n] / max;
                double val2 = n2;
                tau += val2 * val2;
            }
            tau = Math.sqrt(tau);
            if (t[rowU + k] < 0.0) {
                tau = -tau;
            }
            double nu = t[rowU + k] + tau;
            t[rowU + k] = 1.0;
            for (int l = k + 1; l < this.N; ++l) {
                int n3;
                double[] array2 = t;
                int n = n3 = rowU + l;
                array2[n] = array2[n] / nu;
            }
            this.gammas[k] = gamma = nu / tau;
            this.householderSymmetric(k, this.gammas[k]);
            t[rowU + k] = -tau * max;
        } else {
            this.gammas[k] = 0.0;
        }
    }

    public void householderSymmetric(int row, double gamma) {
        int k;
        int startU = (row - 1) * this.N;
        for (int i = row; i < this.N; ++i) {
            double total = 0.0;
            for (int j = row; j < this.N; ++j) {
                total += this.QT.data[i * this.N + j] * this.QT.data[startU + j];
            }
            this.w[i] = -gamma * total;
        }
        double alpha = 0.0;
        for (k = row; k < this.N; ++k) {
            alpha += this.QT.data[startU + k] * this.w[k];
        }
        alpha *= -0.5 * gamma;
        for (k = row; k < this.N; ++k) {
            int n;
            double[] w = this.w;
            int n2 = n = k;
            w[n2] = w[n2] + alpha * this.QT.data[startU + k];
        }
        for (k = row; k < this.N; ++k) {
            double ww = this.w[k];
            double uu = this.QT.data[startU + k];
            for (int l = k; l < this.N; ++l) {
                int n3;
                double[] data = this.QT.data;
                int n2 = l * this.N + k;
                double[] data2 = this.QT.data;
                int n = n3 = k * this.N + l;
                double d = data2[n] + (ww * this.QT.data[startU + l] + this.w[l] * uu);
                data2[n] = d;
                data[n2] = d;
            }
        }
    }

    public void init(DenseMatrix64F A) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("Must be square");
        }
        if (A.numCols != this.N) {
            this.N = A.numCols;
            this.QT.reshape(this.N, this.N, false);
            if (this.w.length < this.N) {
                this.w = new double[this.N];
                this.gammas = new double[this.N];
                this.b = new double[this.N];
            }
        }
        this.QT.set(A);
    }

    public double getGamma(int index) {
        return this.gammas[index];
    }
}

