/*
 * Decompiled with CFR 0.152.
 */
package Zeno410Utils;

import net.minecraft.util.ChunkCoordinates;

public class PlaneLocation {
    public final int x;
    public final int z;

    public PlaneLocation(int _x, int _z) {
        this.x = _x;
        this.z = _z;
    }

    public PlaneLocation(ChunkCoordinates coordinates) {
        this(coordinates.field_71574_a, coordinates.field_71573_c);
    }

    public float distance(PlaneLocation location) {
        return (float)(this.x - location.x) * (float)(this.x - location.x) + (float)(this.z - location.z) * (float)(this.z - location.z);
    }

    public <Type extends Provider> Type closest(Iterable<Type> choices) {
        Provider result = null;
        float bestDistance = Float.MAX_VALUE;
        for (Provider tested : choices) {
            float distance = this.distance(tested.planeLocation());
            if (!(distance < bestDistance)) continue;
            result = tested;
        }
        return (Type)result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.x;
        hash = 71 * hash + this.z;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlaneLocation other = (PlaneLocation)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.z == other.z;
    }

    public static abstract class Provider {
        public abstract PlaneLocation planeLocation();
    }
}

