/*
 * Decompiled with CFR 0.152.
 */
package org.bogdang.modifications.random;

import java.util.Random;

public class TLR
extends Random {
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final long GAMMA = -7046029254386353131L;
    private static final int PROBE_INCREMENT = -1640531527;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private long rnd;
    private long pad0;
    private long pad1;
    private long pad2;
    private long pad3;
    private long pad4;
    private long pad5;
    private long pad6;
    private long pad7;
    private static final ThreadLocal<Double> nextLocalGaussian = new ThreadLocal();
    private static final ThreadLocal<TLR> localRandom = new ThreadLocal<TLR>(){

        @Override
        protected TLR initialValue() {
            return new TLR();
        }
    };
    private static final long serialVersionUID = -5851777807851030925L;

    TLR() {
    }

    public static TLR current() {
        return localRandom.get();
    }

    @Override
    public void setSeed(long seed) {
        this.rnd = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @Override
    protected int next(int bits) {
        this.rnd = this.rnd * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.rnd >>> 48 - bits);
    }

    @Override
    public int nextInt(int least, int bound) {
        return this.nextInt(bound - least) + least;
    }

    @Override
    public long nextLong(long n) {
        long offset = 0L;
        while (n >= Integer.MAX_VALUE) {
            long nextn;
            int bits = this.next(2);
            long half = n >>> 1;
            long l = nextn = (bits & 2) == 0 ? half : n - half;
            if ((bits & 1) == 0) {
                offset += n - nextn;
            }
            n = nextn;
        }
        return offset + (long)this.nextInt((int)n);
    }

    @Override
    public long nextLong(long least, long bound) {
        return this.nextLong(bound - least) + least;
    }

    @Override
    public double nextDouble(double n) {
        return this.nextDouble() * n;
    }

    @Override
    public double nextDouble(double least, double bound) {
        return this.nextDouble() * (bound - least) + least;
    }

    @Override
    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        Double d = nextLocalGaussian.get();
        if (d != null) {
            nextLocalGaussian.set(null);
            return d;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        nextLocalGaussian.set(new Double(v2 * multiplier));
        return v1 * multiplier;
    }

    @Override
    public float nextFloat() {
        return (float)this.next(24) * 5.9604645E-8f;
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    @Override
    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    @Override
    public int nextInt() {
        return this.next(32);
    }
}

