/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.DiscordEventAdapter;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class CreateParams
implements AutoCloseable {
    private final long pointer;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public CreateParams() {
        this.pointer = this.allocate();
    }

    public void setClientID(long l) {
        this.setClientID(this.pointer, l);
    }

    public long getClientID() {
        return this.getClientID(this.pointer);
    }

    public void setFlags(Flags ... flagsArray) {
        this.setFlags(this.pointer, Flags.toLong(flagsArray));
    }

    public void setFlags(long l) {
        this.setFlags(this.pointer, l);
    }

    public long getFlags() {
        return this.getFlags(this.pointer);
    }

    public void registerEventHandler(DiscordEventAdapter discordEventAdapter) {
        this.registerEventHandler(this.pointer, Objects.requireNonNull(discordEventAdapter));
    }

    private native long allocate();

    private native void free(long var1);

    private native void setClientID(long var1, long var3);

    private native long getClientID(long var1);

    private native void setFlags(long var1, long var3);

    private native long getFlags(long var1);

    private native void registerEventHandler(long var1, DiscordEventAdapter var3);

    public static native long getDefaultFlags();

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            this.free(this.pointer);
        }
    }

    public long getPointer() {
        return this.pointer;
    }

    public static enum Flags {
        DEFAULT(0L),
        NO_REQUIRE_DISCORD(1L);

        private final long value;

        private Flags(long l) {
            this.value = l;
        }

        public static long toLong(Flags ... flagsArray) {
            long l = 0L;
            for (Flags flags : flagsArray) {
                l |= flags.value;
            }
            return l;
        }

        public static Flags[] fromLong(long l) {
            return (Flags[])Stream.of(Flags.values()).filter(flags -> (l & flags.value) != 0L).toArray(Flags[]::new);
        }
    }
}

