/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.DiscordEventAdapter;
import de.jcm.discordgamesdk.user.DiscordUser;
import de.jcm.discordgamesdk.user.Relationship;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DiscordEventHandler
extends DiscordEventAdapter {
    private final List<DiscordEventAdapter> listeners = new CopyOnWriteArrayList<DiscordEventAdapter>();

    public void addListener(DiscordEventAdapter discordEventAdapter) {
        this.listeners.add(discordEventAdapter);
    }

    public boolean removeListener(DiscordEventAdapter discordEventAdapter) {
        return this.listeners.remove(discordEventAdapter);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public void onActivityJoin(String string) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onActivityJoin(string));
    }

    @Override
    public void onActivitySpectate(String string) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onActivitySpectate(string));
    }

    @Override
    public void onActivityJoinRequest(DiscordUser discordUser) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onActivityJoinRequest(discordUser));
    }

    @Override
    public void onCurrentUserUpdate() {
        this.listeners.forEach(DiscordEventAdapter::onCurrentUserUpdate);
    }

    @Override
    public void onOverlayToggle(boolean bl) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onOverlayToggle(bl));
    }

    @Override
    public void onRelationshipRefresh() {
        this.listeners.forEach(DiscordEventAdapter::onRelationshipRefresh);
    }

    @Override
    public void onRelationshipUpdate(Relationship relationship) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onRelationshipUpdate(relationship));
    }

    @Override
    public void onLobbyUpdate(long l) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onLobbyUpdate(l));
    }

    @Override
    public void onLobbyDelete(long l, int n) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onLobbyDelete(l, n));
    }

    @Override
    public void onMemberConnect(long l, long l2) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onMemberConnect(l, l2));
    }

    @Override
    public void onMemberUpdate(long l, long l2) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onMemberUpdate(l, l2));
    }

    @Override
    public void onMemberDisconnect(long l, long l2) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onMemberDisconnect(l, l2));
    }

    @Override
    public void onLobbyMessage(long l, long l2, byte[] byArray) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onLobbyMessage(l, l2, byArray));
    }

    @Override
    public void onSpeaking(long l, long l2, boolean bl) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onSpeaking(l, l2, bl));
    }

    @Override
    public void onNetworkMessage(long l, long l2, byte by, byte[] byArray) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onNetworkMessage(l, l2, by, byArray));
    }

    @Override
    public void onMessage(long l, byte by, byte[] byArray) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onMessage(l, by, byArray));
    }

    @Override
    public void onRouteUpdate(String string) {
        this.listeners.forEach(discordEventAdapter -> discordEventAdapter.onRouteUpdate(string));
    }
}

