/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.image.ImageDimensions;
import de.jcm.discordgamesdk.image.ImageHandle;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.function.BiConsumer;

public class ImageManager {
    private final long pointer;
    private final Core core;

    ImageManager(long l, Core core) {
        this.pointer = l;
        this.core = core;
    }

    public void fetch(ImageHandle imageHandle, boolean bl, BiConsumer<Result, ImageHandle> biConsumer) {
        this.core.execute(() -> this.fetch(this.pointer, imageHandle.getType().ordinal(), imageHandle.getId(), imageHandle.getSize(), bl, Objects.requireNonNull(biConsumer)));
    }

    public ImageDimensions getDimensions(ImageHandle imageHandle) {
        Object object = this.core.execute(() -> this.getDimensions(this.pointer, imageHandle.getType().ordinal(), imageHandle.getId(), imageHandle.getSize()));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (ImageDimensions)object;
    }

    public byte[] getData(ImageHandle imageHandle, ImageDimensions imageDimensions) {
        return this.getData(imageHandle, imageDimensions.getWidth() * imageDimensions.getHeight() * 4);
    }

    public byte[] getData(ImageHandle imageHandle, int n) {
        Object object = this.core.execute(() -> this.getData(this.pointer, imageHandle.getType().ordinal(), imageHandle.getId(), imageHandle.getSize(), n));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (byte[])object;
    }

    public BufferedImage getAsBufferedImage(ImageHandle imageHandle, ImageDimensions imageDimensions) {
        byte[] byArray = this.getData(imageHandle, imageDimensions);
        BufferedImage bufferedImage = new BufferedImage(imageDimensions.getWidth(), imageDimensions.getHeight(), 6);
        bufferedImage.getRaster().setDataElements(0, 0, imageDimensions.getWidth(), imageDimensions.getHeight(), byArray);
        return bufferedImage;
    }

    public BufferedImage getAsBufferedImage(ImageHandle imageHandle) {
        ImageDimensions imageDimensions = this.getDimensions(imageHandle);
        return this.getAsBufferedImage(imageHandle, imageDimensions);
    }

    private native void fetch(long var1, int var3, long var4, int var6, boolean var7, BiConsumer<Result, ImageHandle> var8);

    private native Object getDimensions(long var1, int var3, long var4, int var6);

    private native Object getData(long var1, int var3, long var4, int var6, int var7);
}

