/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.registry;

import com.sun.jna.platform.win32.WinBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.perfmon.ThreadInformation;
import oshi.driver.windows.registry.HkeyPerformanceDataUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class ThreadPerformanceData {
    private static final String THREAD = "Thread";

    private ThreadPerformanceData() {
    }

    public static Map<Integer, PerfCounterBlock> buildThreadMapFromRegistry(Collection<Integer> collection) {
        Triplet<List<Map<ThreadInformation.ThreadPerformanceProperty, Object>>, Long, Long> triplet = HkeyPerformanceDataUtil.readPerfDataFromRegistry(THREAD, ThreadInformation.ThreadPerformanceProperty.class);
        if (triplet == null) {
            return null;
        }
        List<Map<ThreadInformation.ThreadPerformanceProperty, Object>> list = triplet.getA();
        long l = triplet.getB();
        long l2 = triplet.getC();
        HashMap<Integer, PerfCounterBlock> hashMap = new HashMap<Integer, PerfCounterBlock>();
        for (Map<ThreadInformation.ThreadPerformanceProperty, Object> map : list) {
            int n = (Integer)map.get(ThreadInformation.ThreadPerformanceProperty.IDPROCESS);
            if (collection != null && !collection.contains(n) || n <= 0) continue;
            int n2 = (Integer)map.get(ThreadInformation.ThreadPerformanceProperty.IDTHREAD);
            String string = (String)map.get(ThreadInformation.ThreadPerformanceProperty.NAME);
            long l3 = (l - (Long)map.get(ThreadInformation.ThreadPerformanceProperty.ELAPSEDTIME)) / 10000L;
            if (l3 < 1L) {
                l3 = 1L;
            }
            long l4 = (Long)map.get(ThreadInformation.ThreadPerformanceProperty.PERCENTUSERTIME) / 10000L;
            long l5 = (Long)map.get(ThreadInformation.ThreadPerformanceProperty.PERCENTPRIVILEGEDTIME) / 10000L;
            int n3 = (Integer)map.get(ThreadInformation.ThreadPerformanceProperty.PRIORITYCURRENT);
            int n4 = (Integer)map.get(ThreadInformation.ThreadPerformanceProperty.THREADSTATE);
            int n5 = (Integer)map.get(ThreadInformation.ThreadPerformanceProperty.THREADWAITREASON);
            Object object = map.get(ThreadInformation.ThreadPerformanceProperty.STARTADDRESS);
            long l6 = object.getClass().equals(Long.class) ? (Long)object : Integer.toUnsignedLong((Integer)object);
            int n6 = (Integer)map.get(ThreadInformation.ThreadPerformanceProperty.CONTEXTSWITCHESPERSEC);
            hashMap.put(n2, new PerfCounterBlock(string, n2, n, l2 - l3, l4, l5, n3, n4, n5, l6, n6));
        }
        return hashMap;
    }

    public static Map<Integer, PerfCounterBlock> buildThreadMapFromPerfCounters(Collection<Integer> collection) {
        HashMap<Integer, PerfCounterBlock> hashMap = new HashMap<Integer, PerfCounterBlock>();
        Pair<List<String>, Map<ThreadInformation.ThreadPerformanceProperty, List<Long>>> pair = ThreadInformation.queryThreadCounters();
        long l = System.currentTimeMillis();
        List<String> list = pair.getA();
        Map<ThreadInformation.ThreadPerformanceProperty, List<Long>> map = pair.getB();
        List<Long> list2 = map.get(ThreadInformation.ThreadPerformanceProperty.IDTHREAD);
        List<Long> list3 = map.get(ThreadInformation.ThreadPerformanceProperty.IDPROCESS);
        List<Long> list4 = map.get(ThreadInformation.ThreadPerformanceProperty.PERCENTUSERTIME);
        List<Long> list5 = map.get(ThreadInformation.ThreadPerformanceProperty.PERCENTPRIVILEGEDTIME);
        List<Long> list6 = map.get(ThreadInformation.ThreadPerformanceProperty.ELAPSEDTIME);
        List<Long> list7 = map.get(ThreadInformation.ThreadPerformanceProperty.PRIORITYCURRENT);
        List<Long> list8 = map.get(ThreadInformation.ThreadPerformanceProperty.THREADSTATE);
        List<Long> list9 = map.get(ThreadInformation.ThreadPerformanceProperty.THREADWAITREASON);
        List<Long> list10 = map.get(ThreadInformation.ThreadPerformanceProperty.STARTADDRESS);
        List<Long> list11 = map.get(ThreadInformation.ThreadPerformanceProperty.CONTEXTSWITCHESPERSEC);
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            int n2 = list3.get(i).intValue();
            if (collection != null && !collection.contains(n2)) continue;
            int n3 = list2.get(i).intValue();
            String string = Integer.toString(n++);
            long l2 = list6.get(i);
            if ((l2 = WinBase.FILETIME.filetimeToDate((int)(l2 >> 32), (int)(l2 & 0xFFFFFFFFL)).getTime()) > l) {
                l2 = l - 1L;
            }
            long l3 = list4.get(i) / 10000L;
            long l4 = list5.get(i) / 10000L;
            int n4 = list7.get(i).intValue();
            int n5 = list8.get(i).intValue();
            int n6 = list9.get(i).intValue();
            long l5 = list10.get(i);
            int n7 = list11.get(i).intValue();
            hashMap.put(n3, new PerfCounterBlock(string, n3, n2, l2, l3, l4, n4, n5, n6, l5, n7));
        }
        return hashMap;
    }

    @Immutable
    public static class PerfCounterBlock {
        private final String name;
        private final int threadID;
        private final int owningProcessID;
        private final long startTime;
        private final long userTime;
        private final long kernelTime;
        private final int priority;
        private final int threadState;
        private final int threadWaitReason;
        private final long startAddress;
        private final int contextSwitches;

        public PerfCounterBlock(String string, int n, int n2, long l, long l2, long l3, int n3, int n4, int n5, long l4, int n6) {
            this.name = string;
            this.threadID = n;
            this.owningProcessID = n2;
            this.startTime = l;
            this.userTime = l2;
            this.kernelTime = l3;
            this.priority = n3;
            this.threadState = n4;
            this.threadWaitReason = n5;
            this.startAddress = l4;
            this.contextSwitches = n6;
        }

        public String getName() {
            return this.name;
        }

        public int getThreadID() {
            return this.threadID;
        }

        public int getOwningProcessID() {
            return this.owningProcessID;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getUserTime() {
            return this.userTime;
        }

        public long getKernelTime() {
            return this.kernelTime;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getThreadState() {
            return this.threadState;
        }

        public int getThreadWaitReason() {
            return this.threadWaitReason;
        }

        public long getStartAddress() {
            return this.startAddress;
        }

        public int getContextSwitches() {
            return this.contextSwitches;
        }
    }
}

