/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.util.Map;
import java.util.Properties;
import oshi.annotation.concurrent.NotThreadSafe;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

@NotThreadSafe
public final class GlobalConfig {
    private static final String OSHI_PROPERTIES = "oshi.properties";
    private static final Properties CONFIG = FileUtil.readPropertiesFromFilename("oshi.properties");
    public static final String OSHI_UTIL_MEMOIZER_EXPIRATION = "oshi.util.memoizer.expiration";
    public static final String OSHI_UTIL_WMI_TIMEOUT = "oshi.util.wmi.timeout";
    public static final String OSHI_UTIL_PROC_PATH = "oshi.util.proc.path";
    public static final String OSHI_PSEUDO_FILESYSTEM_TYPES = "oshi.pseudo.filesystem.types";
    public static final String OSHI_NETWORK_FILESYSTEM_TYPES = "oshi.network.filesystem.types";
    public static final String OSHI_OS_LINUX_PROCFS_LOGWARNING = "oshi.os.linux.procfs.logwarning";
    public static final String OSHI_OS_MAC_SYSCTL_LOGWARNING = "oshi.os.mac.sysctl.logwarning";
    public static final String OSHI_OS_WINDOWS_EVENTLOG = "oshi.os.windows.eventlog";
    public static final String OSHI_OS_WINDOWS_PROCSTATE_SUSPENDED = "oshi.os.windows.procstate.suspended";
    public static final String OSHI_OS_WINDOWS_COMMANDLINE_BATCH = "oshi.os.windows.commandline.batch";
    public static final String OSHI_OS_WINDOWS_HKEYPERFDATA = "oshi.os.windows.hkeyperfdata";
    public static final String OSHI_OS_WINDOWS_LOADAVERAGE = "oshi.os.windows.loadaverage";
    public static final String OSHI_OS_WINDOWS_CPU_UTILITY = "oshi.os.windows.cpu.utility";
    public static final String OSHI_OS_WINDOWS_PERFDISK_DIABLED = "oshi.os.windows.perfdisk.disabled";
    public static final String OSHI_OS_WINDOWS_PERFOS_DIABLED = "oshi.os.windows.perfos.disabled";
    public static final String OSHI_OS_WINDOWS_PERFPROC_DIABLED = "oshi.os.windows.perfproc.disabled";
    public static final String OSHI_OS_UNIX_WHOCOMMAND = "oshi.os.unix.whoCommand";

    private GlobalConfig() {
    }

    public static String get(String string) {
        return CONFIG.getProperty(string);
    }

    public static String get(String string, String string2) {
        return CONFIG.getProperty(string, string2);
    }

    public static int get(String string, int n) {
        String string2 = CONFIG.getProperty(string);
        return string2 == null ? n : ParseUtil.parseIntOrDefault(string2, n);
    }

    public static double get(String string, double d) {
        String string2 = CONFIG.getProperty(string);
        return string2 == null ? d : ParseUtil.parseDoubleOrDefault(string2, d);
    }

    public static boolean get(String string, boolean bl) {
        String string2 = CONFIG.getProperty(string);
        return string2 == null ? bl : Boolean.parseBoolean(string2);
    }

    public static void set(String string, Object object) {
        if (object == null) {
            CONFIG.remove(string);
        } else {
            CONFIG.setProperty(string, object.toString());
        }
    }

    public static void remove(String string) {
        CONFIG.remove(string);
    }

    public static void clear() {
        CONFIG.clear();
    }

    public static void load(Properties properties) {
        CONFIG.putAll((Map<?, ?>)properties);
    }

    public static class PropertyException
    extends RuntimeException {
        private static final long serialVersionUID = -7482581936621748005L;

        public PropertyException(String string) {
            super("Invalid property: \"" + string + "\" = " + GlobalConfig.get(string, null));
        }

        public PropertyException(String string, String string2) {
            super("Invalid property \"" + string + "\": " + string2);
        }
    }
}

