/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import pro.gravit.launcher.SWIxyn3sEUfrBu;
import pro.gravit.launcher.SWiXYovU8isNyt;
import pro.gravit.launcher.profiles.ClientProfile$ClassLoaderConfig;
import pro.gravit.launcher.profiles.ClientProfile$CompatibilityFlags;
import pro.gravit.launcher.profiles.ClientProfile$ProfileDefaultSettings;
import pro.gravit.launcher.profiles.ClientProfile$ServerProfile;
import pro.gravit.launcher.profiles.ClientProfile$Version;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launcher.profiles.optional.OptionalDepend;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class ClientProfile
implements Comparable<ClientProfile> {
    private static final SWIxyn3sEUfrBu ASSET_MATCHER = new SWIxyn3sEUfrBu(new String[0], new String[]{"indexes", "objects"}, new String[0]);
    @SWiXYovU8isNyt
    private String title;
    @SWiXYovU8isNyt
    private UUID uuid;
    @SWiXYovU8isNyt
    private ClientProfile$Version version;
    @SWiXYovU8isNyt
    private String info;
    @SWiXYovU8isNyt
    private String dir;
    @SWiXYovU8isNyt
    private int sortIndex;
    @SWiXYovU8isNyt
    private String assetIndex;
    @SWiXYovU8isNyt
    private String assetDir;
    @SWiXYovU8isNyt
    private List<String> update;
    @SWiXYovU8isNyt
    private List<String> updateExclusions;
    @SWiXYovU8isNyt
    private List<String> updateShared;
    @SWiXYovU8isNyt
    private List<String> updateVerify;
    @SWiXYovU8isNyt
    private Set<OptionalFile> updateOptional;
    @SWiXYovU8isNyt
    private List<String> jvmArgs;
    @SWiXYovU8isNyt
    private List<String> classPath;
    @SWiXYovU8isNyt
    private List<String> modulePath = new ArrayList<String>();
    @SWiXYovU8isNyt
    private List<String> modules = new ArrayList<String>();
    @SWiXYovU8isNyt
    private List<String> altClassPath;
    @SWiXYovU8isNyt
    private List<String> clientArgs;
    @SWiXYovU8isNyt
    private List<String> compatClasses;
    @SWiXYovU8isNyt
    private Map<String, String> properties;
    @SWiXYovU8isNyt
    private List<ClientProfile$ServerProfile> servers;
    @SWiXYovU8isNyt
    private ClientProfile$ClassLoaderConfig classLoaderConfig;
    @SWiXYovU8isNyt
    private List<ClientProfile$CompatibilityFlags> flags;
    @SWiXYovU8isNyt
    private int recommendJavaVersion = 8;
    @SWiXYovU8isNyt
    private int minJavaVersion = 8;
    @SWiXYovU8isNyt
    private int maxJavaVersion = 999;
    @SWiXYovU8isNyt
    private ClientProfile$ProfileDefaultSettings settings = new ClientProfile$ProfileDefaultSettings();
    @SWiXYovU8isNyt
    private boolean limited;
    @SWiXYovU8isNyt
    private String mainClass;

    public ClientProfile() {
        this.update = new ArrayList<String>();
        this.updateExclusions = new ArrayList<String>();
        this.updateShared = new ArrayList<String>();
        this.updateVerify = new ArrayList<String>();
        this.updateOptional = new HashSet<OptionalFile>();
        this.jvmArgs = new ArrayList<String>();
        this.classPath = new ArrayList<String>();
        this.modulePath = new ArrayList<String>();
        this.altClassPath = new ArrayList<String>();
        this.clientArgs = new ArrayList<String>();
        this.compatClasses = new ArrayList<String>();
        this.properties = new HashMap<String, String>();
        this.servers = new ArrayList<ClientProfile$ServerProfile>(1);
        this.classLoaderConfig = ClientProfile$ClassLoaderConfig.LAUNCHER;
        this.flags = new ArrayList<ClientProfile$CompatibilityFlags>();
    }

    public ClientProfile(List<String> list, List<String> list2, List<String> list3, List<String> list4, Set<OptionalFile> set, List<String> list5, List<String> list6, List<String> list7, List<String> list8, List<String> list9, List<String> list10, List<String> list11, Map<String, String> map, List<ClientProfile$ServerProfile> list12, ClientProfile$ClassLoaderConfig clientProfile$ClassLoaderConfig, List<ClientProfile$CompatibilityFlags> list13, ClientProfile$Version clientProfile$Version, String string, String string2, String string3, int n, int n2, int n3, ClientProfile$ProfileDefaultSettings clientProfile$ProfileDefaultSettings, int n4, UUID uUID, String string4, String string5, String string6) {
        this.update = list;
        this.updateExclusions = list2;
        this.updateShared = list3;
        this.updateVerify = list4;
        this.updateOptional = set;
        this.jvmArgs = list5;
        this.classPath = list6;
        this.modulePath = list7;
        this.modules = list8;
        this.altClassPath = list9;
        this.clientArgs = list10;
        this.compatClasses = list11;
        this.properties = map;
        this.servers = list12;
        this.classLoaderConfig = clientProfile$ClassLoaderConfig;
        this.version = clientProfile$Version;
        this.assetIndex = string;
        this.dir = string2;
        this.assetDir = string3;
        this.recommendJavaVersion = n;
        this.minJavaVersion = n2;
        this.maxJavaVersion = n3;
        this.settings = clientProfile$ProfileDefaultSettings;
        this.sortIndex = n4;
        this.uuid = uUID;
        this.title = string4;
        this.info = string5;
        this.mainClass = string6;
        this.flags = list13;
    }

    public ClientProfile$ServerProfile getDefaultServerProfile() {
        for (ClientProfile$ServerProfile clientProfile$ServerProfile : this.servers) {
            if (!clientProfile$ServerProfile.isDefault) continue;
            return clientProfile$ServerProfile;
        }
        return null;
    }

    @Override
    public int compareTo(ClientProfile clientProfile) {
        return Integer.compare(this.getSortIndex(), clientProfile.getSortIndex());
    }

    public String getAssetIndex() {
        return this.assetIndex;
    }

    public SWIxyn3sEUfrBu getAssetUpdateMatcher() {
        return this.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_7_10) >= 0 ? ASSET_MATCHER : null;
    }

    public String[] getClassPath() {
        return this.classPath.toArray(new String[0]);
    }

    public List<String> getModulePath() {
        return Collections.unmodifiableList(this.modulePath);
    }

    public List<String> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    public String[] getAlternativeClassPath() {
        return this.altClassPath.toArray(new String[0]);
    }

    public String[] getClientArgs() {
        return this.clientArgs.toArray(new String[0]);
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String string) {
        this.dir = string;
    }

    public String getAssetDir() {
        return this.assetDir;
    }

    public List<String> getUpdateExclusions() {
        return Collections.unmodifiableList(this.updateExclusions);
    }

    public SWIxyn3sEUfrBu getClientUpdateMatcher() {
        String[] stringArray = this.update.toArray(new String[0]);
        String[] stringArray2 = this.updateVerify.toArray(new String[0]);
        List<String> list = this.updateExclusions;
        String[] stringArray3 = list.toArray(new String[0]);
        return new SWIxyn3sEUfrBu(stringArray, stringArray2, stringArray3);
    }

    public String[] getJvmArgs() {
        return this.jvmArgs.toArray(new String[0]);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<ClientProfile$ServerProfile> getServers() {
        return this.servers;
    }

    public String getServerAddress() {
        ClientProfile$ServerProfile clientProfile$ServerProfile = this.getDefaultServerProfile();
        return clientProfile$ServerProfile == null ? "localhost" : clientProfile$ServerProfile.serverAddress;
    }

    public Set<OptionalFile> getOptional() {
        return this.updateOptional;
    }

    public int getRecommendJavaVersion() {
        return this.recommendJavaVersion;
    }

    public int getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public int getMaxJavaVersion() {
        return this.maxJavaVersion;
    }

    public ClientProfile$ProfileDefaultSettings getSettings() {
        return this.settings;
    }

    public void updateOptionalGraph() {
        for (OptionalFile optionalFile : this.updateOptional) {
            int n;
            if (optionalFile.dependenciesFile != null) {
                optionalFile.dependencies = new OptionalFile[optionalFile.dependenciesFile.length];
                for (n = 0; n < optionalFile.dependenciesFile.length; ++n) {
                    optionalFile.dependencies[n] = this.getOptionalFile(optionalFile.dependenciesFile[n].name);
                }
            }
            if (optionalFile.conflictFile == null) continue;
            optionalFile.conflict = new OptionalFile[optionalFile.conflictFile.length];
            for (n = 0; n < optionalFile.conflictFile.length; ++n) {
                optionalFile.conflict[n] = this.getOptionalFile(optionalFile.conflictFile[n].name);
            }
        }
    }

    public OptionalFile getOptionalFile(String string) {
        for (OptionalFile optionalFile : this.updateOptional) {
            if (!optionalFile.name.equals(string)) continue;
            return optionalFile;
        }
        return null;
    }

    public Collection<String> getShared() {
        return this.updateShared;
    }

    public int getServerPort() {
        ClientProfile$ServerProfile clientProfile$ServerProfile = this.getDefaultServerProfile();
        return clientProfile$ServerProfile == null ? 25565 : clientProfile$ServerProfile.serverPort;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public ClientProfile$Version getVersion() {
        return this.version;
    }

    public void setVersion(ClientProfile$Version clientProfile$Version) {
        this.version = clientProfile$Version;
    }

    @Deprecated
    public boolean isUpdateFastCheck() {
        return true;
    }

    public String toString() {
        return String.format("%s (%s)", this.title, this.uuid);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uUID) {
        this.uuid = uUID;
    }

    public boolean hasFlag(ClientProfile$CompatibilityFlags clientProfile$CompatibilityFlags) {
        return this.flags.contains((Object)clientProfile$CompatibilityFlags);
    }

    public void verify() {
        this.getVersion();
        IOHelper.verifyFileName(this.getAssetIndex());
        VerifyHelper.verify(this.getTitle(), VerifyHelper.NOT_EMPTY, "Profile title can't be empty");
        VerifyHelper.verify(this.getInfo(), VerifyHelper.NOT_EMPTY, "Profile info can't be empty");
        VerifyHelper.verify(this.getTitle(), VerifyHelper.NOT_EMPTY, "Main class can't be empty");
        if (this.getUUID() == null) {
            throw new IllegalArgumentException("Profile UUID can't be null");
        }
        for (String object : this.update) {
            if (object != null) continue;
            throw new IllegalArgumentException("Found null entry in update");
        }
        for (String string : this.updateVerify) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in updateVerify");
        }
        for (String string : this.updateExclusions) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in updateExclusions");
        }
        for (String string : this.classPath) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in classPath");
        }
        for (String string : this.jvmArgs) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in jvmArgs");
        }
        for (String string : this.clientArgs) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in clientArgs");
        }
        for (String string : this.compatClasses) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in compatClasses");
        }
        for (OptionalFile optionalFile : this.updateOptional) {
            if (optionalFile == null) {
                throw new IllegalArgumentException("Found null entry in updateOptional");
            }
            if (optionalFile.name == null) {
                throw new IllegalArgumentException("Optional: name must not be null");
            }
            if (optionalFile.conflictFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.conflictFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.conflictFile", optionalFile.name));
                }
            }
            if (optionalFile.dependenciesFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.dependenciesFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.dependenciesFile", optionalFile.name));
                }
            }
            if (optionalFile.triggersList == null) continue;
            for (OptionalTrigger optionalTrigger : optionalFile.triggersList) {
                if (optionalTrigger != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.triggers", optionalFile.name));
            }
        }
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public void putProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public boolean containsProperty(String string) {
        return this.properties.containsKey(string);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<String> getCompatClasses() {
        return Collections.unmodifiableList(this.compatClasses);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClientProfile clientProfile = (ClientProfile)object;
        return Objects.equals(this.uuid, clientProfile.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public ClientProfile$ClassLoaderConfig getClassLoaderConfig() {
        return this.classLoaderConfig;
    }

    public void setClassLoaderConfig(ClientProfile$ClassLoaderConfig clientProfile$ClassLoaderConfig) {
        this.classLoaderConfig = clientProfile$ClassLoaderConfig;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public List<ClientProfile$CompatibilityFlags> getFlags() {
        return this.flags;
    }
}

