/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import pro.gravit.launcher.SWiXyZljuEWHtS;
import pro.gravit.launcher.swiXy70RyCWz2W;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.SecurityHelper$DigestAlgorithm;

public final class Texture
extends SWiXyZljuEWHtS {
    private static final SecurityHelper$DigestAlgorithm DIGEST_ALGO = SecurityHelper$DigestAlgorithm.SHA256;
    public final String url;
    public final byte[] digest;
    public final Map<String, String> metadata;

    public Texture(String string, boolean bl, Map<String, String> map) {
        byte[] byArray;
        this.url = IOHelper.verifyURL(string);
        try (InputStream inputStream = IOHelper.newInput(new URL(string));){
            byArray = IOHelper.read(inputStream);
        }
        inputStream = new ByteArrayInputStream(byArray);
        try {
            IOHelper.readTexture(inputStream, bl);
        }
        finally {
            ((ByteArrayInputStream)inputStream).close();
        }
        this.digest = SecurityHelper.digest(DIGEST_ALGO, byArray);
        this.metadata = map;
    }

    public Texture(String string, Path path, boolean bl, Map<String, String> map) {
        byte[] byArray;
        this.url = IOHelper.verifyURL(string);
        try (InputStream inputStream = IOHelper.newInput(path);){
            byArray = IOHelper.read(inputStream);
        }
        inputStream = new ByteArrayInputStream(byArray);
        try {
            IOHelper.readTexture(inputStream, bl);
        }
        finally {
            ((ByteArrayInputStream)inputStream).close();
        }
        this.digest = SecurityHelper.digest(DIGEST_ALGO, byArray);
        this.metadata = map;
    }

    @Deprecated
    public Texture(String string, byte[] byArray) {
        this.url = IOHelper.verifyURL(string);
        this.digest = byArray == null ? new byte[]{} : byArray;
        this.metadata = null;
    }

    public Texture(String string, byte[] byArray, Map<String, String> map) {
        this.url = string;
        this.digest = byArray == null ? new byte[]{} : byArray;
        this.metadata = map;
    }

    @Override
    public void write(swiXy70RyCWz2W swiXy70RyCWz2W2) {
        swiXy70RyCWz2W2.sWIXYvDNNFG6QS(this.url, 2048);
        swiXy70RyCWz2W2.sWIXYvDNNFG6QS(this.digest, -Texture.DIGEST_ALGO.bytes);
    }

    public String toString() {
        return "Texture{url='" + this.url + '\'' + ", digest=" + Arrays.toString(this.digest) + ", metadata=" + this.metadata + '}';
    }
}

